/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.media;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;
import org.eclipse.vtp.framework.interactions.voice.media.AudioContent;

public abstract class VoiceFormatter
implements IFormatter {
    protected static final BigDecimal ZERO = new BigDecimal("0");
    protected static final BigDecimal NEGATIVE_ONE = new BigDecimal("-1");

    protected Content getAudioContent(IResourceManager resourceManager, String path, String filename, String defaultText) {
        AudioContent ret = null;
        if (resourceManager.isFileResource(String.valueOf(path) + filename + ".vox")) {
            AudioContent ac = new AudioContent();
            ac.setStaticPath(String.valueOf(path) + filename + ".vox");
            ret = ac;
        } else if (resourceManager.isFileResource(String.valueOf(path) + filename + ".wav")) {
            AudioContent ac = new AudioContent();
            ac.setStaticPath(String.valueOf(path) + filename + ".wav");
            ret = ac;
        } else if (resourceManager.isFileResource(String.valueOf(path) + filename + ".au")) {
            AudioContent ac = new AudioContent();
            ac.setStaticPath(String.valueOf(path) + filename + ".au");
            ret = ac;
        } else {
            TextContent tc = new TextContent();
            tc.setStaticText(String.valueOf(defaultText) + " ");
            ret = tc;
        }
        return ret;
    }

    public List<Content> formatDate(Calendar cal, String formatDefinition, String formatOptions, IResourceManager resourceManager) {
        return this.formatDate(cal.getTime(), formatDefinition, formatOptions, resourceManager);
    }

    public String getDefaultFormatDefintion(FormattableContent formattable, String formatName) {
        return formatName;
    }

    public List<String> getDefaultFormats(FormattableContent formattable) {
        return Collections.emptyList();
    }
}

