/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.core.support.Widget;
import org.eclipse.vtp.framework.interactions.voice.vxml.Action;
import org.eclipse.vtp.framework.interactions.voice.vxml.FormElement;
import org.eclipse.vtp.framework.interactions.voice.vxml.If;
import org.eclipse.vtp.framework.interactions.voice.vxml.Variable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Block
extends FormElement {
    private final LinkedList<Variable> variables = new LinkedList();
    private final LinkedList<Widget> actionsAndIfClauses = new LinkedList();

    public Block(String name) throws IllegalArgumentException, NullPointerException {
        super(name);
    }

    public Block(String name, String expression) throws IllegalArgumentException, NullPointerException {
        super(name, expression);
    }

    public Block(String name, String expression, String condition) throws IllegalArgumentException, NullPointerException {
        super(name, expression, condition);
    }

    public Variable[] getVariables() {
        return this.variables.toArray(new Variable[this.variables.size()]);
    }

    public Widget[] getActionsAndIfClauses() {
        return this.actionsAndIfClauses.toArray(new Widget[this.actionsAndIfClauses.size()]);
    }

    public void addVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.add(variable);
    }

    public void removeVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.remove(variable);
    }

    public void addAction(Action action) throws NullPointerException {
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.actionsAndIfClauses.add(action);
    }

    public void removeAction(Action action) throws NullPointerException {
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.actionsAndIfClauses.remove(action);
    }

    public void addIfClause(If ifClause) throws NullPointerException {
        if (ifClause == null) {
            throw new NullPointerException("ifClause");
        }
        this.actionsAndIfClauses.add(ifClause);
    }

    public void removeIfClause(If ifClause) throws NullPointerException {
        if (ifClause == null) {
            throw new NullPointerException("ifClause");
        }
        this.actionsAndIfClauses.remove(ifClause);
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "block", "block", attributes);
        this.writeVariables(outputHandler);
        this.writeActionsAndIfClauses(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "block", "block");
    }

    protected void writeVariables(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.variables);
    }

    protected void writeActionsAndIfClauses(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        this.writeChildren(outputHandler, this.actionsAndIfClauses);
    }
}

