/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.core.support.Widget;
import org.eclipse.vtp.framework.interactions.voice.vxml.EventHandler;
import org.eclipse.vtp.framework.interactions.voice.vxml.PropertiesSupport;
import org.eclipse.vtp.framework.interactions.voice.vxml.VXMLConstants;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class Dialog
extends Widget
implements VXMLConstants {
    private String id;
    private String scope = "document";
    private final PropertiesSupport properties = new PropertiesSupport();
    private final LinkedList<EventHandler> eventHandlers = new LinkedList();

    protected Dialog(String id) throws IllegalArgumentException, NullPointerException {
        this.setID(id);
    }

    protected Dialog(String id, String scope) throws IllegalArgumentException, NullPointerException {
        this.setID(id);
        this.setScope(scope);
    }

    public String getID() {
        return this.id;
    }

    public String getScope() {
        return this.scope;
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String getPropertyValue(String propertyName) throws NullPointerException {
        return this.properties.getPropertyValue(propertyName);
    }

    EventHandler[] getEventHandlers() {
        return this.eventHandlers.toArray(new EventHandler[this.eventHandlers.size()]);
    }

    public void setID(String id) throws IllegalArgumentException, NullPointerException {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("id");
        }
        this.id = id;
    }

    public void setScope(String scope) throws IllegalArgumentException, NullPointerException {
        if (scope == null) {
            throw new NullPointerException("scope");
        }
        if (scope.equalsIgnoreCase("document")) {
            this.scope = "document";
        } else if (scope.equalsIgnoreCase("dialog")) {
            this.scope = "dialog";
        } else {
            throw new IllegalArgumentException("scope==\"" + scope + "\"");
        }
    }

    public void setProperty(String propertyName, String propertyValue) throws NullPointerException {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public void clearProperty(String propertyName) throws NullPointerException {
        this.properties.clearProperty(propertyName);
    }

    public void addEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.add(eventHandler);
    }

    public void removeEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.remove(eventHandler);
    }

    protected void writeAttributes(AttributesImpl attributes) {
        this.writeAttribute(attributes, null, null, "id", "CDATA", this.id);
        this.writeAttribute(attributes, null, null, "scope", "scope", this.scope);
    }

    protected void writeProperties(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.properties.writeWidget(outputHandler);
    }

    protected void writeEventHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.eventHandlers);
    }
}

