/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.core.support.Widget;
import org.eclipse.vtp.framework.interactions.voice.vxml.Action;
import org.eclipse.vtp.framework.interactions.voice.vxml.If;
import org.eclipse.vtp.framework.interactions.voice.vxml.Script;
import org.eclipse.vtp.framework.interactions.voice.vxml.VXMLConstants;
import org.eclipse.vtp.framework.interactions.voice.vxml.Variable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class EventHandler
extends Widget
implements VXMLConstants {
    private int count = -1;
    private String condition = null;
    private final LinkedList<Widget> actionsAndIfClauses = new LinkedList();
    private final LinkedList<Variable> variables = new LinkedList();

    protected EventHandler() {
    }

    protected EventHandler(int count) {
        this.setCount(count);
    }

    protected EventHandler(String condition) throws IllegalArgumentException {
        this.setCondition(condition);
    }

    protected EventHandler(int count, String condition) throws IllegalArgumentException {
        this.setCount(count);
        this.setCondition(condition);
    }

    public int getCount() {
        return this.count;
    }

    public String getCondition() {
        return this.condition;
    }

    public Widget[] getActionsAndIfClauses() {
        return this.actionsAndIfClauses.toArray(new Widget[this.actionsAndIfClauses.size()]);
    }

    public Variable[] getVariables() {
        return this.variables.toArray(new Variable[this.variables.size()]);
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCondition(String condition) throws IllegalArgumentException {
        if (condition != null && condition.length() == 0) {
            throw new IllegalArgumentException("condition");
        }
        this.condition = condition;
    }

    public void addVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.add(variable);
    }

    public void removeVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.remove(variable);
    }

    public void addAction(Action action) throws NullPointerException {
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.actionsAndIfClauses.add(action);
    }

    public void removeAction(Action action) throws NullPointerException {
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.actionsAndIfClauses.remove(action);
    }

    public void addScript(Script script) throws NullPointerException {
        if (script == null) {
            throw new NullPointerException("script");
        }
        this.actionsAndIfClauses.add(script);
    }

    public void removeScript(Script script) throws NullPointerException {
        if (script == null) {
            throw new NullPointerException("script");
        }
        this.actionsAndIfClauses.remove(script);
    }

    public void addIfClause(If ifClause) throws NullPointerException {
        if (ifClause == null) {
            throw new NullPointerException("ifClause");
        }
        this.actionsAndIfClauses.add(ifClause);
    }

    public void removeIfClause(If ifClause) throws NullPointerException {
        if (ifClause == null) {
            throw new NullPointerException("ifClause");
        }
        this.actionsAndIfClauses.remove(ifClause);
    }

    protected void writeAttributes(AttributesImpl attributes) {
        if (this.condition != null) {
            this.writeAttribute(attributes, null, null, "cond", "CDATA", this.condition);
        }
        if (this.count >= 0) {
            this.writeAttribute(attributes, null, null, "count", "CDATA", String.valueOf(this.count));
        }
    }

    protected void writeVariables(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.variables);
    }

    protected void writeActionsAndIfClauses(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        this.writeChildren(outputHandler, this.actionsAndIfClauses);
    }
}

