/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.voice.vxml.Goto;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Submit
extends Goto {
    private String method = "get";
    private String encodingType = null;
    private final LinkedList<String> names = new LinkedList();

    public Submit(String targetURI) {
        super(targetURI);
    }

    public Submit(String targetURI, String[] names) {
        super(targetURI);
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.addName(names[i]);
                ++i;
            }
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String[] getNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public void setMethod(String method) throws IllegalArgumentException, NullPointerException {
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (method.length() == 0) {
            throw new IllegalArgumentException("method");
        }
        this.method = method;
    }

    public void setEncodingType(String encodingType) throws IllegalArgumentException {
        if (encodingType != null && encodingType.length() == 0) {
            throw new IllegalArgumentException("encodingType");
        }
        this.encodingType = encodingType;
    }

    public void addName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        this.names.add(name);
    }

    public void removeName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        this.names.remove(name);
    }

    @Override
    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "submit", "submit", attributes);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "submit", "submit");
    }

    @Override
    protected void writeAttributes(AttributesImpl attributes) {
        super.writeAttributes(attributes);
        this.writeAttribute(attributes, null, null, "method", "CDATA", this.method);
        if (this.encodingType != null) {
            this.writeAttribute(attributes, null, null, "enctype", "CDATA", this.encodingType);
        }
        if (this.names.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            Iterator i = this.names.iterator();
            while (i.hasNext()) {
                buffer.append((String)i.next());
                if (!i.hasNext()) continue;
                buffer.append(' ');
            }
            this.writeAttribute(attributes, null, null, "namelist", "CDATA", buffer.toString());
        }
    }
}

