/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.voice.vxml.EventHandler;
import org.eclipse.vtp.framework.interactions.voice.vxml.Filled;
import org.eclipse.vtp.framework.interactions.voice.vxml.FormElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Transfer
extends FormElement {
    private String destination;
    private String maxTime = null;
    private String aai = null;
    private String transferType = "blind";
    private final LinkedList<Filled> filledHandlers = new LinkedList();
    private final LinkedList<EventHandler> eventHandlers = new LinkedList();

    public Transfer(String name, String destination) throws IllegalArgumentException, NullPointerException {
        super(name);
        this.setDestination(destination);
    }

    public Transfer(String name, String expression, String destination) throws IllegalArgumentException, NullPointerException {
        super(name, expression);
        this.setDestination(destination);
    }

    public Transfer(String name, String expression, String condition, String destination) throws IllegalArgumentException, NullPointerException {
        super(name, expression, condition);
    }

    public String getDestination() {
        return this.destination;
    }

    public String getMaxTime() {
        return this.maxTime;
    }

    public String getTransferType() {
        return this.transferType;
    }

    Filled[] getFilledHandlers() {
        return this.filledHandlers.toArray(new Filled[this.filledHandlers.size()]);
    }

    EventHandler[] getEventHandlers() {
        return this.eventHandlers.toArray(new EventHandler[this.eventHandlers.size()]);
    }

    public void setDestination(String destination) throws IllegalArgumentException, NullPointerException {
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        if (destination.length() == 0) {
            throw new IllegalArgumentException("destination");
        }
        this.destination = destination;
    }

    public void setMaxTime(String maxTime) {
        this.maxTime = maxTime;
    }

    public void setAAI(String aai) {
        this.aai = aai;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public void addFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.add(filled);
    }

    public void removeFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.remove(filled);
    }

    public void addEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.add(eventHandler);
    }

    public void removeEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.remove(eventHandler);
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "transfer", "transfer", attributes);
        this.writeFilledHandlers(outputHandler);
        this.writeEventHandlers(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "transfer", "transfer");
    }

    @Override
    protected void writeAttributes(AttributesImpl attributes) {
        super.writeAttributes(attributes);
        this.writeAttribute(attributes, null, null, "dest", "CDATA", this.destination);
        this.writeAttribute(attributes, null, null, "type", "CDATA", this.transferType);
        if (this.maxTime != null) {
            this.writeAttribute(attributes, null, null, "maxtime", "CDATA", this.maxTime);
        }
        if (this.aai != null) {
            this.writeAttribute(attributes, null, null, "aai", "CDATA", this.aai);
        }
    }

    protected void writeFilledHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.filledHandlers);
    }

    protected void writeEventHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.eventHandlers);
    }
}

