/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.javascript;

import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.common.IScriptingContext;
import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.ScriptingException;
import org.eclipse.vtp.framework.javascript.JavaScriptObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptContext
implements IScriptingContext {
    private final ClassLoader applicationClassLoader;
    private final ScriptableObject scope;

    public JavaScriptContext(ClassLoader applicationClassLoader, String scriptingLanguage, IScriptable[] scriptables) {
        this.applicationClassLoader = applicationClassLoader;
        Context ctx = Context.enter();
        try {
            this.scope = new Scope((Scriptable)ctx.initStandardObjects(), scriptables);
        }
        finally {
            Context.exit();
        }
    }

    public JavaScriptContext(IScriptable[] scriptables, JavaScriptContext owner) {
        this.applicationClassLoader = owner.applicationClassLoader;
        Context.enter();
        try {
            this.scope = new Scope((Scriptable)owner.scope, scriptables);
        }
        finally {
            Context.exit();
        }
    }

    public IScriptingContext createScriptingContext(IScriptable[] content) {
        return new JavaScriptContext(content, this);
    }

    public IScriptingEngine createScriptingEngine() {
        return new ScriptingEngine();
    }

    private final class Scope
    extends ScriptableObject {
        private static final long serialVersionUID = 1L;

        Scope(Scriptable prototype, IScriptable[] scriptables) {
            this.setPrototype(prototype);
            this.setParentScope(null);
            int i = 0;
            while (i < scriptables.length) {
                this.defineProperty(scriptables[i].getName(), (Object)new JavaScriptObject(scriptables[i]), 5);
                ++i;
            }
            this.sealObject();
        }

        public String getClassName() {
            return ((Object)((Object)this)).getClass().getName();
        }
    }

    private final class ScriptingEngine
    implements IScriptingEngine {
        private Scriptable instance = null;

        private ScriptingEngine() {
        }

        public Object execute(String script) {
            Context ctx = Context.enter();
            ctx.setOptimizationLevel(-1);
            try {
                ctx.setApplicationClassLoader(JavaScriptContext.this.applicationClassLoader);
                if (this.instance == null) {
                    this.instance = ctx.newObject((Scriptable)JavaScriptContext.this.scope);
                    this.instance.setPrototype((Scriptable)JavaScriptContext.this.scope);
                    this.instance.setParentScope(null);
                }
                Object object = JavaScriptObject.jsToJava(ctx.evaluateString(this.instance, script, "<script>", 0, null));
                return object;
            }
            catch (JavaScriptException jse) {
                if (jse.getValue() instanceof ScriptableObject) {
                    ScriptableObject error = (ScriptableObject)jse.getValue();
                    Object titleObj = ScriptableObject.getProperty((Scriptable)error, (String)"name");
                    Object descriptionObj = ScriptableObject.getProperty((Scriptable)error, (String)"message");
                    throw new ScriptingException(JavaScriptObject.jsToJava(titleObj).toString(), JavaScriptObject.jsToJava(descriptionObj).toString(), (Throwable)jse);
                }
                throw jse;
            }
            finally {
                Context.exit();
            }
        }
    }
}

