/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.javascript;

import java.util.Calendar;
import org.eclipse.vtp.framework.common.IScriptable;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class JavaScriptObject
extends ScriptableObject
implements Wrapper {
    private static final long serialVersionUID = 1L;
    private final IScriptable scriptable;
    private final String[] functionNames;

    protected static Object javaToJS(Object object, Scriptable start) {
        if (object == null) {
            return Context.getUndefinedValue();
        }
        if (object instanceof Object[]) {
            Object[] input = (Object[])object;
            Scriptable output = Context.getCurrentContext().newArray(start, input.length);
            int i = 0;
            while (i < input.length) {
                output.put(i, start, JavaScriptObject.javaToJS(input[i], start));
                ++i;
            }
            return output;
        }
        if (object instanceof IScriptable) {
            return new JavaScriptObject((IScriptable)object);
        }
        if (object instanceof Calendar) {
            return object;
        }
        return Context.javaToJS((Object)object, (Scriptable)start);
    }

    protected static Object jsToJava(Object object) {
        if (object == null) {
            return null;
        }
        if (object.equals(Context.getUndefinedValue())) {
            return null;
        }
        if (object instanceof Calendar) {
            return object;
        }
        if (object instanceof JavaScriptObject) {
            return ((JavaScriptObject)((Object)object)).scriptable;
        }
        if (object instanceof NativeJavaObject) {
            return ((NativeJavaObject)object).unwrap();
        }
        if (object instanceof Scriptable) {
            Scriptable input = (Scriptable)object;
            int count = 0;
            while (input.has(count, input)) {
                ++count;
            }
            if (count > 1) {
                Object[] output = new Object[count];
                int i = 0;
                while (i < count) {
                    output[i] = JavaScriptObject.jsToJava(input.get(i, input));
                    ++i;
                }
                return output;
            }
        }
        return Context.jsToJava((Object)object, String.class);
    }

    public JavaScriptObject(IScriptable scriptable) {
        this.scriptable = scriptable;
        this.functionNames = scriptable.getFunctionNames();
        if (this.functionNames != null) {
            int i = 0;
            while (i < this.functionNames.length) {
                if (this.functionNames[i] != null) {
                    this.defineProperty(this.functionNames[i], (Object)new Function(this.functionNames[i]), 7);
                }
                ++i;
            }
        }
        if (scriptable.hasValue()) {
            this.defineProperty("valueOf", (Object)new Function("valueOf"), 7);
        }
        if (!scriptable.isMutable()) {
            this.sealObject();
        }
    }

    public Object unwrap() {
        return this.scriptable;
    }

    public Object[] getIds() {
        Object[] parentIds = super.getIds();
        String[] ids = this.scriptable.getPropertyNames();
        Object[] allIds = new Object[parentIds.length + ids.length];
        System.arraycopy(parentIds, 0, allIds, 0, parentIds.length);
        System.arraycopy(ids, 0, allIds, parentIds.length, ids.length);
        return allIds;
    }

    public boolean has(int index, Scriptable start) {
        return this.scriptable.hasItem(index);
    }

    public boolean has(String name, Scriptable start) {
        return super.has(name, start) || this.scriptable.hasEntry(name);
    }

    public Object get(int index, Scriptable start) {
        return JavaScriptObject.javaToJS(this.scriptable.getItem(index), (Scriptable)this);
    }

    public Object get(String name, Scriptable start) {
        if (super.has(name, start)) {
            return super.get(name, start);
        }
        return JavaScriptObject.javaToJS(this.scriptable.getEntry(name), (Scriptable)this);
    }

    public void put(int index, Scriptable start, Object value) {
        this.scriptable.setItem(index, JavaScriptObject.jsToJava(value));
    }

    public void put(String name, Scriptable start, Object value) {
        if (super.has(name, start)) {
            return;
        }
        if ("valueOf".equals(name)) {
            super.put(name, start, value);
            return;
        }
        int i = 0;
        while (i < this.functionNames.length) {
            if (this.functionNames[i].equals(name)) {
                super.put(name, start, value);
                return;
            }
            ++i;
        }
        this.scriptable.setEntry(name, JavaScriptObject.jsToJava(value));
    }

    public void delete(int index) {
        this.scriptable.clearItem(index);
    }

    public void delete(String name) {
        if (!super.has(name, (Scriptable)this)) {
            this.scriptable.clearEntry(name);
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private final class Function
    extends BaseFunction {
        private static final long serialVersionUID = 1L;
        private final String name;

        Function(String name) {
            this.name = name;
        }

        public String getFunctionName() {
            return this.name;
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if ("valueOf".equals(this.name)) {
                Object value = JavaScriptObject.this.scriptable;
                while (value != null && value instanceof IScriptable) {
                    IScriptable scriptable = value;
                    value = scriptable.hasValue() ? scriptable.toValue() : null;
                }
                return JavaScriptObject.javaToJS(value, (Scriptable)this);
            }
            int i = 0;
            while (i < args.length) {
                args[i] = JavaScriptObject.jsToJava(args[i]);
                ++i;
            }
            try {
                return JavaScriptObject.javaToJS(JavaScriptObject.this.scriptable.invokeFunction(this.name, args), (Scriptable)this);
            }
            catch (Exception ex) {
                Context.throwAsScriptRuntimeEx((Throwable)ex);
                return null;
            }
        }
    }
}

