/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationDictionary
extends Dictionary
implements Comparator<String>,
Serializable {
    private static final Set RESERVED_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("service.pid", "service.factoryPid", "service.bundleLocation")));
    private static final Set<Class> SIMPLE_TYPES;
    private static final Map<String, Class> TYPES_BY_NAME;
    private static final Map NAMES_BY_TYPE;
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> properties = new TreeMap<String, Object>(this);

    static {
        HashMap<String, Class<Vector>> typesByName = new HashMap<String, Class<Vector>>(27);
        typesByName.put("boolean", Boolean.class);
        typesByName.put("byte", Byte.class);
        typesByName.put("short", Short.class);
        typesByName.put("character", Character.class);
        typesByName.put("integer", Integer.class);
        typesByName.put("float", Float.class);
        typesByName.put("long", Long.class);
        typesByName.put("double", Double.class);
        typesByName.put("string", String.class);
        SIMPLE_TYPES = Collections.unmodifiableSet(new HashSet(typesByName.values()));
        typesByName.put("booleans", Boolean[].class);
        typesByName.put("primitive-booleans", boolean[].class);
        typesByName.put("bytes", Byte[].class);
        typesByName.put("primitive-bytes", byte[].class);
        typesByName.put("shorts", Short[].class);
        typesByName.put("primitive-shorts", short[].class);
        typesByName.put("characters", Character[].class);
        typesByName.put("primitive-characters", char[].class);
        typesByName.put("integers", Integer[].class);
        typesByName.put("primitive-integers", int[].class);
        typesByName.put("floats", Float[].class);
        typesByName.put("primitive-floats", float[].class);
        typesByName.put("longs", Long[].class);
        typesByName.put("primitive-longs", long[].class);
        typesByName.put("doubles", Double[].class);
        typesByName.put("primitive-doubles", double[].class);
        typesByName.put("strings", String[].class);
        typesByName.put("vector", Vector.class);
        TYPES_BY_NAME = Collections.unmodifiableMap(typesByName);
        HashMap<Class, String> namesByType = new HashMap<Class, String>(typesByName.size());
        for (Map.Entry entry : typesByName.entrySet()) {
            namesByType.put((Class)entry.getValue(), (String)entry.getKey());
        }
        NAMES_BY_TYPE = Collections.unmodifiableMap(namesByType);
    }

    public static ConfigurationDictionary[] loadAll(Element configurations) {
        if (configurations == null || !"configurations".equals(configurations.getTagName())) {
            return null;
        }
        NodeList nodeList = configurations.getChildNodes();
        ArrayList<ConfigurationDictionary> dictionaries = new ArrayList<ConfigurationDictionary>(nodeList.getLength());
        ConfigurationDictionary dictionary = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                if (dictionary == null) {
                    dictionary = new ConfigurationDictionary();
                }
                if (dictionary.load((Element)node)) {
                    dictionaries.add(dictionary);
                    dictionary = null;
                }
            }
            ++i;
        }
        return dictionaries.toArray(new ConfigurationDictionary[dictionaries.size()]);
    }

    public static Element saveAll(Document document, ConfigurationDictionary[] dictionaries) {
        if (document == null) {
            return null;
        }
        Element configurations = document.createElement("configurations");
        if (dictionaries != null) {
            int i = 0;
            while (i < dictionaries.length) {
                Element configuration;
                if (dictionaries[i] != null && (configuration = dictionaries[i].save(document)) != null) {
                    configurations.appendChild(configuration);
                }
                ++i;
            }
        }
        return configurations;
    }

    private static Object decodeValue(Element property) {
        if (property == null) {
            return null;
        }
        Class type = TYPES_BY_NAME.get(property.getTagName());
        if (type == null) {
            return null;
        }
        if (type.equals(Vector.class)) {
            Element arrayProperty = null;
            NodeList nodeList = property.getChildNodes();
            int i = 0;
            while (arrayProperty == null && i < nodeList.getLength()) {
                if (nodeList.item(i) instanceof Element) {
                    arrayProperty = (Element)nodeList.item(i);
                }
                ++i;
            }
            if (arrayProperty == null) {
                return new Vector();
            }
            Object value = ConfigurationDictionary.decodeValue(arrayProperty);
            if (value == null || !value.getClass().isArray() || !SIMPLE_TYPES.contains(value.getClass().getComponentType())) {
                return null;
            }
            Object[] array = (Object[])value;
            Vector<Object> vector = new Vector<Object>(array.length);
            int i2 = 0;
            while (i2 < array.length) {
                vector.add(array[i2]);
                ++i2;
            }
            return vector;
        }
        if (type.isArray()) {
            LinkedList<Object> items = new LinkedList<Object>();
            NodeList nodeList = property.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                block20: {
                    if (nodeList.item(i) instanceof Element) {
                        Element item = (Element)nodeList.item(i);
                        if ("null".equals(item.getTagName()) && !type.getComponentType().isPrimitive()) {
                            items.add(null);
                        } else if ("item".equals(item.getTagName())) {
                            String string = null;
                            try {
                                string = XMLUtilities.getElementTextData(property, true);
                            }
                            catch (Exception e) {
                                break block20;
                            }
                            Object value = ConfigurationDictionary.parse(string, type.getComponentType());
                            if (value != null) {
                                items.add(value);
                            }
                        }
                    }
                }
                ++i;
            }
            Object array = Array.newInstance(type.getComponentType(), items.size());
            int i3 = 0;
            Iterator j = items.iterator();
            while (j.hasNext()) {
                Array.set(array, i3, j.next());
                ++i3;
            }
            return array;
        }
        String value = null;
        try {
            value = XMLUtilities.getElementTextData(property, true);
        }
        catch (Exception e) {
            return null;
        }
        return ConfigurationDictionary.parse(value, type);
    }

    private static Object parse(String value, Class type) {
        if (value == null || type == null || !type.isPrimitive() && !SIMPLE_TYPES.contains(type)) {
            return null;
        }
        try {
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                return Boolean.valueOf(value);
            }
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return Byte.valueOf(value);
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return Short.valueOf(value);
            }
            if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                return value.length() != 1 ? null : Character.valueOf(value.charAt(0));
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return Integer.valueOf(value);
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(value);
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return Long.valueOf(value);
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return Double.valueOf(value);
            }
            return value;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Element encodeValue(Document document, Object value) {
        if (value == null) {
            return null;
        }
        String name = (String)NAMES_BY_TYPE.get(value.getClass());
        if (name == null) {
            return null;
        }
        Element property = document.createElement(name);
        if (value instanceof Vector) {
            Vector vector = (Vector)value;
            int size = vector.size();
            if (size > 0) {
                Object element = null;
                int i = 0;
                while (element == null && i < size) {
                    element = vector.get(i);
                    ++i;
                }
                Class componentType = String.class;
                if (element != null) {
                    componentType = element.getClass();
                }
                property.appendChild(ConfigurationDictionary.encodeValue(document, vector.toArray((Object[])Array.newInstance(componentType, size))));
            }
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            int i = 0;
            while (i < length) {
                Object element = Array.get(value, i);
                if (element == null) {
                    property.appendChild(document.createElement("null"));
                } else {
                    Element item = document.createElement("item");
                    item.appendChild(document.createTextNode(element.toString()));
                    property.appendChild(item);
                }
                ++i;
            }
        } else {
            property.appendChild(document.createTextNode(value.toString()));
        }
        return property;
    }

    private static Object cloneValue(Object input) {
        if (input == null) {
            return null;
        }
        if (input.getClass().equals(Vector.class)) {
            return new Vector((Vector)input);
        }
        if (!input.getClass().isArray()) {
            return input;
        }
        int length = Array.getLength(input);
        Object output = Array.newInstance(input.getClass().getComponentType(), length);
        System.arraycopy(input, 0, output, 0, length);
        return output;
    }

    public ConfigurationDictionary() {
    }

    public ConfigurationDictionary(String pid) {
        this.setPid(pid);
    }

    public ConfigurationDictionary(String pid, String factoryPid) {
        this.setPid(pid);
        this.setFactoryPid(factoryPid);
    }

    public ConfigurationDictionary(String pid, String factoryPid, String bundleLocation) {
        this.setPid(pid);
        this.setFactoryPid(factoryPid);
        this.setBundleLocation(bundleLocation);
    }

    public ConfigurationDictionary(Element configuration) throws NullPointerException {
        this.load(configuration);
    }

    public synchronized String getPid() {
        return (String)this.properties.get("service.pid");
    }

    public synchronized String getFactoryPid() {
        return (String)this.properties.get("service.factoryPid");
    }

    public synchronized String getBundleLocation() {
        return (String)this.properties.get("service.bundleLocation");
    }

    public synchronized void setPid(String pid) {
        if (pid == null || pid.length() == 0) {
            this.properties.remove("service.pid");
        } else {
            this.properties.put("service.pid", pid);
        }
    }

    public synchronized void setFactoryPid(String factoryPid) {
        if (factoryPid == null || factoryPid.length() == 0) {
            this.properties.remove("service.factoryPid");
        } else {
            this.properties.put("service.factoryPid", factoryPid);
        }
    }

    public synchronized void setBundleLocation(String bundleLocation) {
        if (bundleLocation == null || bundleLocation.length() == 0) {
            this.properties.remove("service.bundleLocation");
        } else {
            this.properties.put("service.bundleLocation", bundleLocation);
        }
    }

    public synchronized boolean load(Element configuration) {
        if (configuration == null) {
            this.properties.clear();
            return true;
        }
        if (!"configuration".equals(configuration.getTagName())) {
            return false;
        }
        this.properties.clear();
        this.setPid(configuration.getAttribute("pid"));
        this.setFactoryPid(configuration.getAttribute("factoryPid"));
        this.setBundleLocation(configuration.getAttribute("bundleLocation"));
        NodeList list = configuration.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Object value;
            Element property;
            String key;
            if (list.item(i) instanceof Element && (key = (property = (Element)list.item(i)).getAttribute("key")) != null && key.length() != 0 && !RESERVED_KEYS.contains(key) && (value = ConfigurationDictionary.decodeValue(property)) != null) {
                this.properties.put(key, value);
            }
            ++i;
        }
        return true;
    }

    public synchronized Element save(Document document) {
        String bundleLocation;
        String factoryPid;
        if (document == null) {
            return null;
        }
        Element configuration = document.createElement("configuration");
        String pid = this.getPid();
        if (pid != null) {
            configuration.setAttribute("pid", pid);
        }
        if ((factoryPid = this.getFactoryPid()) != null) {
            configuration.setAttribute("factoryPid", factoryPid);
        }
        if ((bundleLocation = this.getBundleLocation()) != null) {
            configuration.setAttribute("bundleLocation", bundleLocation);
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Element property;
            String key = entry.getKey();
            if (RESERVED_KEYS.contains(key) || (property = ConfigurationDictionary.encodeValue(document, entry.getValue())) == null) continue;
            property.setAttribute("key", key);
            configuration.appendChild(property);
        }
        return configuration;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.properties.size();
    }

    public synchronized Enumeration keys() {
        return Collections.enumeration(new ArrayList<String>(this.properties.keySet()));
    }

    public synchronized Enumeration elements() {
        final Enumeration<Object> e = Collections.enumeration(new ArrayList<Object>(this.properties.values()));
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return e.hasMoreElements();
            }

            public Object nextElement() {
                return ConfigurationDictionary.cloneValue(e.nextElement());
            }
        };
    }

    public synchronized Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!(key instanceof String) || ((String)key).length() == 0) {
            throw new IllegalArgumentException("key");
        }
        return ConfigurationDictionary.cloneValue(this.properties.get(key));
    }

    public synchronized Object put(Object key, Object value) {
        Vector v;
        int size;
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!(key instanceof String) || ((String)key).length() == 0) {
            throw new IllegalArgumentException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (!NAMES_BY_TYPE.containsKey(value.getClass())) {
            throw new IllegalArgumentException("value");
        }
        if (RESERVED_KEYS.contains(key)) {
            return ConfigurationDictionary.cloneValue(this.properties.get(key));
        }
        if (value instanceof Vector && (size = (v = (Vector)value).size()) > 0) {
            Object element = null;
            int index = 0;
            while (element == null && index < size) {
                element = v.get(index);
                ++index;
            }
            if (element != null) {
                Class<?> type = element.getClass();
                if (!SIMPLE_TYPES.contains(type)) {
                    throw new IllegalArgumentException("value[" + index + "]");
                }
                ++index;
                while (index < size) {
                    Object other = v.get(index);
                    if (other != null && !type.equals(other.getClass())) {
                        throw new IllegalArgumentException("value[" + index + "]");
                    }
                    ++index;
                }
            }
        }
        return this.properties.put((String)key, ConfigurationDictionary.cloneValue(value));
    }

    public synchronized Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!(key instanceof String) || ((String)key).length() == 0) {
            throw new IllegalArgumentException("key");
        }
        if (RESERVED_KEYS.contains(key)) {
            return ConfigurationDictionary.cloneValue(this.properties.get(key));
        }
        return ConfigurationDictionary.cloneValue(this.properties.remove(key));
    }

    @Override
    public int compare(String left, String right) {
        return left.compareToIgnoreCase(right);
    }
}

