/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.util;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.vtp.framework.util.ConfigurationDictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Element;

public class StaticConfigurationAdmin {
    private final BundleContext context;
    private final LogService log;
    private final ConfigurationTargetTracker tracker;
    private volatile Dispatcher dispatcher = null;
    private final Map services;
    private final Map factories;
    private final Map pidsByReference = new HashMap();

    private static Dictionary copy(Dictionary input) {
        if (input == null) {
            return null;
        }
        Hashtable output = new Hashtable(input.size());
        Enumeration e = input.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ((Dictionary)output).put(key, input.get(key));
        }
        return output;
    }

    private static String pid(ServiceReference reference) {
        Object pid = reference.getProperty("service.pid");
        if (pid instanceof String) {
            return (String)pid;
        }
        return null;
    }

    public StaticConfigurationAdmin(BundleContext context, LogService log, Element configurationsData) {
        this.context = context;
        this.log = log;
        this.tracker = new ConfigurationTargetTracker(context);
        HashMap<String, ConfigurationDictionary> services = new HashMap<String, ConfigurationDictionary>();
        HashMap<String, HashMap<String, ConfigurationDictionary>> factories = new HashMap<String, HashMap<String, ConfigurationDictionary>>();
        ConfigurationDictionary[] dictionaries = ConfigurationDictionary.loadAll(configurationsData);
        int i = 0;
        while (i < dictionaries.length) {
            String string = dictionaries[i].getPid();
            if (string != null) {
                String factoryPid = dictionaries[i].getFactoryPid();
                if (factoryPid == null) {
                    services.put(string, dictionaries[i]);
                } else {
                    HashMap<String, ConfigurationDictionary> factoryIndex = (HashMap<String, ConfigurationDictionary>)factories.get(factoryPid);
                    if (factoryIndex == null) {
                        factoryIndex = new HashMap<String, ConfigurationDictionary>();
                        factories.put(factoryPid, factoryIndex);
                    }
                    factoryIndex.put(string, dictionaries[i]);
                }
            }
            ++i;
        }
        this.services = Collections.unmodifiableMap(new HashMap(services));
        for (Map.Entry entry : factories.entrySet()) {
            Map factoryIndex = (Map)entry.getValue();
            entry.setValue(factoryIndex.values().toArray(new ConfigurationDictionary[factoryIndex.size()]));
        }
        this.factories = Collections.unmodifiableMap(new HashMap(factories));
    }

    public synchronized void start() {
        if (this.dispatcher != null) {
            return;
        }
        this.dispatcher = new Dispatcher();
        boolean failed = true;
        try {
            this.tracker.open();
            this.dispatcher.start();
            failed = false;
        }
        finally {
            if (failed) {
                this.stop();
            }
        }
    }

    public synchronized void stop() {
        if (this.dispatcher == null) {
            return;
        }
        try {
            this.dispatcher.stop();
        }
        finally {
            try {
                this.tracker.close();
            }
            finally {
                this.dispatcher = null;
                this.pidsByReference.clear();
            }
        }
    }

    private void added(ServiceReference reference, boolean factory) {
        String pid = StaticConfigurationAdmin.pid(reference);
        if (pid == null) {
            return;
        }
        this.pidsByReference.put(reference, pid);
        this.dispatch(reference, pid, factory);
    }

    private void modified(ServiceReference reference, boolean factory) {
        String newPid;
        String oldPid = (String)this.pidsByReference.get(reference);
        if (oldPid == (newPid = StaticConfigurationAdmin.pid(reference))) {
            return;
        }
        if (newPid == null) {
            this.pidsByReference.remove(reference);
        } else {
            if (newPid.equals(oldPid)) {
                return;
            }
            this.pidsByReference.put(reference, newPid);
            this.dispatch(reference, newPid, factory);
        }
    }

    private void removed(ServiceReference reference, boolean factory) {
        this.pidsByReference.remove(reference);
    }

    private void dispatch(ServiceReference reference, String pid, boolean factory) {
        Object instance = null;
        try {
            if (factory) {
                ConfigurationDictionary[] configs = (ConfigurationDictionary[])this.factories.get(pid);
                if (configs == null) {
                    return;
                }
                instance = this.context.getService(reference);
                if (instance instanceof ManagedServiceFactory) {
                    this.configure(reference.getBundle().getLocation(), (ManagedServiceFactory)instance, configs);
                }
            } else {
                ConfigurationDictionary config = (ConfigurationDictionary)this.services.get(pid);
                instance = this.context.getService(reference);
                if (instance instanceof ManagedService) {
                    this.configure(reference.getBundle().getLocation(), (ManagedService)instance, config);
                }
            }
        }
        finally {
            if (instance != null) {
                this.context.ungetService(reference);
            }
        }
    }

    private void configure(String bundleLocation, ManagedService service, ConfigurationDictionary serviceConfiguration) {
        Dictionary dictionary;
        if (serviceConfiguration != null) {
            if (serviceConfiguration.getBundleLocation() == null) {
                serviceConfiguration.setBundleLocation(bundleLocation);
            } else if (!serviceConfiguration.getBundleLocation().equals(bundleLocation)) {
                return;
            }
        }
        if ((dictionary = StaticConfigurationAdmin.copy(serviceConfiguration)) != null) {
            dictionary.remove("service.bundleLocation");
        }
        try {
            service.updated(dictionary);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void configure(String bundleLocation, ManagedServiceFactory serviceFactory, ConfigurationDictionary[] serviceFactoryConfiguration) {
        int i = 0;
        while (i < serviceFactoryConfiguration.length) {
            block7: {
                block6: {
                    block5: {
                        if (serviceFactoryConfiguration[i].getBundleLocation() != null) break block5;
                        serviceFactoryConfiguration[i].setBundleLocation(bundleLocation);
                        break block6;
                    }
                    if (!serviceFactoryConfiguration[i].getBundleLocation().equals(bundleLocation)) break block7;
                }
                Dictionary dictionary = StaticConfigurationAdmin.copy(serviceFactoryConfiguration[i]);
                dictionary.remove("service.bundleLocation");
                try {
                    serviceFactory.updated(serviceFactoryConfiguration[i].getPid(), dictionary);
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
            ++i;
        }
    }

    private void error(Exception e) {
        this.log.log(1, e.getMessage(), (Throwable)e);
    }

    private final class ConfigurationTargetTracker {
        private final ServiceTracker serviceTracker;
        private final ServiceTracker serviceFactoryTracker;

        ConfigurationTargetTracker(BundleContext context) {
            this.serviceTracker = new ServiceTracker(context, ManagedService.class.getName(), null){

                public Object addingService(ServiceReference reference) {
                    ConfigurationTargetTracker.this.doAddingService(reference, false);
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    ConfigurationTargetTracker.this.doModifiedService(reference, false);
                }

                public void removedService(ServiceReference reference, Object service) {
                    ConfigurationTargetTracker.this.doRemovedService(reference, false);
                }
            };
            this.serviceFactoryTracker = new ServiceTracker(context, ManagedServiceFactory.class.getName(), null){

                public Object addingService(ServiceReference reference) {
                    ConfigurationTargetTracker.this.doAddingService(reference, true);
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    ConfigurationTargetTracker.this.doModifiedService(reference, true);
                }

                public void removedService(ServiceReference reference, Object service) {
                    ConfigurationTargetTracker.this.doRemovedService(reference, true);
                }
            };
        }

        void open() {
            this.serviceTracker.open();
            this.serviceFactoryTracker.open();
        }

        void close() {
            try {
                this.serviceFactoryTracker.close();
            }
            finally {
                this.serviceTracker.close();
            }
        }

        private void doAddingService(final ServiceReference reference, final boolean factory) {
            Dispatcher dispatcher = StaticConfigurationAdmin.this.dispatcher;
            if (dispatcher != null) {
                dispatcher.enqueue(new Runnable(){

                    @Override
                    public void run() {
                        StaticConfigurationAdmin.this.added(reference, factory);
                    }
                });
            }
        }

        private void doModifiedService(final ServiceReference reference, final boolean factory) {
            Dispatcher dispatcher = StaticConfigurationAdmin.this.dispatcher;
            if (dispatcher != null) {
                dispatcher.enqueue(new Runnable(){

                    @Override
                    public void run() {
                        StaticConfigurationAdmin.this.modified(reference, factory);
                    }
                });
            }
        }

        private void doRemovedService(final ServiceReference reference, final boolean factory) {
            Dispatcher dispatcher = StaticConfigurationAdmin.this.dispatcher;
            if (dispatcher != null) {
                dispatcher.enqueue(new Runnable(){

                    @Override
                    public void run() {
                        StaticConfigurationAdmin.this.removed(reference, factory);
                    }
                });
            }
        }
    }

    private final class Dispatcher
    implements Runnable {
        private final LinkedList queue = new LinkedList();
        private int state = 0;

        private Dispatcher() {
        }

        synchronized void start() {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
            new Thread(this).start();
            while (this.state != 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        synchronized void enqueue(Runnable runnable) {
            if (this.state > 2) {
                return;
            }
            this.queue.addLast(runnable);
            this.notify();
        }

        synchronized void stop() {
            if (this.state != 2) {
                return;
            }
            this.state = 3;
            this.queue.clear();
            this.notify();
            while (this.state != 4) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Dispatcher dispatcher = this;
            synchronized (dispatcher) {
                if (this.state != 1) {
                    return;
                }
                this.state = 2;
                this.notify();
            }
            while (true) {
                Runnable next = null;
                Dispatcher dispatcher2 = this;
                synchronized (dispatcher2) {
                    while (true) {
                        if (this.state != 2 || !this.queue.isEmpty()) {
                            if (this.state == 2) {
                                next = (Runnable)this.queue.removeFirst();
                            }
                            break;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (next == null) {
                    dispatcher = this;
                    synchronized (dispatcher) {
                        this.state = 4;
                        this.notify();
                        return;
                    }
                }
                try {
                    next.run();
                }
                catch (Exception e) {
                    StaticConfigurationAdmin.this.error(e);
                    continue;
                }
                break;
            }
        }
    }
}

