/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtilities {
    public static String encodeAttribute(String toEncode) {
        StringBuffer buffer = new StringBuffer();
        char[] cs = toEncode.toCharArray();
        int i = 0;
        while (i < cs.length) {
            switch (cs[i]) {
                case '\'': {
                    buffer.append("&apos;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                default: {
                    buffer.append(cs[i]);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String encodeText(String toEncode) {
        StringBuffer buffer = new StringBuffer();
        char[] cs = toEncode.toCharArray();
        int i = 0;
        while (i < cs.length) {
            switch (cs[i]) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                default: {
                    buffer.append(cs[i]);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static NodeList getNamedNodeList(Element parent, String containerTagName) throws Exception {
        NodeList nl = parent.getElementsByTagName(containerTagName);
        if (nl.getLength() < 1) {
            throw new Exception("Missing named list: " + containerTagName);
        }
        return nl.item(0).getChildNodes();
    }

    public static Element[] getElementsOfNodeList(NodeList nodeList) {
        Element[] ret = null;
        Vector<Node> v = new Vector<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node item = nodeList.item(n);
            if (item.getNodeType() == 1) {
                v.addElement(item);
            }
            ++n;
        }
        ret = new Element[v.size()];
        n = 0;
        while (n < ret.length) {
            ret[n] = (Element)v.elementAt(n);
            ++n;
        }
        return ret;
    }

    public static String getWrappedTextData(Element parent, String childTagName) throws Exception {
        NodeList nl = parent.getElementsByTagName(childTagName);
        if (nl.getLength() < 1) {
            return null;
        }
        Element childElement = (Element)nl.item(0);
        return XMLUtilities.getElementTextData(childElement, true);
    }

    public static String getElementTextData(Element element) throws Exception {
        if (!element.hasChildNodes()) {
            throw new Exception("Element has no children.");
        }
        Node n = element.getFirstChild();
        if (n.getNodeType() != 3 && n.getNodeType() != 4) {
            throw new Exception("Element child node is not textual.");
        }
        CharacterData value = (CharacterData)n;
        return value.getData();
    }

    public static String getElementTextDataNoEx(Element element) {
        String ret = null;
        try {
            ret = XMLUtilities.getElementTextData(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String getElementTextData(Element element, boolean unindent) throws Exception {
        String result = XMLUtilities.getElementTextData(element);
        if (unindent) {
            result = XMLUtilities.unindentTextData(result);
        }
        return result;
    }

    public static String getElementTextDataNoEx(Element element, boolean unindent) {
        String result = null;
        try {
            result = XMLUtilities.getElementTextData(element);
            if (unindent) {
                result = XMLUtilities.unindentTextData(result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static List<Element> getElementsByTagName(Element parent, String name, boolean localOnly) {
        ArrayList<Element> ret = new ArrayList<Element>();
        if (!localOnly) {
            NodeList elementList = parent.getElementsByTagName(name);
            int i = 0;
            while (i < elementList.getLength()) {
                ret.add((Element)elementList.item(i));
                ++i;
            }
        } else {
            NodeList childList = parent.getChildNodes();
            int i = 0;
            while (i < childList.getLength()) {
                Element child;
                if (childList.item(i).getNodeType() == 1 && (child = (Element)childList.item(i)).getTagName().equals(name)) {
                    ret.add(child);
                }
                ++i;
            }
        }
        return ret;
    }

    public static List<Element> getChildElements(Element parent) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList childList = parent.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            if (childList.item(i).getNodeType() == 1) {
                Element child = (Element)childList.item(i);
                ret.add(child);
            }
            ++i;
        }
        return ret;
    }

    public static List<Element> getChildElementsNS(Element parent, String uri) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList childList = parent.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            Element child;
            if (childList.item(i).getNodeType() == 1 && (child = (Element)childList.item(i)).getNamespaceURI().equals(uri)) {
                ret.add(child);
            }
            ++i;
        }
        return ret;
    }

    public static List<Element> getElementsByTagNameNS(Element parent, String uri, String name, boolean localOnly) {
        ArrayList<Element> ret = new ArrayList<Element>();
        if (!localOnly) {
            NodeList elementList = parent.getElementsByTagNameNS(uri, name);
            int i = 0;
            while (i < elementList.getLength()) {
                ret.add((Element)elementList.item(i));
                ++i;
            }
        } else {
            NodeList childList = parent.getChildNodes();
            int i = 0;
            while (i < childList.getLength()) {
                if (childList.item(i).getNodeType() == 1) {
                    Element child = (Element)childList.item(i);
                    if ((uri.equals("*") || child.getNamespaceURI().equals(uri)) && (child.getLocalName() == null && uri.equals("*") && child.getTagName().equals(name) || child.getLocalName().equals(name))) {
                        ret.add(child);
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static String unindentTextData(String text) {
        start = 0;
        while (start < text.length()) {
            if (!Character.isWhitespace(text.charAt(start))) break;
            ++start;
        }
        if (start == text.length()) {
            return "";
        }
        while (true) {
            if (text.charAt(start) == '\n') {
                ++start;
                break;
            }
            if (start == 0) break;
            --start;
        }
        end = text.length();
        while (Character.isWhitespace(text.charAt(end - 1))) {
            --end;
        }
        while (true) {
            if (text.charAt(end - 1) == '\n') {
                if (text.charAt(--end - 1) != '\r') break;
                --end;
                break;
            }
            if (end == text.length()) break;
            ++end;
        }
        indentLength = 0;
        while (Character.isWhitespace(text.charAt(start + indentLength))) {
            ++indentLength;
        }
        index = start + indentLength;
        lineCount = 1;
        while (true) {
            if (indentLength != 0) ** GOTO lbl37
            return text.substring(start, end);
lbl-1000:
            // 1 sources

            {
                ++index;
lbl37:
                // 2 sources

                ** while (index < end && text.charAt((int)index) != '\n')
            }
lbl38:
            // 1 sources

            if (++index >= end) break;
            ++lineCount;
            i = 0;
            while (i < indentLength) {
                if (text.charAt(start + i) != text.charAt(index + i)) {
                    indentLength = i;
                }
                ++i;
            }
            index += indentLength;
        }
        result = new StringBuffer(end - start - indentLength * lineCount);
        i = start;
        j = 0;
        ** GOTO lbl62
        {
            ++i;
            ++j;
            do {
                if (j < indentLength) continue block8;
                c = text.charAt(i);
                result.append(c);
                if (c == '\n') {
                    j = 0;
                }
                ++i;
lbl62:
                // 2 sources

            } while (i < end);
        }
        return result.toString();
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static Document loadDocument(File documentFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = XMLUtilities.getDocumentBuilder();
        return documentBuilder.parse(documentFile);
    }
}

