/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.util;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLWriter
implements ContentHandler {
    private OutputStream output = null;
    private char indentCharacter = (char)9;
    private char deepIndentCharacter = (char)32;
    private int indentSize = 1;
    private int deepIndentSize = 4;
    private int elementDepth = 0;
    private final Map<String, Object> namespaceURIsByPrefix = new HashMap<String, Object>();
    private final Map<String, Object> prefixesByNamespaceURI = new HashMap<String, Object>();
    private final Set<String> newPrefixes = new LinkedHashSet<String>();
    private boolean parentElementIncomplete = false;
    private boolean afterCDATA = false;
    private boolean compactElements = false;
    private boolean afterEndElement = false;

    public XMLWriter() {
    }

    public XMLWriter(OutputStream output) {
        this.setOutput(output);
    }

    public void setCompactElements(boolean compactElements) {
        this.compactElements = compactElements;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public void setIndentCharacter(char indentCharacter) {
        this.indentCharacter = indentCharacter;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize < 0 ? 0 : indentSize;
    }

    public void setDeepIndentSize(int deepIndentSize) {
        this.deepIndentSize = deepIndentSize < 0 ? 0 : deepIndentSize;
    }

    public Result toXMLResult() {
        return new SAXResult(this);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.afterEndElement = false;
        this.elementDepth = 0;
        this.namespaceURIsByPrefix.clear();
        this.prefixesByNamespaceURI.clear();
        this.newPrefixes.clear();
        this.parentElementIncomplete = false;
        this.afterCDATA = false;
        try {
            this.output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n".getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.afterEndElement = false;
        try {
            this.output.write("\r".getBytes("UTF-8"));
            this.output.write("\n".getBytes("UTF-8"));
            this.afterCDATA = false;
            this.parentElementIncomplete = false;
            this.newPrefixes.clear();
            this.prefixesByNamespaceURI.clear();
            this.namespaceURIsByPrefix.clear();
            this.elementDepth = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.stackedIndexPush(this.namespaceURIsByPrefix, prefix, uri);
        this.stackedIndexPush(this.prefixesByNamespaceURI, uri, prefix);
        this.newPrefixes.remove(prefix);
        this.newPrefixes.add(prefix);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        String uri = this.stackedIndexPop(this.namespaceURIsByPrefix, prefix);
        this.stackedIndexRemove(this.prefixesByNamespaceURI, uri, prefix);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.afterEndElement = false;
        try {
            this.ensureParentElementIsComplete();
            this.output.write("\r".getBytes("UTF-8"));
            this.output.write("\n".getBytes("UTF-8"));
            this.indent();
            this.output.write("<".getBytes("UTF-8"));
            this.writeName(uri, localName, name);
            for (String prefix : this.newPrefixes) {
                this.output.write("\r".getBytes("UTF-8"));
                this.output.write("\n".getBytes("UTF-8"));
                this.deepIndent();
                String xmlns = this.stackedIndexPeek(this.namespaceURIsByPrefix, prefix);
                if (prefix.length() == 0) {
                    this.writeNameValuePair(null, null, "xmlns", xmlns);
                    continue;
                }
                this.writeNameValuePair(null, null, "xmlns:" + prefix, xmlns);
            }
            this.newPrefixes.clear();
            int i = 0;
            while (i < atts.getLength()) {
                if (!"http://www.w3.org/2000/xmlns/".equals(atts.getURI(i))) {
                    if (!this.compactElements) {
                        this.output.write("\r".getBytes("UTF-8"));
                        this.output.write("\n".getBytes("UTF-8"));
                        this.deepIndent();
                    }
                    this.writeNameValuePair(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getValue(i));
                }
                ++i;
            }
            this.parentElementIncomplete = true;
            this.afterCDATA = false;
            ++this.elementDepth;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            --this.elementDepth;
            if (this.parentElementIncomplete) {
                this.output.write(" />".getBytes("UTF-8"));
                this.parentElementIncomplete = false;
            } else {
                if (!this.compactElements || this.afterEndElement) {
                    this.output.write("\r".getBytes("UTF-8"));
                    this.output.write("\n".getBytes("UTF-8"));
                    this.indent();
                }
                this.output.write("</".getBytes("UTF-8"));
                this.writeName(uri, localName, name);
                this.output.write(">".getBytes("UTF-8"));
            }
            this.afterCDATA = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.afterEndElement = true;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.afterEndElement = true;
        try {
            this.ensureParentElementIsComplete();
            this.output.write("\r".getBytes("UTF-8"));
            this.output.write("\n".getBytes("UTF-8"));
            this.indent();
            this.output.write("<?".getBytes("UTF-8"));
            this.output.write(target.getBytes("UTF-8"));
            this.output.write(" ".getBytes("UTF-8"));
            this.output.write(data.getBytes("UTF-8"));
            this.output.write(" ?>".getBytes("UTF-8"));
            this.afterCDATA = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (!this.afterCDATA) {
                this.ensureParentElementIsComplete();
                if (!this.compactElements) {
                    this.output.write("\r".getBytes("UTF-8"));
                    this.output.write("\n".getBytes("UTF-8"));
                    this.indent();
                }
            }
            boolean hadCR = false;
            int i = 0;
            while (i < length) {
                char c = ch[start + i];
                if (c == '\n' || hadCR) {
                    hadCR = false;
                    this.output.write("\r".getBytes("UTF-8"));
                    this.output.write("\n".getBytes("UTF-8"));
                    this.indent();
                    if (c != '\n') {
                        this.output.write(Character.toString(c).getBytes("UTF-8"));
                    }
                } else {
                    switch (c) {
                        case '\r': {
                            hadCR = true;
                            break;
                        }
                        case '\'': {
                            this.output.write("&apos;".getBytes("UTF-8"));
                            break;
                        }
                        case '\"': {
                            this.output.write("&quot;".getBytes("UTF-8"));
                            break;
                        }
                        case '&': {
                            this.output.write("&amp;".getBytes("UTF-8"));
                            break;
                        }
                        case '<': {
                            this.output.write("&lt;".getBytes("UTF-8"));
                            break;
                        }
                        case '>': {
                            this.output.write("&gt;".getBytes("UTF-8"));
                            break;
                        }
                        default: {
                            this.output.write(Character.toString(c).getBytes("UTF-8"));
                        }
                    }
                }
                ++i;
            }
            if (hadCR) {
                this.output.write("\r".getBytes("UTF-8"));
                this.output.write("\n".getBytes("UTF-8"));
            }
            this.afterCDATA = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private void ensureParentElementIsComplete() {
        if (this.parentElementIncomplete) {
            try {
                this.output.write(">".getBytes("UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.parentElementIncomplete = false;
        }
    }

    private void indent() {
        try {
            int i = 0;
            while (i < this.elementDepth) {
                int j = 0;
                while (j < this.indentSize) {
                    this.output.write(Character.toString(this.indentCharacter).getBytes("UTF-8"));
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deepIndent() {
        try {
            this.indent();
            int i = 0;
            while (i < this.deepIndentSize) {
                this.output.write(Character.toString(this.deepIndentCharacter).getBytes("UTF-8"));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeName(String uri, String localName, String qualifiedName) {
        try {
            if (uri == null || uri.length() == 0) {
                if (qualifiedName == null || qualifiedName.length() == 0) {
                    this.output.write(localName.getBytes("UTF-8"));
                } else {
                    this.output.write(qualifiedName.getBytes("UTF-8"));
                }
            } else if (localName == null || localName.length() == 0) {
                this.output.write(qualifiedName.getBytes("UTF-8"));
            } else {
                String prefix = this.stackedIndexPeek(this.prefixesByNamespaceURI, uri);
                if (prefix == null || prefix.length() == 0) {
                    this.output.write(localName.getBytes("UTF-8"));
                } else {
                    this.output.write(prefix.getBytes("UTF-8"));
                    this.output.write(":".getBytes("UTF-8"));
                    this.output.write(localName.getBytes("UTF-8"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeNameValuePair(String uri, String localName, String qualifiedName, String value) {
        try {
            if (this.compactElements) {
                this.output.write(" ".getBytes("UTF-8"));
            }
            this.writeName(uri, localName, qualifiedName);
            this.output.write("=".getBytes("UTF-8"));
            this.output.write("\"".getBytes("UTF-8"));
            if (value != null) {
                int i = 0;
                while (i < value.length()) {
                    switch (value.charAt(i)) {
                        case '\"': {
                            this.output.write("&quot;".getBytes("UTF-8"));
                            break;
                        }
                        case '&': {
                            this.output.write("&amp;".getBytes("UTF-8"));
                            break;
                        }
                        case '<': {
                            this.output.write("&lt;".getBytes("UTF-8"));
                            break;
                        }
                        case '>': {
                            this.output.write("&gt;".getBytes("UTF-8"));
                            break;
                        }
                        default: {
                            this.output.write(Character.toString(value.charAt(i)).getBytes("UTF-8"));
                        }
                    }
                    ++i;
                }
            }
            this.output.write("\"".getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stackedIndexPush(Map<String, Object> index, String key, String value) {
        Object stack = index.get(key);
        if (stack == null) {
            index.put(key, value);
        } else {
            LinkedList<String> values = null;
            if (stack instanceof String) {
                values = new LinkedList<String>();
                values.addFirst((String)stack);
                index.put(key, values);
            } else {
                values = (LinkedList<String>)stack;
            }
            values.addFirst(value);
        }
    }

    private String stackedIndexPeek(Map<String, Object> index, String key) {
        Object stack = index.get(key);
        if (stack == null) {
            return null;
        }
        if (stack instanceof String) {
            return (String)stack;
        }
        return (String)((LinkedList)stack).getFirst();
    }

    private String stackedIndexPop(Map<String, Object> index, String key) {
        Object stack = index.get(key);
        if (stack == null) {
            return null;
        }
        if (stack instanceof String) {
            index.remove(key);
            return (String)stack;
        }
        LinkedList values = (LinkedList)stack;
        String value = (String)values.removeFirst();
        if (values.isEmpty()) {
            index.remove(key);
        }
        return value;
    }

    private void stackedIndexRemove(Map<String, Object> index, String key, String value) {
        Object stack = index.get(key);
        if (stack == null) {
            return;
        }
        if (stack instanceof String) {
            if (stack.equals(value)) {
                index.remove(key);
            }
        } else {
            LinkedList values = (LinkedList)stack;
            values.remove(value);
            if (values.isEmpty()) {
                index.remove(key);
            }
        }
    }
}

