/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.actions;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.vtp.framework.common.IArrayObject;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceConfiguration;
import org.eclipse.vtp.framework.webservices.configurations.document.BindingValue;
import org.eclipse.vtp.framework.webservices.configurations.document.ConditionalContainerSet;
import org.eclipse.vtp.framework.webservices.configurations.document.ConditionalDocumentItem;
import org.eclipse.vtp.framework.webservices.configurations.document.DocumentItem;
import org.eclipse.vtp.framework.webservices.configurations.document.DocumentItemContainer;
import org.eclipse.vtp.framework.webservices.configurations.document.ElementAttributeDocumentItem;
import org.eclipse.vtp.framework.webservices.configurations.document.ElementDocumentItem;
import org.eclipse.vtp.framework.webservices.configurations.document.ElseDocumentItem;
import org.eclipse.vtp.framework.webservices.configurations.document.ForLoopDocumentItem;
import org.eclipse.vtp.framework.webservices.configurations.document.InputDocumentStructure;
import org.eclipse.vtp.framework.webservices.configurations.document.TextDocumentItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebServiceCallAction
implements IAction {
    public static final String SOAP_ENVELOPE_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    private final IActionContext context;
    private final IVariableRegistry variables;
    private final WebServiceConfiguration configuration;
    private final IScriptingService scriptingService;
    private final IBrandSelection brandSelection;

    public WebServiceCallAction(IActionContext context, IVariableRegistry variables, IScriptingService scriptingService, IBrandSelection brandSelection, WebServiceConfiguration configuration) {
        this.context = context;
        this.variables = variables;
        this.scriptingService = scriptingService;
        this.brandSelection = brandSelection;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        Hashtable<String, String> props;
        block19: {
            if (this.context.isReportingEnabled()) {
                props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "wscall.before");
                this.context.report(3, "Calling web service...", props);
            }
            try {
                StringBuilder payload = new StringBuilder();
                payload.append("<SOAP-ENV:Envelope");
                payload.append(" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">");
                payload.append("<SOAP-ENV:Body>");
                InputDocumentStructure structure = this.configuration.getInputStructure();
                this.processDocumentItemContainer(payload, structure);
                payload.append("</SOAP-ENV:Body>");
                payload.append("</SOAP-ENV:Envelope>");
                URL url = null;
                String urlType = this.configuration.getURLType();
                if (urlType.equals("static")) {
                    url = new URL(this.configuration.getURL());
                } else if (urlType.equals("variable")) {
                    url = new URL(String.valueOf(this.variables.getVariable(this.configuration.getURL())));
                } else {
                    IScriptingEngine engine = this.scriptingService.createScriptingEngine("JavaScript");
                    url = new URL(String.valueOf(engine.execute(this.configuration.getURL())));
                }
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setDoOutput(true);
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
                con.setRequestProperty("SOAPAction", this.configuration.getSoapAction() == null ? "" : "\"" + this.configuration.getSoapAction() + "\"");
                OutputStream out = con.getOutputStream();
                OutputStreamWriter ps = new OutputStreamWriter(out);
                ps.write(payload.toString());
                this.context.debug(payload.toString());
                ((Writer)ps).flush();
                ((Writer)ps).close();
                int rc = con.getResponseCode();
                if (rc == 200) {
                    List bodyElementList;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(con.getInputStream());
                    Element rootElement = document.getDocumentElement();
                    if (!rootElement.getLocalName().equals("Envelope") && this.context.isErrorEnabled()) {
                        this.context.error("Webservice returned invalid document");
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.transform(new DOMSource(document), new StreamResult(baos));
                        this.context.error(baos.toString());
                        if (this.context.isReportingEnabled()) {
                            Hashtable<String, String> props2 = new Hashtable<String, String>();
                            ((Dictionary)props2).put("event", "wscall.after");
                            this.context.report(3, "Called web service but received invalid response", props2);
                        }
                        return this.context.createResult("error.webservice");
                    }
                    IDataObject resultObject = this.variables.createVariable("WSResponse");
                    this.variables.setVariable(this.configuration.getVariableName(), resultObject);
                    IArrayObject headerArrayObject = (IArrayObject)this.variables.createVariable("Array");
                    resultObject.setField("headers", (IDataObject)headerArrayObject);
                    List headerElementList = XMLUtilities.getElementsByTagNameNS((Element)rootElement, (String)SOAP_ENVELOPE_URI, (String)"Header", (boolean)true);
                    if (headerElementList.size() > 0) {
                        Element headerElement = (Element)headerElementList.get(0);
                        List entryList = XMLUtilities.getChildElements((Element)headerElement);
                        for (Element entryElement : entryList) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            Transformer transformer = TransformerFactory.newInstance().newTransformer();
                            transformer.transform(new DOMSource(entryElement), new StreamResult(baos));
                            IDataObject headerObject = this.variables.createVariable("WSHeader");
                            IStringObject nameObject = (IStringObject)this.variables.createVariable("String");
                            nameObject.setValue((Object)entryElement.getLocalName());
                            IStringObject rawContent = (IStringObject)this.variables.createVariable("String");
                            rawContent.setValue((Object)baos.toString());
                            headerObject.setField("name", (IDataObject)nameObject);
                            headerObject.setField("rawContent", (IDataObject)rawContent);
                        }
                    }
                    if ((bodyElementList = XMLUtilities.getElementsByTagNameNS((Element)rootElement, (String)SOAP_ENVELOPE_URI, (String)"Body", (boolean)true)).size() > 0) {
                        Element bodyElement = (Element)bodyElementList.get(0);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.transform(new DOMSource(bodyElement), new StreamResult(baos));
                        IStringObject rawContent = (IStringObject)this.variables.createVariable("String");
                        rawContent.setValue((Object)baos.toString());
                        resultObject.setField("rawContent", (IDataObject)rawContent);
                    }
                    break block19;
                }
                if (this.context.isErrorEnabled()) {
                    this.context.error("Web service call failed: " + Integer.toString(rc));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream in = con.getErrorStream();
                    byte[] buf = new byte[1024];
                    int len = in.read(buf);
                    while (len != -1) {
                        baos.write(buf, 0, len);
                        len = in.read(buf);
                    }
                    in.close();
                    con.disconnect();
                    this.context.debug(baos.toString());
                }
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props3 = new Hashtable<String, String>();
                    ((Dictionary)props3).put("event", "wscall.after");
                    ((Dictionary)props3).put("http.response", Integer.toString(rc));
                    this.context.report(3, "Call web service failed: " + Integer.toString(rc), props3);
                }
                return this.context.createResult("error.webservice");
            }
            catch (Exception e) {
                if (this.context.isErrorEnabled()) {
                    this.context.error("Web service call failed: ");
                    e.printStackTrace();
                }
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props4 = new Hashtable<String, String>();
                    ((Dictionary)props4).put("event", "wscall.after");
                    this.context.report(3, "Call web service failed: " + e, props4);
                }
                return this.context.createResult("error.webservice", (Throwable)e);
            }
        }
        if (this.context.isReportingEnabled()) {
            props = new Hashtable();
            ((Dictionary)props).put("event", "wscall.after");
            this.context.report(3, "Called web service", props);
        }
        return this.context.createResult("default");
    }

    private void processDocumentItemContainer(StringBuilder payload, DocumentItemContainer container) {
        List<DocumentItem> children = container.getItems();
        for (DocumentItem child : children) {
            if (child instanceof ConditionalContainerSet) {
                this.processConditionalContainerSet(payload, (ConditionalContainerSet)child);
                continue;
            }
            if (child instanceof ForLoopDocumentItem) {
                ForLoopDocumentItem fldi = (ForLoopDocumentItem)child;
                String sourceName = fldi.getTransform();
                String targetVariable = fldi.getVariableName();
                IDataObject source = this.variables.getVariable(sourceName);
                if (source == null) continue;
                if (source instanceof IArrayObject) {
                    IArrayObject sourceArray = (IArrayObject)source;
                    int i = 0;
                    while (i < sourceArray.getLength().getValue()) {
                        IDataObject currentObject = sourceArray.getElement(i);
                        this.variables.setVariable(targetVariable, currentObject);
                        this.processDocumentItemContainer(payload, fldi);
                        ++i;
                    }
                    continue;
                }
                this.variables.setVariable(targetVariable, source);
                this.processDocumentItemContainer(payload, fldi);
                continue;
            }
            if (child instanceof ElementDocumentItem) {
                ElementDocumentItem elementItem = (ElementDocumentItem)child;
                payload.append("<").append(elementItem.getName());
                if (elementItem.getNamespace() != null && !elementItem.getNamespace().equals("")) {
                    payload.append(" xmlns=\"").append(elementItem.getNamespace()).append("\"");
                }
                List<ElementAttributeDocumentItem> attributes = elementItem.getAttributes();
                for (ElementAttributeDocumentItem attribute : attributes) {
                    payload.append(" ").append(attribute.getName()).append("=\"");
                    payload.append(this.resolveValue(attribute.getBrandBinding(this.brandSelection.getSelectedBrand())));
                    payload.append("\"");
                }
                payload.append(">");
                this.processDocumentItemContainer(payload, elementItem);
                payload.append("</").append(elementItem.getName()).append(">");
                continue;
            }
            payload.append(this.resolveValue(((TextDocumentItem)child).getBrandBinding(this.brandSelection.getSelectedBrand())));
        }
    }

    private void processConditionalContainerSet(StringBuilder payload, ConditionalContainerSet container) {
        ConditionalDocumentItem ifItem;
        IScriptingEngine engine = this.scriptingService.createScriptingEngine("JavaScript");
        if (Boolean.valueOf(String.valueOf(engine.execute((ifItem = container.getIf()).getCondition()))).booleanValue()) {
            this.processDocumentItemContainer(payload, ifItem);
            return;
        }
        for (ConditionalDocumentItem elseIfItem : container.getElseIfs()) {
            if (!Boolean.valueOf(String.valueOf(engine.execute(elseIfItem.getCondition()))).booleanValue()) continue;
            this.processDocumentItemContainer(payload, elseIfItem);
            return;
        }
        ElseDocumentItem elseItem = container.getElse();
        if (elseItem != null) {
            this.processDocumentItemContainer(payload, elseItem);
        }
    }

    private String resolveValue(BindingValue value) {
        String type = value.getValueType();
        if (type.equals("static")) {
            return value.getValue();
        }
        if (type.equals("variable")) {
            return String.valueOf(this.variables.getVariable(value.getValue()));
        }
        IScriptingEngine engine = this.scriptingService.createScriptingEngine("JavaScript");
        return String.valueOf(engine.execute(value.getValue()));
    }
}

