/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.configurations.document;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.webservices.configurations.document.ConditionalContainerSet;
import org.eclipse.vtp.framework.webservices.configurations.document.DocumentItem;
import org.eclipse.vtp.framework.webservices.configurations.document.ElementDocumentItem;
import org.eclipse.vtp.framework.webservices.configurations.document.ForLoopDocumentItem;
import org.eclipse.vtp.framework.webservices.configurations.document.TextDocumentItem;
import org.w3c.dom.Element;

public abstract class DocumentItemContainer
extends DocumentItem {
    protected List<DocumentItem> items = new ArrayList<DocumentItem>();

    public List<DocumentItem> getItems() {
        return this.items;
    }

    public void addItem(DocumentItem item) {
        this.items.add(item);
        item.setParent(this);
    }

    public void insertItem(DocumentItem item, int index) {
        this.items.add(index, item);
        item.setParent(this);
    }

    public void removeItem(DocumentItem item) {
        this.items.remove(item);
        item.setParent(null);
    }

    public void insertItem(DocumentItem item, DocumentItem insertionPoint) {
        if (insertionPoint == null) {
            this.items.add(0, item);
        } else {
            int i = 0;
            while (i < this.items.size()) {
                if (this.items.get(i) == insertionPoint) {
                    this.items.add(i + 1, item);
                    item.setParent(this);
                    return;
                }
                ++i;
            }
            this.items.add(item);
        }
        item.setParent(this);
    }

    @Override
    public void readConfiguration(Element documentItemContainerElement) {
        List children = XMLUtilities.getChildElements((Element)documentItemContainerElement);
        for (Element child : children) {
            DocumentItem item = null;
            if (child.getLocalName().equals("conditional-container")) {
                item = new ConditionalContainerSet();
            } else if (child.getLocalName().equals("element-item")) {
                item = new ElementDocumentItem();
            } else if (child.getLocalName().equals("for-loop-item")) {
                item = new ForLoopDocumentItem();
            } else if (child.getLocalName().equals("text-item")) {
                item = new TextDocumentItem();
            }
            if (item == null) continue;
            ((DocumentItem)item).readConfiguration(child);
            this.items.add(item);
            item.setParent(this);
        }
    }

    @Override
    public void writeConfiguration(Element documentItemContainerElement) {
        for (DocumentItem item : this.items) {
            Element documentItemElement = item.createConfigurationElement(documentItemContainerElement);
            item.writeConfiguration(documentItemElement);
        }
    }
}

