/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.configurations.document;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.webservices.configurations.document.DocumentItemContainer;
import org.eclipse.vtp.framework.webservices.configurations.document.ElementAttributeDocumentItem;
import org.w3c.dom.Element;

public class ElementDocumentItem
extends DocumentItemContainer {
    private String name = null;
    private String namespace = null;
    private List<ElementAttributeDocumentItem> attributes = new ArrayList<ElementAttributeDocumentItem>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<ElementAttributeDocumentItem> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(ElementAttributeDocumentItem attribute) {
        this.attributes.remove(attribute);
        this.attributes.add(attribute);
    }

    public void removeAttribute(ElementAttributeDocumentItem attribute) {
        this.attributes.remove(attribute);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public Element createConfigurationElement(Element parentElement) {
        Element elementItemElement = parentElement.getOwnerDocument().createElementNS(null, "element-item");
        parentElement.appendChild(elementItemElement);
        return elementItemElement;
    }

    @Override
    public void readConfiguration(Element elementItemElement) {
        this.name = elementItemElement.getAttribute("name");
        this.namespace = elementItemElement.getAttribute("namespace");
        List attributeContainerElementList = XMLUtilities.getElementsByTagName((Element)elementItemElement, (String)"attributes", (boolean)true);
        if (attributeContainerElementList.size() > 0) {
            Element attributeContainerElement = (Element)attributeContainerElementList.get(0);
            List attributeElementList = XMLUtilities.getElementsByTagName((Element)attributeContainerElement, (String)"attribute", (boolean)true);
            for (Element attributeElement : attributeElementList) {
                ElementAttributeDocumentItem attribute = new ElementAttributeDocumentItem();
                attribute.readConfiguration(attributeElement);
                this.attributes.add(attribute);
            }
        }
        super.readConfiguration(elementItemElement);
    }

    @Override
    public void writeConfiguration(Element elementItemElement) {
        elementItemElement.setAttribute("name", this.name);
        elementItemElement.setAttribute("namespace", this.namespace);
        Element attributesElement = elementItemElement.getOwnerDocument().createElementNS(null, "attributes");
        elementItemElement.appendChild(attributesElement);
        for (ElementAttributeDocumentItem attribute : this.attributes) {
            Element attributeElement = attributesElement.getOwnerDocument().createElementNS(null, "attribute");
            attributesElement.appendChild(attributeElement);
            attribute.writeConfiguration(attributeElement);
        }
        super.writeConfiguration(elementItemElement);
    }
}

