/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.configurations.document;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.webservices.configurations.document.BindingValue;
import org.eclipse.vtp.framework.webservices.configurations.document.DocumentItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TextDocumentItem
extends DocumentItem {
    private Map<String, BindingValue> brandBindings = new TreeMap<String, BindingValue>();

    public BindingValue getBrandBinding(IBrand brand) {
        return this.brandBindings.get(brand.getId());
    }

    @Override
    public void readConfiguration(Element textItemElement) {
        NodeList brandBindingElementList = textItemElement.getElementsByTagName("brand-binding");
        int i = 0;
        while (i < brandBindingElementList.getLength()) {
            Element brandBindingElement = (Element)brandBindingElementList.item(i);
            String brandId = brandBindingElement.getAttribute("id");
            BindingValue value = new BindingValue();
            value.readConfiguration(brandBindingElement);
            this.brandBindings.put(brandId, value);
            ++i;
        }
    }

    @Override
    public void writeConfiguration(Element textItemElement) {
        for (Map.Entry<String, BindingValue> entry : this.brandBindings.entrySet()) {
            String brandId = entry.getKey();
            BindingValue brandBinding = entry.getValue();
            Element brandBindingElement = textItemElement.getOwnerDocument().createElementNS(null, "brand-binding");
            textItemElement.appendChild(brandBindingElement);
            brandBindingElement.setAttribute("id", brandId);
            brandBinding.writeConfiguration(brandBindingElement);
        }
    }

    @Override
    public Element createConfigurationElement(Element parentElement) {
        Element textElement = parentElement.getOwnerDocument().createElementNS(null, "text-item");
        parentElement.appendChild(textElement);
        return textElement;
    }
}

