/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.attacheddata.ui.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.vtp.desktop.editors.core.configuration.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.configuration.ConnectorPropertiesListener;
import org.eclipse.vtp.desktop.editors.core.configuration.ConnectorPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.AttachedDataBinding;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.AttachedDataBindingItem;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.AttachedDataItemEntry;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.AttachedDataManager;
import org.eclipse.vtp.modules.attacheddata.ui.dialogs.AttachedDataEntryDialog;

public class AttachedDataPropertiesPanel
extends ComponentPropertiesPanel
implements ConnectorPropertiesListener {
    private IDesignConnector connector = null;
    private TreeViewer dataViewer = null;
    private AttachedDataManager attachedDataManager = null;
    private IBrand currentBrand = null;
    private String interactionType = null;
    private String currentLanguage = null;
    private List<IDesignElementConnectionPoint> currentExits = new ArrayList<IDesignElementConnectionPoint>();

    public AttachedDataPropertiesPanel(IDesignConnector connector) {
        super("Attached Data");
        this.connector = connector;
        IDesignElement origin = connector.getOrigin();
        this.attachedDataManager = (AttachedDataManager)origin.getConfigurationManager("org.eclipse.vtp.configuration.attacheddata");
    }

    public void resolve() {
        List panels = this.getContainer().getPanels();
        for (ComponentPropertiesPanel panel : panels) {
            if (!(panel instanceof ConnectorPropertiesPanel)) continue;
            ((ConnectorPropertiesPanel)panel).addEndPointListener((ConnectorPropertiesListener)this);
            break;
        }
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(1, false));
        Tree dataTree = new Tree(comp, 68100);
        dataTree.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(dataTree, 0);
        nameColumn.setText("Name");
        nameColumn.setWidth(150);
        TreeColumn valueColumn = new TreeColumn(dataTree, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(150);
        this.dataViewer = new TreeViewer(dataTree);
        GridData layoutData = new GridData(1808);
        this.dataViewer.getControl().setLayoutData((Object)layoutData);
        this.dataViewer.setContentProvider((IContentProvider)new AttachedDataContentProvider());
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new AttachedDataLabelProvider());
        this.dataViewer.setInput((Object)this);
        this.setControl((Control)comp);
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AttachedDataPropertiesPanel.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.dataViewer.getControl());
        this.dataViewer.getControl().setMenu(menu);
    }

    private void hookDoubleClickAction() {
        this.dataViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)AttachedDataPropertiesPanel.this.dataViewer.getSelection();
                if (sel.getFirstElement() instanceof EntryRecord) {
                    EntryRecord entryRecord = (EntryRecord)sel.getFirstElement();
                    try {
                        Shell workbenchShell = Display.getCurrent().getActiveShell();
                        AttachedDataEntryDialog aded = new AttachedDataEntryDialog(workbenchShell);
                        aded.setConnector(AttachedDataPropertiesPanel.this.connector, entryRecord.connectorRecord.getName());
                        aded.setEntry(entryRecord.entry);
                        if (aded.open() == 0) {
                            entryRecord.binding.putAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage, entryRecord.item);
                            AttachedDataPropertiesPanel.this.dataViewer.refresh();
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void fillContextMenu(IMenuManager manager) {
        if (!this.dataViewer.getSelection().isEmpty()) {
            final IStructuredSelection sel = (IStructuredSelection)this.dataViewer.getSelection();
            if (sel.getFirstElement() instanceof ConnectorRecord) {
                manager.add((IAction)new Action("Add Attached Data"){

                    public void run() {
                        try {
                            ConnectorRecord cr = (ConnectorRecord)sel.getFirstElement();
                            Shell workbenchShell = Display.getCurrent().getActiveShell();
                            AttachedDataEntryDialog aded = new AttachedDataEntryDialog(workbenchShell);
                            aded.setConnector(AttachedDataPropertiesPanel.this.connector, cr.getName());
                            if (aded.open() == 0) {
                                AttachedDataBinding dataBinding = AttachedDataPropertiesPanel.this.attachedDataManager.getAttachedDataBinding(cr.getName());
                                AttachedDataBindingItem item = dataBinding.getAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage);
                                item.addEntry(aded.getEntry());
                                dataBinding.putAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage, item);
                                AttachedDataPropertiesPanel.this.dataViewer.refresh();
                            }
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                final EntryRecord entryRecord = (EntryRecord)sel.getFirstElement();
                manager.add((IAction)new Action("Edit This"){

                    public void run() {
                        try {
                            Shell workbenchShell = Display.getCurrent().getActiveShell();
                            AttachedDataEntryDialog aded = new AttachedDataEntryDialog(workbenchShell);
                            aded.setConnector(AttachedDataPropertiesPanel.this.connector, entryRecord.connectorRecord.getName());
                            aded.setEntry(entryRecord.entry);
                            if (aded.open() == 0) {
                                entryRecord.binding.putAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage, entryRecord.item);
                                AttachedDataPropertiesPanel.this.dataViewer.refresh();
                            }
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                    }
                });
                manager.add((IAction)new Action("Remove This"){

                    public void run() {
                        entryRecord.item.removeEntry(entryRecord.entry);
                        entryRecord.binding.putAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage, entryRecord.item);
                        AttachedDataPropertiesPanel.this.dataViewer.refresh();
                    }
                });
            }
        }
    }

    public void save() {
        this.connector.getOrigin().commitConfigurationChanges((ConfigurationManager)this.attachedDataManager);
    }

    public void cancel() {
        this.connector.getOrigin().rollbackConfigurationChanges((ConfigurationManager)this.attachedDataManager);
    }

    public List<String> getApplicableContexts() {
        List ret = super.getApplicableContexts();
        ret.add("org.eclipse.vtp.desktop.model.interactive.core.languagecontext");
        ret.add("org.eclipse.vtp.desktop.model.interactive.core.interactiontypecontext");
        return ret;
    }

    public void setConfigurationContext(Map<String, Object> values) {
        this.currentBrand = (IBrand)values.get("org.eclipse.vtp.desktop.model.core.brandcontext");
        this.currentLanguage = (String)values.get("org.eclipse.vtp.desktop.model.interactive.core.languagecontext");
        this.interactionType = ((InteractionType)values.get("org.eclipse.vtp.desktop.model.interactive.core.interactiontypecontext")).getId();
        this.dataViewer.refresh();
    }

    public void exitPointSelectionChanged(List<IDesignElementConnectionPoint> selection) {
        this.currentExits = selection;
        if (this.dataViewer != null) {
            this.dataViewer.getTree().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AttachedDataPropertiesPanel.this.dataViewer.refresh();
                }
            });
        }
    }

    private class AttachedDataContentProvider
    implements ITreeContentProvider {
        private AttachedDataContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            System.out.println("Parent element: " + parentElement);
            if (parentElement instanceof ConnectorRecord) {
                ConnectorRecord cr = (ConnectorRecord)parentElement;
                System.out.println("connector: " + cr.getName());
                AttachedDataBinding dataBinding = AttachedDataPropertiesPanel.this.attachedDataManager.getAttachedDataBinding(cr.getName());
                System.out.println("data binding: " + dataBinding);
                AttachedDataBindingItem item = dataBinding.getAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage);
                System.out.println("binding item: " + item);
                List<AttachedDataItemEntry> copy = item.getEntries();
                System.out.println("item entries: " + copy + " [" + copy.size() + "]");
                ArrayList<EntryRecord> ret = new ArrayList<EntryRecord>();
                int i = 0;
                while (i < copy.size()) {
                    AttachedDataItemEntry entry = copy.get(i);
                    System.out.println("Entry: " + entry.getName() + " " + entry.getDataType() + " " + entry.getValue());
                    ret.set(i, new EntryRecord(cr, dataBinding, item, entry));
                    ++i;
                }
                return ret.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof EntryRecord) {
                return ((EntryRecord)element).connectorRecord;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ConnectorRecord;
        }

        public Object[] getElements(Object inputElement) {
            return AttachedDataPropertiesPanel.this.currentExits.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class AttachedDataLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AttachedDataLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof ConnectorRecord) {
                    return ((ConnectorRecord)element).getName();
                }
                return ((EntryRecord)element).entry.getName();
            }
            if (columnIndex == 1 && element instanceof EntryRecord) {
                return ((EntryRecord)element).entry.getValue();
            }
            return null;
        }
    }

    private class EntryRecord {
        ConnectorRecord connectorRecord;
        AttachedDataBinding binding;
        AttachedDataBindingItem item;
        AttachedDataItemEntry entry;

        public EntryRecord(ConnectorRecord connectorRecord, AttachedDataBinding binding, AttachedDataBindingItem item, AttachedDataItemEntry entry) {
            this.connectorRecord = connectorRecord;
            this.binding = binding;
            this.item = item;
            this.entry = entry;
        }
    }
}

