/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.attacheddata.ui.configuration.post;

import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.AttachedDataBindingItem;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.AttachedDataItemEntry;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.AttachedDataManager;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.GenericBinding;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.post.GenericBindingItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttachedDataBinding
extends GenericBinding {
    public AttachedDataBinding(AttachedDataManager manager, String name) {
        super(manager, name);
    }

    public AttachedDataBindingItem getAttachedDataItem(String brand, String interactionType, String language) {
        AttachedDataBindingItem attachedDataBinding = (AttachedDataBindingItem)super.getItem(brand, interactionType, language);
        if (attachedDataBinding == null) {
            attachedDataBinding = new AttachedDataBindingItem();
        }
        return attachedDataBinding;
    }

    public void putAttachedDataItem(String brand, String interactionType, String language, AttachedDataBindingItem item) {
        super.putItem(brand, interactionType, language, item);
    }

    @Override
    public GenericBindingItem readBindingItem(Element itemConfiguration) {
        AttachedDataBindingItem item = new AttachedDataBindingItem();
        NodeList contentList = itemConfiguration.getChildNodes();
        int i = 0;
        while (i < contentList.getLength()) {
            if (contentList.item(i) instanceof Element) {
                AttachedDataItemEntry entry = new AttachedDataItemEntry();
                Element entryElement = (Element)contentList.item(i);
                entry.setName(entryElement.getAttribute("name"));
                String dataTypeString = entryElement.getAttribute("type");
                int dataType = 0;
                dataType = "".equalsIgnoreCase(dataTypeString) ? 0 : ("static".equalsIgnoreCase(dataTypeString) ? 0 : ("expression".equalsIgnoreCase(dataTypeString) ? 1 : ("variable".equalsIgnoreCase(dataTypeString) ? 2 : Integer.parseInt(dataTypeString))));
                entry.setDataType(dataType);
                entry.setValue(entryElement.getAttribute("value"));
                item.addEntry(entry);
            }
            ++i;
        }
        return item;
    }

    @Override
    public void writeBindingItem(GenericBindingItem item, Element itemConfiguration) {
        for (AttachedDataItemEntry entry : ((AttachedDataBindingItem)item).getEntries()) {
            if (entry.getValue() == null) continue;
            Element entryElement = itemConfiguration.getOwnerDocument().createElement("entry");
            itemConfiguration.appendChild(entryElement);
            entryElement.setAttribute("name", entry.getName());
            String dataTypeString = "static";
            switch (entry.getDataType()) {
                case 1: {
                    dataTypeString = "expression";
                    break;
                }
                case 2: {
                    dataTypeString = "variable";
                }
            }
            entryElement.setAttribute("type", dataTypeString);
            entryElement.setAttribute("value", entry.getValue());
        }
    }
}

