/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.attacheddata.ui.configuration.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationException;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.request.AttachedDataBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttachedDataManager
implements ConfigurationManager {
    public static final String CONFIGURATION_TYPE_ID = "org.eclipse.vtp.configuration.attacheddata.request";
    public static final String NAMESPACE_URI = "http://eclipse.org/vtp/xml/configuration/attacheddata/request";
    public static final String XML_VERSION = "1.0.0";
    private Map<String, AttachedDataBinding> bindings = new HashMap<String, AttachedDataBinding>();
    private List<AttachedDataBinding> dataBindings = new ArrayList<AttachedDataBinding>();
    private BrandManager brandManager = null;
    private IDesign design = null;

    public AttachedDataManager(IDesign design) {
        this.design = design;
        this.brandManager = design.getDocument().getProject().getBrandManager();
    }

    public BrandManager getBrandManager() {
        return this.brandManager;
    }

    public AttachedDataBinding getAttachedDataBinding(String name) {
        AttachedDataBinding binding = this.bindings.get(name);
        if (binding == null) {
            binding = new AttachedDataBinding(this, name);
            this.bindings.put(name, binding);
            this.dataBindings.add(binding);
        }
        return binding;
    }

    public List<AttachedDataBinding> listBindings() {
        ArrayList<AttachedDataBinding> ret = new ArrayList<AttachedDataBinding>(this.dataBindings.size());
        ret.addAll(this.dataBindings);
        return ret;
    }

    public String getType() {
        return CONFIGURATION_TYPE_ID;
    }

    public String getXMLVersion() {
        return XML_VERSION;
    }

    public void readConfiguration(Element configuration) throws ConfigurationException {
        NodeList bindingList = configuration.getElementsByTagNameNS(NAMESPACE_URI, "attached-data-binding");
        int i = 0;
        while (i < bindingList.getLength()) {
            Element bindingElement = (Element)bindingList.item(i);
            AttachedDataBinding binding = this.getAttachedDataBinding(bindingElement.getAttribute("name"));
            binding.readBindingItems(bindingElement);
            ++i;
        }
    }

    public void writeConfiguration(Element configuration) {
        for (AttachedDataBinding binding : this.dataBindings) {
            Element bindingElement = configuration.getOwnerDocument().createElementNS(NAMESPACE_URI, "attached-data-binding");
            bindingElement.setAttribute("name", binding.getName());
            binding.writeBindingItems(bindingElement);
            configuration.appendChild(bindingElement);
        }
    }

    public Object clone() {
        AttachedDataManager copy = new AttachedDataManager(this.design);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "temporary-document", null);
            Element rootElement = document.getDocumentElement();
            rootElement.setAttribute("xml-version", XML_VERSION);
            this.writeConfiguration(rootElement);
            copy.readConfiguration(rootElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return copy;
    }
}

