/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.attacheddata.ui.configuration.request;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.request.AttachedDataManager;
import org.eclipse.vtp.modules.attacheddata.ui.configuration.request.GenericBindingItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class GenericBinding {
    private String name;
    private AttachedDataManager manager = null;
    private Map<String, GenericBindingItem> bindingItems = new HashMap<String, GenericBindingItem>();

    public GenericBinding(AttachedDataManager manager, String name) {
        this.manager = manager;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AttachedDataManager getAttachedDataManager() {
        return this.manager;
    }

    protected GenericBindingItem getItem(String brand, String interactionType, String language) {
        IBrand brandObject = this.manager.getBrandManager().getBrand(brand);
        GenericBindingItem bindingItemObject = this.bindingItems.get(String.valueOf(brand) + interactionType + language);
        while (bindingItemObject == null && brandObject.getParent() != null) {
            bindingItemObject = this.bindingItems.get(String.valueOf((brandObject = brandObject.getParent()).getName()) + interactionType + language);
            if (bindingItemObject == null) continue;
            bindingItemObject = (GenericBindingItem)bindingItemObject.clone();
        }
        return bindingItemObject;
    }

    protected void putItem(String brand, String interactionType, String language, GenericBindingItem item) {
        this.bindingItems.put(String.valueOf(brand) + interactionType + language, item);
        IBrand brandObject = this.manager.getBrandManager().getBrand(brand);
        while (brandObject.getParent() != null) {
            if (this.bindingItems.get(String.valueOf((brandObject = brandObject.getParent()).getName()) + interactionType + language) != null) break;
            this.bindingItems.put(String.valueOf(brandObject.getName()) + interactionType + language, item);
        }
    }

    public void readBindingItems(Element bindingConfiguration) {
        NodeList itemList = bindingConfiguration.getElementsByTagNameNS("http://eclipse.org/vtp/xml/configuration/attacheddata/request", "item");
        int i = 0;
        while (i < itemList.getLength()) {
            Element itemElement = (Element)itemList.item(i);
            this.bindingItems.put(itemElement.getAttribute("key"), this.readBindingItem(itemElement));
            ++i;
        }
    }

    public void writeBindingItems(Element bindingConfiguration) {
        for (Map.Entry<String, GenericBindingItem> entry : this.bindingItems.entrySet()) {
            Element itemElement = bindingConfiguration.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/configuration/attacheddata/request", "item");
            bindingConfiguration.appendChild(itemElement);
            itemElement.setAttribute("key", entry.getKey());
            this.writeBindingItem(entry.getValue(), itemElement);
        }
    }

    protected abstract GenericBindingItem readBindingItem(Element var1);

    protected abstract void writeBindingItem(GenericBindingItem var1, Element var2);
}

