/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.database.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.model.core.ColumnType;
import org.eclipse.vtp.desktop.model.core.IDatabaseTable;
import org.eclipse.vtp.desktop.model.core.IDatabaseTableColumn;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DatabaseTableEditor
extends EditorPart {
    IDatabaseTable databaseTable;
    boolean dirty = false;
    TableViewer viewer;
    List<ColumnRecord> columnRecords = new ArrayList<ColumnRecord>();
    TextCellEditor nameEditor;
    ComboBoxCellEditor typeEditor;
    TextCellEditor lengthEditor;
    CheckboxCellEditor nullableEditor;
    CheckboxCellEditor autoIncrementEditor;
    List<String> currentTypes = new ArrayList<String>();
    int tumbler = 0;

    public DatabaseTableEditor() {
        this.currentTypes.add("Varchar");
        this.currentTypes.add("Number");
        this.currentTypes.add("Big Number");
        this.currentTypes.add("Decimal");
        this.currentTypes.add("Big Decimal");
        this.currentTypes.add("Boolean");
        this.currentTypes.add("DateTime");
        this.currentTypes.add("Text");
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = doc.createElement("database-table");
            doc.appendChild(rootElement);
            rootElement.setAttribute("name", this.databaseTable.getName());
            Element fields = rootElement.getOwnerDocument().createElement("columns");
            rootElement.appendChild(fields);
            int i = 0;
            while (i < this.columnRecords.size()) {
                ColumnRecord fr = this.columnRecords.get(i);
                Element fieldElement = fields.getOwnerDocument().createElement("column");
                fields.appendChild(fieldElement);
                fieldElement.setAttribute("name", fr.name);
                ColumnType dt = ColumnType.custom((String)fr.type, (int)fr.length, (boolean)fr.autoIncrement, (boolean)fr.nullable);
                dt.write(fieldElement);
                ++i;
            }
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("encoding", "UTF-8");
            trans.transform(source, new XMLWriter((OutputStream)baos).toXMLResult());
            this.databaseTable.write((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            this.dirty = false;
            this.firePropertyChange(257);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof FileEditorInput)) {
            throw new PartInitException("Cannot edit: " + input);
        }
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(input.getName());
        IFile file = ((FileEditorInput)input).getFile();
        this.databaseTable = (IDatabaseTable)WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource((IResource)file);
        List fields = this.databaseTable.getColumns();
        for (IDatabaseTableColumn bof : fields) {
            ColumnRecord fr = new ColumnRecord();
            fr.name = bof.getName();
            fr.type = bof.getColumnType().getTypeName();
            fr.autoIncrement = bof.getColumnType().isAutoIncrement();
            fr.nullable = bof.getColumnType().isNullable();
            fr.length = bof.getColumnType().getLength();
            this.columnRecords.add(fr);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 65540);
        table.setHeaderVisible(true);
        TableColumn fieldName = new TableColumn(table, 0);
        fieldName.setText("Name");
        fieldName.setWidth(150);
        TableColumn dataTypeColumn = new TableColumn(table, 0);
        dataTypeColumn.setText("Type");
        dataTypeColumn.setWidth(200);
        TableColumn lengthColumn = new TableColumn(table, 0);
        lengthColumn.setText("Length");
        lengthColumn.setWidth(60);
        TableColumn nullableColumn = new TableColumn(table, 0);
        nullableColumn.setText("Nullable");
        nullableColumn.setWidth(80);
        TableColumn autoIncrementColumn = new TableColumn(table, 0);
        autoIncrementColumn.setText("Auto Inc");
        autoIncrementColumn.setWidth(80);
        this.nameEditor = new TextCellEditor((Composite)table);
        this.nameEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                String text = (String)value;
                if (text == null) {
                    text = "";
                }
                ColumnRecord fr = (ColumnRecord)((IStructuredSelection)DatabaseTableEditor.this.viewer.getSelection()).getFirstElement();
                int i = 0;
                while (i < DatabaseTableEditor.this.columnRecords.size()) {
                    if (fr != DatabaseTableEditor.this.columnRecords.get(i) && DatabaseTableEditor.this.columnRecords.get((int)i).name.equalsIgnoreCase(text)) {
                        return "A column with that name already exists.";
                    }
                    ++i;
                }
                return null;
            }
        });
        this.nameEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (!newValidState) {
                    DatabaseTableEditor.this.nameEditor.getControl().setForeground(DatabaseTableEditor.this.nameEditor.getControl().getDisplay().getSystemColor(3));
                } else {
                    DatabaseTableEditor.this.nameEditor.getControl().setForeground(DatabaseTableEditor.this.nameEditor.getControl().getDisplay().getSystemColor(2));
                }
            }
        });
        this.typeEditor = new ComboBoxCellEditor((Composite)table, this.currentTypes.toArray(new String[this.currentTypes.size()]), 12);
        this.lengthEditor = new TextCellEditor((Composite)table);
        this.lengthEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                String text = (String)value;
                if (text == null) {
                    return "Must be a number";
                }
                try {
                    Integer.parseInt(text);
                }
                catch (Exception e) {
                    return "Must be a number";
                }
                return null;
            }
        });
        this.lengthEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (!newValidState) {
                    DatabaseTableEditor.this.lengthEditor.getControl().setForeground(DatabaseTableEditor.this.nameEditor.getControl().getDisplay().getSystemColor(3));
                } else {
                    DatabaseTableEditor.this.lengthEditor.getControl().setForeground(DatabaseTableEditor.this.nameEditor.getControl().getDisplay().getSystemColor(2));
                }
            }
        });
        this.nullableEditor = new CheckboxCellEditor((Composite)table);
        this.autoIncrementEditor = new CheckboxCellEditor((Composite)table);
        this.viewer = new TableViewer(table);
        this.viewer.setColumnProperties(new String[]{"Name", "Type", "Length", "Nullable", "AutoIncrement"});
        this.viewer.setContentProvider((IContentProvider)new FieldContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider());
        this.viewer.setCellModifier((ICellModifier)new FieldCellModifier());
        this.viewer.setCellEditors(new CellEditor[]{this.nameEditor, this.typeEditor, this.lengthEditor, this.nullableEditor, this.autoIncrementEditor});
        this.viewer.setInput((Object)this);
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DatabaseTableEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)new Action("Add Column"){

            public void run() {
                ColumnRecord newField = new ColumnRecord();
                newField.name = "";
                newField.type = "Varchar";
                newField.length = 45;
                newField.nullable = false;
                newField.autoIncrement = false;
                DatabaseTableEditor.this.columnRecords.add(newField);
                DatabaseTableEditor.this.viewer.refresh();
                DatabaseTableEditor.this.viewer.editElement((Object)newField, 0);
                DatabaseTableEditor.this.fireModified();
            }
        });
        if (!this.viewer.getSelection().isEmpty()) {
            final ColumnRecord fr = (ColumnRecord)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            manager.add((IAction)new Action("Remove Column"){

                public void run() {
                    MessageBox mb = new MessageBox(DatabaseTableEditor.this.viewer.getControl().getShell(), 200);
                    mb.setMessage("Are you sure you want to delete this?");
                    int result = mb.open();
                    if (result == 64) {
                        DatabaseTableEditor.this.columnRecords.remove(fr);
                        DatabaseTableEditor.this.viewer.refresh();
                        DatabaseTableEditor.this.fireModified();
                    }
                }
            });
        }
    }

    public void setFocus() {
    }

    private void fireModified() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public class ColumnRecord {
        String name;
        String type;
        boolean nullable;
        boolean autoIncrement;
        int length;
    }

    public class FieldCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            ColumnRecord fr = (ColumnRecord)element;
            if (property.equals("Nullable") || property.equals("Type") || property.equals("Name")) {
                return true;
            }
            if (property.equals("Length")) {
                return fr.type.equals("Varchar");
            }
            if (property.equals("AutoIncrement")) {
                return fr.type.equals("Big Number") || fr.type.equals("Number");
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            ColumnRecord fr = (ColumnRecord)element;
            if (property.equals("Nullable")) {
                return new Boolean(fr.nullable);
            }
            if (property.equals("Length")) {
                return Integer.toString(fr.length);
            }
            if (property.equals("Name")) {
                return fr.name == null ? "" : fr.name;
            }
            if (property.equals("Type")) {
                if (fr.type.equals("Varchar")) {
                    return new Integer(0);
                }
                if (fr.type.equals("Number")) {
                    return new Integer(1);
                }
                if (fr.type.equals("Big Number")) {
                    return new Integer(2);
                }
                if (fr.type.equals("Decimal")) {
                    return new Integer(3);
                }
                if (fr.type.equals("Big Decimal")) {
                    return new Integer(4);
                }
                if (fr.type.equals("Boolean")) {
                    return new Integer(5);
                }
                if (fr.type.equals("DateTime")) {
                    return new Integer(6);
                }
                if (fr.type.equals("Text")) {
                    return new Integer(7);
                }
            } else if (property.equals("AutoIncrement")) {
                return new Boolean(fr.autoIncrement);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem ti = (TableItem)element;
            ColumnRecord fr = (ColumnRecord)ti.getData();
            if (property.equals("Nullable")) {
                boolean b = fr.nullable;
                fr.nullable = (Boolean)value;
                if (b != fr.nullable) {
                    DatabaseTableEditor.this.fireModified();
                }
            } else if (property.equals("AutoIncrement")) {
                boolean b = fr.autoIncrement;
                fr.autoIncrement = (Boolean)value;
                if (b != fr.autoIncrement) {
                    DatabaseTableEditor.this.fireModified();
                }
            } else if (property.equals("Name")) {
                if (value != null) {
                    String oldName = fr.name;
                    fr.name = (String)value;
                    if (!fr.name.equals(oldName)) {
                        DatabaseTableEditor.this.fireModified();
                    }
                }
            } else if (property.equals("Length")) {
                if (value != null) {
                    int oldLength = fr.length;
                    fr.length = Integer.parseInt((String)value);
                    if (fr.length != oldLength) {
                        DatabaseTableEditor.this.fireModified();
                    }
                }
            } else if (property.equals("Type")) {
                int sel = (Integer)value;
                String oldType = fr.type;
                fr.type = DatabaseTableEditor.this.currentTypes.get(sel);
                if (!fr.type.equals(oldType)) {
                    if (fr.type.equals("Varchar")) {
                        fr.length = 45;
                    } else if (fr.type.equals("Number") || fr.type.equals("Decimal")) {
                        fr.length = 4;
                    } else if (fr.type.equals("Big Number") || fr.type.equals("Big Decimal")) {
                        fr.length = 8;
                    } else if (fr.type.equals("Text")) {
                        fr.length = 16;
                    } else if (fr.type.equals("Boolean")) {
                        fr.length = 1;
                    }
                    fr.autoIncrement = false;
                    DatabaseTableEditor.this.fireModified();
                }
            }
            DatabaseTableEditor.this.viewer.refresh(true);
        }
    }

    public class FieldContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            DatabaseTableEditor.this.tumbler = 0;
            return DatabaseTableEditor.this.columnRecords.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class FieldLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        Color alternateBackground;
        Color background;
        Color foreground;

        public FieldLabelProvider() {
            this.alternateBackground = new Color((Device)DatabaseTableEditor.this.viewer.getControl().getDisplay(), 216, 238, 255);
            this.background = DatabaseTableEditor.this.viewer.getControl().getDisplay().getSystemColor(1);
            this.foreground = DatabaseTableEditor.this.viewer.getControl().getDisplay().getSystemColor(2);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ColumnRecord fr = (ColumnRecord)element;
            if (columnIndex == 0) {
                return Activator.getDefault().getImageRegistry().get("ICON_TINY_SQUARE");
            }
            if (columnIndex == 3) {
                if (fr.nullable) {
                    return Activator.getDefault().getImageRegistry().get("ICON_CHECKBOX_TRUE");
                }
                return Activator.getDefault().getImageRegistry().get("ICON_CHECKBOX_FALSE");
            }
            if (columnIndex == 4 && (fr.type.equals("Big Number") || fr.type.equals("Number"))) {
                if (fr.autoIncrement) {
                    return Activator.getDefault().getImageRegistry().get("ICON_CHECKBOX_TRUE");
                }
                return Activator.getDefault().getImageRegistry().get("ICON_CHECKBOX_FALSE");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ColumnRecord fr = (ColumnRecord)element;
            if (columnIndex == 0) {
                return fr.name;
            }
            if (columnIndex == 1) {
                return fr.type;
            }
            if (columnIndex == 2) {
                return Integer.toString(fr.length);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.alternateBackground.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object element) {
            return this.foreground;
        }

        public Color getBackground(Object element) {
            Color bg = null;
            bg = DatabaseTableEditor.this.tumbler % 2 == 0 ? this.background : this.alternateBackground;
            ++DatabaseTableEditor.this.tumbler;
            return bg;
        }
    }
}

