/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.database.ui.export;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.export.IExportAgent;
import org.eclipse.vtp.desktop.export.IMediaExporter;
import org.eclipse.vtp.desktop.export.IWorkflowExporter;
import org.eclipse.vtp.framework.databases.configurations.DatabaseColumnConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseTableConfiguration;
import org.eclipse.vtp.framework.databases.configurations.JdbcDatabaseConfiguration;
import org.eclipse.vtp.framework.databases.configurations.JndiDatabaseConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseExportAgent
implements IExportAgent {
    private static final Comparator<IWorkflowExporter> WORKFLOW_COMPARE = new Comparator<IWorkflowExporter>(){

        @Override
        public int compare(IWorkflowExporter left, IWorkflowExporter right) {
            return left.getProject().getFullPath().toString().compareTo(right.getProject().getFullPath().toString());
        }
    };
    private static final Comparator<IFolder> RESOURCE_COMPARE = new Comparator<IFolder>(){

        @Override
        public int compare(IFolder left, IFolder right) {
            return left.getFullPath().toString().compareTo(right.getFullPath().toString());
        }
    };
    private final Map<IWorkflowExporter, Map<IFolder, Map<String, String>>> settings = new TreeMap<IWorkflowExporter, Map<IFolder, Map<String, String>>>(WORKFLOW_COMPARE);
    private ConfigureDatabasesPage page = new ConfigureDatabasesPage();

    public Collection<IWizardPage> init() {
        return Collections.singleton(this.page);
    }

    public void setProjects(Collection<? extends IWorkflowExporter> workflowProjects, Collection<? extends IMediaExporter> mediaProjects) {
        this.settings.clear();
        for (IWorkflowExporter iWorkflowExporter : workflowProjects) {
            try {
                IProject project = iWorkflowExporter.getProject();
                IFolder databases = project.getFolder("Databases");
                if (databases == null || !databases.exists()) continue;
                IResource[] children = null;
                try {
                    children = databases.members();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (children == null || children.length == 0) continue;
                TreeMap folders = new TreeMap(RESOURCE_COMPARE);
                int j = 0;
                while (j < children.length) {
                    if (2 == children[j].getType()) {
                        folders.put((IFolder)children[j], null);
                    }
                    ++j;
                }
                if (folders.isEmpty()) continue;
                this.settings.put(iWorkflowExporter, folders);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.page.projectSelectionChanged();
    }

    public boolean shouldBeShown(IWizardPage page) {
        return this.settings.size() > 0;
    }

    public boolean canFinish() {
        return true;
    }

    public void configureServices(IWorkflowExporter exporter, Element servicesElement) {
        this.page.createServiceConfigurations(exporter, servicesElement);
        this.page.savePrefrences();
    }

    public class ConfigureDatabasesPage
    extends WizardPage
    implements ISelectionChangedListener,
    ModifyListener,
    SelectionListener,
    ITreeContentProvider,
    ILabelProvider {
        private Map<String, String> selectedDatabase;
        private TreeViewer viewer;
        private Combo typeCombo;
        private Composite stackComposite;
        private StackLayout stackLayout;
        private Composite jndiComposite;
        private Text jndiUriText;
        private Text jndiUsrText;
        private Text jndiPwdText;
        private Composite jdbcComposite;
        private Text jdbcDvrText;
        private Text jdbcUrlText;
        private Text jdbcUsrText;
        private Text jdbcPwdText;
        private Composite emptyComposite;

        public ConfigureDatabasesPage() {
            super("ConfigureDatabasesPage", "Configure the Exported Database Connections", null);
            this.selectedDatabase = null;
            this.viewer = null;
            this.typeCombo = null;
            this.stackComposite = null;
            this.stackLayout = null;
            this.jndiComposite = null;
            this.jndiUriText = null;
            this.jndiUsrText = null;
            this.jndiPwdText = null;
            this.jdbcComposite = null;
            this.jdbcDvrText = null;
            this.jdbcUrlText = null;
            this.jdbcUsrText = null;
            this.jdbcPwdText = null;
            this.emptyComposite = null;
        }

        private void loadDefaults(IWorkflowExporter exporter, String folderName, Map<String, String> properties) {
            String prefix = "db." + folderName + ".";
            String type = exporter.getSetting(String.valueOf(prefix) + "type");
            type = "jdbc".equalsIgnoreCase(type) ? "jdbc" : "jndi";
            properties.put("type", type);
            properties.put("dvr", exporter.getSetting(String.valueOf(prefix) + "dvr", ""));
            properties.put("url", exporter.getSetting(String.valueOf(prefix) + "url", ""));
            String uri = exporter.getSetting(String.valueOf(prefix) + "uri", "");
            if (uri.length() == 0) {
                uri = "java:comp/env/jdbc/" + folderName;
            }
            properties.put("uri", uri);
            properties.put("usr", exporter.getSetting(String.valueOf(prefix) + "usr", ""));
            properties.put("pwd", exporter.getSetting(String.valueOf(prefix) + "pwd", ""));
        }

        private void resetStack() {
            String type = this.selectedDatabase.get("type");
            if ("jndi".equalsIgnoreCase(type)) {
                this.typeCombo.select(0);
                this.stackLayout.topControl = this.jndiComposite;
                this.stackComposite.layout();
                this.jndiUriText.setText(this.selectedDatabase.get("uri"));
                this.jndiUsrText.setText(this.selectedDatabase.get("usr"));
                this.jndiPwdText.setText(this.selectedDatabase.get("pwd"));
            } else if ("jdbc".equalsIgnoreCase(type)) {
                this.typeCombo.select(1);
                this.stackLayout.topControl = this.jdbcComposite;
                this.stackComposite.layout();
                this.jdbcDvrText.setText(this.selectedDatabase.get("dvr"));
                this.jdbcUrlText.setText(this.selectedDatabase.get("url"));
                this.jdbcUsrText.setText(this.selectedDatabase.get("usr"));
                this.jdbcPwdText.setText(this.selectedDatabase.get("pwd"));
            }
        }

        public void createControl(Composite parent) {
            SashForm root = new SashForm(parent, 256);
            this.viewer = new TreeViewer((Composite)root, 2048);
            this.viewer.setContentProvider((IContentProvider)this);
            this.viewer.setLabelProvider((IBaseLabelProvider)this);
            this.viewer.setSorter(new ViewerSorter());
            this.viewer.setInput((Object)DatabaseExportAgent.this.settings);
            this.viewer.expandAll();
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
            Composite composite = new Composite((Composite)root, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label typeLabel = new Label(composite, 0);
            typeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            typeLabel.setText("Database lookup method:");
            this.typeCombo = new Combo(composite, 12);
            this.typeCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            this.typeCombo.add("JNDI Lookup");
            this.typeCombo.add("JDBC Driver");
            this.typeCombo.addSelectionListener((SelectionListener)this);
            new Label(composite, 258).setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.stackComposite = new Composite(composite, 0);
            this.stackComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.stackLayout = new StackLayout();
            this.stackComposite.setLayout((Layout)this.stackLayout);
            this.jndiComposite = new Composite(this.stackComposite, 0);
            this.jndiComposite.setLayout((Layout)new GridLayout(2, false));
            Label jndiUriLabel = new Label(this.jndiComposite, 0);
            jndiUriLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jndiUriLabel.setText("JNDI URI:");
            this.jndiUriText = new Text(this.jndiComposite, 2048);
            this.jndiUriText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jndiUriText.addModifyListener((ModifyListener)this);
            Label jndiUsrLabel = new Label(this.jndiComposite, 0);
            jndiUsrLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jndiUsrLabel.setText("User Name:");
            this.jndiUsrText = new Text(this.jndiComposite, 2048);
            this.jndiUsrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jndiUsrText.addModifyListener((ModifyListener)this);
            Label jndiPwdLabel = new Label(this.jndiComposite, 0);
            jndiPwdLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jndiPwdLabel.setText("Password:");
            this.jndiPwdText = new Text(this.jndiComposite, 2048);
            this.jndiPwdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jndiPwdText.addModifyListener((ModifyListener)this);
            this.jdbcComposite = new Composite(this.stackComposite, 0);
            this.jdbcComposite.setLayout((Layout)new GridLayout(2, false));
            Label jdbcDvrLabel = new Label(this.jdbcComposite, 0);
            jdbcDvrLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jdbcDvrLabel.setText("JDBC Driver:");
            this.jdbcDvrText = new Text(this.jdbcComposite, 2048);
            this.jdbcDvrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jdbcDvrText.addModifyListener((ModifyListener)this);
            Label jdbcUrlLabel = new Label(this.jdbcComposite, 0);
            jdbcUrlLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jdbcUrlLabel.setText("JDBC URL:");
            this.jdbcUrlText = new Text(this.jdbcComposite, 2048);
            this.jdbcUrlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jdbcUrlText.addModifyListener((ModifyListener)this);
            Label jdbcUsrLabel = new Label(this.jdbcComposite, 0);
            jdbcUsrLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jdbcUsrLabel.setText("User Name:");
            this.jdbcUsrText = new Text(this.jdbcComposite, 2048);
            this.jdbcUsrText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jdbcUsrText.addModifyListener((ModifyListener)this);
            Label jdbcPwdLabel = new Label(this.jdbcComposite, 0);
            jdbcPwdLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            jdbcPwdLabel.setText("Password:");
            this.jdbcPwdText = new Text(this.jdbcComposite, 2048);
            this.jdbcPwdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.jdbcPwdText.addModifyListener((ModifyListener)this);
            this.emptyComposite = new Composite(this.stackComposite, 0);
            this.stackLayout.topControl = this.emptyComposite;
            root.setWeights(new int[]{40, 60});
            this.setControl((Control)root);
            this.projectSelectionChanged();
        }

        public void projectSelectionChanged() {
            Map folders;
            if (this.viewer == null) {
                return;
            }
            this.viewer.refresh();
            this.viewer.expandAll();
            if (this.viewer.getSelection().isEmpty() && !DatabaseExportAgent.this.settings.isEmpty() && !(folders = (Map)DatabaseExportAgent.this.settings.values().iterator().next()).isEmpty()) {
                this.viewer.setSelection((ISelection)new StructuredSelection(folders.keySet().iterator().next()));
            }
        }

        public void savePrefrences() {
            for (IWorkflowExporter project : DatabaseExportAgent.this.settings.keySet()) {
                Map folders = (Map)DatabaseExportAgent.this.settings.get(project);
                for (IFolder folder : folders.keySet()) {
                    Map config = (Map)folders.get(folder);
                    if (config == null) continue;
                    String prefix = "db." + folder.getName() + ".";
                    for (Map.Entry entry : config.entrySet()) {
                        project.putSetting(String.valueOf(prefix) + (String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
        }

        public void createServiceConfigurations(IWorkflowExporter exporter, Element servicesElement) {
            Map folders = (Map)DatabaseExportAgent.this.settings.get(exporter);
            if (folders == null) {
                return;
            }
            Element serviceElement = servicesElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:service");
            serviceElement.setAttribute("id", "org.eclipse.vtp.framework.databases.services.database-registry");
            for (Map.Entry folderEntry : folders.entrySet()) {
                String pwd;
                IFolder folder = (IFolder)folderEntry.getKey();
                HashMap<String, String> properties = (HashMap<String, String>)folderEntry.getValue();
                if (properties == null) {
                    properties = new HashMap<String, String>();
                    this.loadDefaults(exporter, folder.getName(), properties);
                }
                JndiDatabaseConfiguration database = null;
                Element databaseElement = null;
                if ("jdbc".equals(properties.get("type"))) {
                    JdbcDatabaseConfiguration jdbc = new JdbcDatabaseConfiguration();
                    jdbc.setDriver((String)properties.get("dvr"));
                    jdbc.setUrl((String)properties.get("url"));
                    database = jdbc;
                    databaseElement = servicesElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/databases/configurations", "database:jdbc-database");
                } else {
                    JndiDatabaseConfiguration jndi = new JndiDatabaseConfiguration();
                    jndi.setUri((String)properties.get("uri"));
                    database = jndi;
                    databaseElement = servicesElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/databases/configurations", "database:jndi-database");
                }
                database.setName(folder.getName());
                String usr = (String)properties.get("usr");
                if (usr.length() > 0) {
                    database.setUsername(usr);
                }
                if ((pwd = (String)properties.get("pwd")).length() > 0) {
                    database.setPassword(pwd);
                }
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    IResource[] files = folder.members();
                    int k = 0;
                    while (k < files.length) {
                        if (1 == files[k].getType() && ((IFile)files[k]).getFileExtension().equals(".dot")) {
                            Element root = builder.parse(((IFile)files[k]).getLocation().toFile()).getDocumentElement();
                            DatabaseTableConfiguration table = new DatabaseTableConfiguration();
                            table.setName(root.getAttribute("name"));
                            NodeList list = ((Element)root.getElementsByTagName("columns").item(0)).getElementsByTagName("column");
                            int m = 0;
                            while (m < list.getLength()) {
                                Element element = (Element)list.item(m);
                                DatabaseColumnConfiguration column = new DatabaseColumnConfiguration();
                                column.setName(element.getAttribute("name"));
                                String type = ((Element)element.getElementsByTagName("column-type").item(0)).getAttribute("type");
                                if ("Varchar".equalsIgnoreCase(type)) {
                                    column.setType(8);
                                } else if ("Number".equalsIgnoreCase(type)) {
                                    column.setType(6);
                                } else if ("Big Number".equalsIgnoreCase(type)) {
                                    column.setType(2);
                                } else if ("Decimal".equalsIgnoreCase(type)) {
                                    column.setType(5);
                                } else if ("Big Decimal".equalsIgnoreCase(type)) {
                                    column.setType(1);
                                } else if ("Boolean".equalsIgnoreCase(type)) {
                                    column.setType(3);
                                } else if ("DateTime".equalsIgnoreCase(type)) {
                                    column.setType(4);
                                } else {
                                    column.setType(7);
                                }
                                table.addColumn(column);
                                ++m;
                            }
                            database.addTable(table);
                        }
                        ++k;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                database.save(databaseElement);
                serviceElement.appendChild(databaseElement);
            }
            servicesElement.appendChild(serviceElement);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object value = null;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                value = selection.getFirstElement();
            }
            if (value instanceof IProject) {
                value = null;
            }
            if (value == null) {
                this.selectedDatabase = null;
                this.typeCombo.setEnabled(false);
                this.stackLayout.topControl = this.emptyComposite;
                this.stackComposite.layout();
                return;
            }
            IFolder folder = (IFolder)value;
            IWorkflowExporter exporter = this.getExporter((IResource)folder);
            Map folders = (Map)DatabaseExportAgent.this.settings.get(exporter);
            this.selectedDatabase = (Map)folders.get(folder);
            if (this.selectedDatabase == null) {
                this.selectedDatabase = new HashMap<String, String>();
                folders.put(folder, this.selectedDatabase);
                this.loadDefaults(exporter, folder.getName(), this.selectedDatabase);
            }
            this.typeCombo.setEnabled(true);
            this.resetStack();
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (this.jndiUriText == source) {
                this.selectedDatabase.put("uri", this.jndiUriText.getText());
            } else if (this.jndiUsrText == source) {
                this.selectedDatabase.put("usr", this.jndiUsrText.getText());
            } else if (this.jndiPwdText == source) {
                this.selectedDatabase.put("pwd", this.jndiPwdText.getText());
            } else if (this.jdbcDvrText == source) {
                this.selectedDatabase.put("dvr", this.jdbcDvrText.getText());
            } else if (this.jdbcUrlText == source) {
                this.selectedDatabase.put("url", this.jdbcUrlText.getText());
            } else if (this.jdbcUsrText == source) {
                this.selectedDatabase.put("usr", this.jdbcUsrText.getText());
            } else if (this.jdbcPwdText == source) {
                this.selectedDatabase.put("pwd", this.jdbcPwdText.getText());
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (this.typeCombo == source) {
                switch (this.typeCombo.getSelectionIndex()) {
                    case 0: {
                        this.selectedDatabase.put("type", "jndi");
                        break;
                    }
                    case 1: {
                        this.selectedDatabase.put("type", "jdbc");
                    }
                }
                this.resetStack();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return DatabaseExportAgent.this.settings.keySet().toArray();
        }

        public Object getParent(Object element) {
            IWorkflowExporter exporter;
            if (element instanceof IWorkflowExporter) {
                return null;
            }
            if (element instanceof IResource && (exporter = this.getExporter((IResource)element)) != null) {
                return exporter;
            }
            return null;
        }

        private IWorkflowExporter getExporter(IResource resource) {
            IProject project = resource.getProject();
            for (IWorkflowExporter exporter : DatabaseExportAgent.this.settings.keySet()) {
                if (!exporter.getProject().getName().equals(project.getName())) continue;
                return exporter;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IWorkflowExporter && DatabaseExportAgent.this.settings.containsKey(element);
        }

        public Object[] getChildren(Object parentElement) {
            Map folders = (Map)DatabaseExportAgent.this.settings.get(parentElement);
            if (folders == null) {
                return new Object[0];
            }
            return folders.keySet().toArray();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public String getText(Object element) {
            if (element instanceof IWorkflowExporter) {
                return ((IWorkflowExporter)element).getProject().getName();
            }
            if (element instanceof IResource) {
                return ((IResource)element).getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

