/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.database.ui.properties;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.core.dialogs.FramedDialog;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectField;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.IDatabase;
import org.eclipse.vtp.desktop.model.core.IDatabaseTable;
import org.eclipse.vtp.desktop.model.core.IDatabaseTableColumn;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.VariableHelper;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.database.ui.DatabaseQueryInformationProvider;
import org.eclipse.vtp.modules.database.ui.properties.DatabaseQuerySettingsListener;
import org.eclipse.vtp.modules.database.ui.properties.DatabaseQuerySettingsStructure;

public class DatabaseQueryDataMappingPropertiesPanel
extends DesignElementPropertiesPanel
implements DatabaseQuerySettingsListener {
    DatabaseQueryInformationProvider queryElement;
    DatabaseQuerySettingsStructure settings;
    TableViewer mappingTableViewer;
    ObjectDefinition currentObject;
    ValueCellEditor valueCellEditor;
    List<Variable> incomingVariables = null;

    public DatabaseQueryDataMappingPropertiesPanel(PrimitiveElement dqe, DatabaseQuerySettingsStructure settings) {
        super("Fields", (IDesignElement)dqe);
        this.queryElement = (DatabaseQueryInformationProvider)dqe.getInformationProvider();
        this.settings = settings;
        settings.addSettingsListener(this);
        this.incomingVariables = dqe.getDesign().getVariablesFor((IDesignElement)dqe);
    }

    public void createControls(Composite parent) {
        Table mappingTable = new Table(parent, 67588);
        mappingTable.setHeaderVisible(true);
        TableColumn businessObjectFieldColumn = new TableColumn(mappingTable, 0);
        businessObjectFieldColumn.setText("Business Object Field");
        businessObjectFieldColumn.setWidth(150);
        TableColumn valueColumn = new TableColumn(mappingTable, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(200);
        this.valueCellEditor = new ValueCellEditor((Composite)mappingTable);
        this.mappingTableViewer = new TableViewer(mappingTable);
        this.mappingTableViewer.setColumnProperties(new String[]{"Field", "Value"});
        this.mappingTableViewer.setCellModifier((ICellModifier)new MappingCellModifier());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.valueCellEditor;
        this.mappingTableViewer.setCellEditors(cellEditorArray);
        this.mappingTableViewer.setContentProvider((IContentProvider)new MappingContentProvider());
        this.mappingTableViewer.setLabelProvider((IBaseLabelProvider)new MappingLabelProvider());
        this.mappingTableViewer.setInput((Object)this);
        if (this.settings.targetVariableName != null && !this.settings.targetVariableName.equals("") && this.settings.targetVariableType != null && !this.settings.targetVariableType.equals((Object)"")) {
            if (this.settings.targetVariableExists) {
                String tname = this.settings.targetVariableName;
                String[] parts = tname.split("\\.");
                this.currentObject = this.findObjectDefinition(this.incomingVariables, parts[0]);
                int i = 1;
                while (i < parts.length) {
                    this.currentObject = this.findObjectDefinition(this.currentObject.getFields(), parts[i]);
                    if (this.currentObject == null) break;
                    ++i;
                }
                if (this.currentObject != null) {
                    if (this.currentObject.getType().hasBaseType()) {
                        if (!this.currentObject.getType().isObject()) {
                            List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                            DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                            databaseQuerySettingsStructure.getClass();
                            list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, "Value", -1, null));
                        } else {
                            List businessObjects = this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObjects();
                            int i2 = 0;
                            while (i2 < businessObjects.size()) {
                                IBusinessObject ibo = (IBusinessObject)businessObjects.get(i2);
                                if (ibo.getName().equals(this.settings.targetVariableType)) {
                                    List fields = ibo.getFields();
                                    int f = 0;
                                    while (f < fields.size()) {
                                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                                        List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                                        DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                                        databaseQuerySettingsStructure.getClass();
                                        list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, ibof.getName(), -1, null));
                                        ++f;
                                    }
                                }
                                ++i2;
                            }
                        }
                    } else if (this.currentObject.getType().isObject()) {
                        List fields = this.currentObject.getFields();
                        int i3 = 0;
                        while (i3 < fields.size()) {
                            ObjectField of = (ObjectField)fields.get(i3);
                            List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                            DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                            databaseQuerySettingsStructure.getClass();
                            list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, of.getName(), -1, null));
                            ++i3;
                        }
                    } else {
                        List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                        DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                        databaseQuerySettingsStructure.getClass();
                        list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, this.currentObject.getPath(), -1, null));
                    }
                }
            } else {
                this.currentObject = VariableHelper.constructVariable((String)this.settings.targetVariableName, (IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet(), (FieldType)this.settings.targetVariableType);
            }
        }
        this.mappingTableViewer.refresh();
    }

    public ObjectDefinition findObjectDefinition(List<? extends ObjectDefinition> posibilities, String name) {
        int i = 0;
        while (i < posibilities.size()) {
            ObjectDefinition od = posibilities.get(i);
            if (od.getName().equals(name)) {
                return od;
            }
            ++i;
        }
        return null;
    }

    public void save() {
    }

    public void cancel() {
    }

    @Override
    public void targetVariableChanged() {
        if (this.settings.targetVariableName == null || this.settings.targetVariableType == null || this.settings.targetVariableName.equals("")) {
            this.currentObject = null;
            this.mappingTableViewer.refresh();
            return;
        }
        if (this.currentObject == null || !this.settings.targetVariableName.equals(this.currentObject.getPath()) || !this.settings.targetVariableType.equals((Object)this.currentObject.getType())) {
            if (this.settings.targetVariableExists) {
                int i = 0;
                while (i < this.incomingVariables.size()) {
                    Variable v = this.incomingVariables.get(i);
                    if (v.getName().equals(this.settings.targetVariableName)) {
                        this.currentObject = v;
                    } else if (this.settings.targetVariableName != null && this.settings.targetVariableName.startsWith(v.getName())) {
                        List objectFields = v.getFields();
                        int f = 0;
                        while (f < objectFields.size()) {
                            ObjectField of = (ObjectField)objectFields.get(f);
                            if (of.getPath().equals(this.settings.targetVariableName)) {
                                this.currentObject = of;
                            }
                            ++f;
                        }
                    }
                    ++i;
                }
            } else {
                this.currentObject = VariableHelper.constructVariable((String)this.settings.targetVariableName, (IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet(), (FieldType)this.settings.targetVariableType);
            }
            this.settings.dataMapping.clear();
            if (this.currentObject.getType().hasBaseType()) {
                if (!this.currentObject.getType().isObject()) {
                    List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                    DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                    databaseQuerySettingsStructure.getClass();
                    list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, "Value", -1, null));
                } else {
                    List businessObjects = this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObjects();
                    int i = 0;
                    while (i < businessObjects.size()) {
                        IBusinessObject ibo = (IBusinessObject)businessObjects.get(i);
                        if (ibo.getName().equals(this.settings.targetVariableType)) {
                            List fields = ibo.getFields();
                            int f = 0;
                            while (f < fields.size()) {
                                IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                                List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                                DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                                databaseQuerySettingsStructure.getClass();
                                list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, ibof.getName(), -1, null));
                                ++f;
                            }
                        }
                        ++i;
                    }
                }
            } else if (this.currentObject.getType().isObject()) {
                List fields = this.currentObject.getFields();
                int i = 0;
                while (i < fields.size()) {
                    ObjectField of = (ObjectField)fields.get(i);
                    List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                    DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                    databaseQuerySettingsStructure.getClass();
                    list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, of.getName(), -1, null));
                    ++i;
                }
            } else {
                List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                databaseQuerySettingsStructure.getClass();
                list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, this.currentObject.getPath(), -1, null));
            }
            this.mappingTableViewer.refresh();
        }
    }

    @Override
    public void sourceDatabaseChanged() {
        this.settings.dataMapping.clear();
        if (this.currentObject != null && this.currentObject.getType().hasBaseType()) {
            if (!this.currentObject.getType().isObject()) {
                List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                databaseQuerySettingsStructure.getClass();
                list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, "Value", -1, null));
            } else {
                List businessObjects = this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObjects();
                int i = 0;
                while (i < businessObjects.size()) {
                    IBusinessObject ibo = (IBusinessObject)businessObjects.get(i);
                    if (ibo.getName().equals(this.settings.targetVariableType)) {
                        List fields = ibo.getFields();
                        int f = 0;
                        while (f < fields.size()) {
                            IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                            List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                            DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                            databaseQuerySettingsStructure.getClass();
                            list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, ibof.getName(), -1, null));
                            ++f;
                        }
                    }
                    ++i;
                }
            }
        } else if (this.currentObject != null) {
            if (this.currentObject.getType().isObject()) {
                List fields = this.currentObject.getFields();
                int i = 0;
                while (i < fields.size()) {
                    ObjectField of = (ObjectField)fields.get(i);
                    List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                    DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                    databaseQuerySettingsStructure.getClass();
                    list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, of.getName(), -1, null));
                    ++i;
                }
            } else {
                List<DatabaseQuerySettingsStructure.DataMapping> list = this.settings.dataMapping;
                DatabaseQuerySettingsStructure databaseQuerySettingsStructure = this.settings;
                databaseQuerySettingsStructure.getClass();
                list.add(new DatabaseQuerySettingsStructure.DataMapping(databaseQuerySettingsStructure, this.currentObject.getPath(), -1, null));
            }
        }
        this.mappingTableViewer.refresh();
    }

    @Override
    public void dataMappingChanged() {
    }

    @Override
    public void searchCriteriaChanged() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    public class MappingCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return property.equals("Value");
        }

        public Object getValue(Object element, String property) {
            return element;
        }

        public void modify(Object element, String property, Object value) {
            DatabaseQueryDataMappingPropertiesPanel.this.mappingTableViewer.refresh();
        }
    }

    public class MappingContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (DatabaseQueryDataMappingPropertiesPanel.this.currentObject == null) {
                return new Object[0];
            }
            return DatabaseQueryDataMappingPropertiesPanel.this.settings.dataMapping.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class MappingLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            DatabaseQuerySettingsStructure.DataMapping mapping = (DatabaseQuerySettingsStructure.DataMapping)element;
            if (columnIndex == 0) {
                return Activator.getDefault().getImageRegistry().get("ICON_TINY_SQUARE");
            }
            if (columnIndex == 1 && mapping.mappingType == 1) {
                return Activator.getDefault().getImageRegistry().get("ICON_DOMAIN");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DatabaseQuerySettingsStructure.DataMapping mapping = (DatabaseQuerySettingsStructure.DataMapping)element;
            if (columnIndex == 0) {
                return mapping.fieldName;
            }
            if (mapping == null) {
                return null;
            }
            switch (mapping.mappingType) {
                case -1: {
                    return "No Change";
                }
                case 0: 
                case 1: {
                    return mapping.mappingValue;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class ValueCellEditor
    extends DialogCellEditor {
        Label iconLabel;
        Composite comp;

        public ValueCellEditor(Composite parent) {
            super(parent);
        }

        protected Control createContents(Composite cell) {
            return super.createContents(cell);
        }

        protected void updateContents(Object value) {
            DatabaseQuerySettingsStructure.DataMapping mapping = (DatabaseQuerySettingsStructure.DataMapping)value;
            if (mapping != null) {
                if (mapping.mappingType == -1) {
                    this.getDefaultLabel().setText("No Change");
                } else if (mapping.mappingType == 0) {
                    this.getDefaultLabel().setText(mapping.mappingValue);
                } else {
                    this.getDefaultLabel().setText(mapping.mappingValue);
                }
            } else {
                super.updateContents(value);
            }
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            ValueDialog vd = new ValueDialog(cellEditorWindow.getShell());
            vd.setValue((DatabaseQuerySettingsStructure.DataMapping)this.getValue());
            vd.open();
            return this.getValue();
        }
    }

    public class ValueDialog
    extends FramedDialog {
        Button noChangeButton;
        Button databaseColumnButton;
        Button staticValueButton;
        Combo databaseColumnCombo;
        Text staticValueField;
        DatabaseQuerySettingsStructure.DataMapping value;
        Color darkBlue;
        Color lightBlue;
        int originalMappingType;
        String originalMappingValue;

        public ValueDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("Select a value");
        }

        public void setValue(DatabaseQuerySettingsStructure.DataMapping value) {
            this.value = value;
            this.originalMappingType = value.mappingType;
            this.originalMappingValue = value.mappingValue;
        }

        public void updateValue() {
            if (this.noChangeButton.getSelection()) {
                this.value.mappingType = -1;
                this.value.mappingValue = "";
            } else if (this.staticValueButton.getSelection()) {
                this.value.mappingType = 0;
                this.value.mappingValue = this.staticValueField.getText();
            } else {
                this.value.mappingType = 1;
                this.value.mappingValue = this.databaseColumnCombo.getItem(this.databaseColumnCombo.getSelectionIndex());
            }
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            Button okButton = new Button(buttons, 8);
            okButton.setText("Ok");
            okButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ValueDialog.this.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 8);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ValueDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (Display.getCurrent().getDismissalAlignment() == 131072) {
                cancelButton.moveAbove((Control)okButton);
            }
            this.getShell().setDefaultButton(okButton);
        }

        public void okPressed() {
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.value.mappingType = this.originalMappingType;
            this.value.mappingValue = this.originalMappingValue;
            this.setReturnCode(256);
            this.close();
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ValueDialog.this.darkBlue.dispose();
                    ValueDialog.this.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            GridLayout gl = new GridLayout(2, false);
            gl.marginTop = 20;
            parent.setLayout((Layout)gl);
            this.noChangeButton = new Button(parent, 16);
            this.noChangeButton.setText("Do not change this field");
            this.noChangeButton.setBackground(parent.getBackground());
            this.noChangeButton.setSelection(this.value.mappingType == -1);
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            this.noChangeButton.setLayoutData((Object)gd);
            this.databaseColumnButton = new Button(parent, 16);
            this.databaseColumnButton.setText("Use the value from this table column");
            this.databaseColumnButton.setBackground(parent.getBackground());
            this.databaseColumnButton.setSelection(this.value.mappingType == 1);
            this.databaseColumnButton.setLayoutData((Object)new GridData());
            this.databaseColumnCombo = new Combo(parent, 2060);
            this.databaseColumnCombo.setLayoutData((Object)new GridData(768));
            this.staticValueButton = new Button(parent, 16);
            this.staticValueButton.setText("Use the value I've entered");
            this.staticValueButton.setBackground(parent.getBackground());
            this.staticValueButton.setSelection(this.value.mappingType == 0);
            this.staticValueButton.setLayoutData((Object)new GridData());
            this.staticValueField = new Text(parent, 2052);
            this.staticValueField.setLayoutData((Object)new GridData(768));
            int columnSel = 0;
            List databases = DatabaseQueryDataMappingPropertiesPanel.this.getElement().getDesign().getDocument().getProject().getDatabaseSet().getDatabases();
            int i = 0;
            while (i < databases.size()) {
                IDatabase database = (IDatabase)databases.get(i);
                if (database.getName().equals(DatabaseQueryDataMappingPropertiesPanel.this.settings.sourceDatabase)) {
                    List tables = database.getTables();
                    int t = 0;
                    while (t < tables.size()) {
                        IDatabaseTable table = (IDatabaseTable)tables.get(t);
                        if (table.getName().equals(DatabaseQueryDataMappingPropertiesPanel.this.settings.sourceDatabaseTable)) {
                            List columns = table.getColumns();
                            int c = 0;
                            while (c < columns.size()) {
                                IDatabaseTableColumn column = (IDatabaseTableColumn)columns.get(c);
                                this.databaseColumnCombo.add(column.getName());
                                if (column.getName().equals(this.value.mappingValue)) {
                                    columnSel = c;
                                }
                                ++c;
                            }
                        }
                        ++t;
                    }
                }
                ++i;
            }
            this.databaseColumnCombo.select(columnSel);
            if (this.value.mappingType == 0) {
                this.staticValueField.setText(this.value.mappingValue == null ? "" : this.value.mappingValue);
            }
            this.databaseColumnCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ValueDialog.this.updateValue();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.staticValueField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    ValueDialog.this.updateValue();
                }
            });
            this.noChangeButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ValueDialog.this.noChangeButton.getSelection()) {
                        ValueDialog.this.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.staticValueButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ValueDialog.this.staticValueButton.getSelection()) {
                        ValueDialog.this.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.databaseColumnButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ValueDialog.this.databaseColumnButton.getSelection()) {
                        ValueDialog.this.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }
}

