/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.database.ui.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.modules.database.ui.properties.DatabaseQuerySettingsListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseQuerySettingsStructure
implements Cloneable {
    IBusinessObjectSet objectSet;
    List<DatabaseQuerySettingsListener> listeners = new ArrayList<DatabaseQuerySettingsListener>();
    boolean targetVariableExists = true;
    String targetVariableName = null;
    FieldType targetVariableType = null;
    boolean targetVariableSecure = false;
    String sourceDatabase = null;
    String sourceDatabaseTable = null;
    List<DataMapping> dataMapping = new ArrayList<DataMapping>();
    List<SelectionCriteria> criteria = new ArrayList<SelectionCriteria>();
    int resultLimit = -1;

    public DatabaseQuerySettingsStructure(IBusinessObjectSet objectSet) {
        this.objectSet = objectSet;
    }

    public boolean isTargetVariableExists() {
        return this.targetVariableExists;
    }

    public void setTargetVariableExists(boolean targetVariableExists) {
        this.targetVariableExists = targetVariableExists;
    }

    public boolean isTargetVariableSecure() {
        return this.targetVariableSecure;
    }

    public void setTargetVariableSecure(boolean secure) {
        this.targetVariableSecure = secure;
    }

    public String getTargetVariableName() {
        return this.targetVariableName;
    }

    public void setTargetVariableName(String targetVariableName) {
        this.targetVariableName = targetVariableName;
    }

    public FieldType getTargetVariableType() {
        return this.targetVariableType;
    }

    public void setTargetVariableType(FieldType targetVariableType) {
        this.targetVariableType = targetVariableType;
    }

    public boolean isComplete() {
        if (this.targetVariableName == null || this.targetVariableName.equals("")) {
            return false;
        }
        if (this.targetVariableType == null || this.targetVariableType.equals((Object)"")) {
            return false;
        }
        if (this.sourceDatabase == null || this.sourceDatabase.equals("")) {
            return false;
        }
        return this.sourceDatabaseTable != null && !this.sourceDatabaseTable.equals("");
    }

    public Object clone() {
        DatabaseQuerySettingsStructure copy = new DatabaseQuerySettingsStructure(this.objectSet);
        copy.targetVariableExists = this.targetVariableExists;
        copy.targetVariableName = this.targetVariableName;
        copy.targetVariableType = this.targetVariableType;
        copy.targetVariableSecure = this.targetVariableSecure;
        copy.sourceDatabase = this.sourceDatabase;
        copy.sourceDatabaseTable = this.sourceDatabaseTable;
        Iterator<DataMapping> iterator = this.dataMapping.iterator();
        while (iterator.hasNext()) {
            copy.dataMapping.add((DataMapping)iterator.next().clone());
        }
        Iterator<SelectionCriteria> iterator2 = this.criteria.iterator();
        while (iterator2.hasNext()) {
            copy.criteria.add((SelectionCriteria)iterator2.next().clone());
        }
        copy.resultLimit = this.resultLimit;
        return copy;
    }

    public void read(Element element) {
        this.targetVariableExists = Boolean.valueOf(element.getAttribute("var-exists"));
        this.targetVariableName = element.getAttribute("var-name");
        if (element.getAttributeNode("var-type") != null) {
            IBusinessObject bo;
            FieldType.Primitive prim;
            boolean array;
            String type = element.getAttribute("var-type");
            boolean bl = array = Integer.parseInt(element.getAttribute("var-multi")) > 0;
            if (array) {
                prim = FieldType.Primitive.find((String)type);
                if (prim != null) {
                    this.targetVariableType = new FieldType(FieldType.Primitive.ARRAY, prim);
                } else {
                    bo = this.objectSet.getBusinessObject(type);
                    this.targetVariableType = new FieldType(FieldType.Primitive.ARRAY, bo);
                }
            } else {
                prim = FieldType.Primitive.find((String)type);
                if (prim != null) {
                    this.targetVariableType = new FieldType(prim);
                } else {
                    bo = this.objectSet.getBusinessObject(type);
                    this.targetVariableType = new FieldType(bo);
                }
            }
        } else {
            List typeElements = XMLUtilities.getElementsByTagName((Element)element, (String)"data-type", (boolean)true);
            if (typeElements.size() > 0) {
                this.targetVariableType = FieldType.load((IBusinessObjectSet)this.objectSet, (Element)((Element)typeElements.get(0)));
            }
        }
        this.targetVariableSecure = Boolean.parseBoolean(element.getAttribute("var-secured"));
        this.sourceDatabase = element.getAttribute("db-name");
        this.sourceDatabaseTable = element.getAttribute("db-table");
        this.resultLimit = Integer.parseInt(element.getAttribute("db-result-limit"));
        NodeList nl = element.getElementsByTagName("mapping");
        int i = 0;
        while (i < nl.getLength()) {
            Element dmElement = (Element)nl.item(i);
            DataMapping dm = new DataMapping(dmElement.getAttribute("name"), Integer.parseInt(dmElement.getAttribute("type")), dmElement.getAttribute("value"));
            this.dataMapping.add(dm);
            ++i;
        }
        nl = element.getElementsByTagName("criterium");
        i = 0;
        while (i < nl.getLength()) {
            Element scElement = (Element)nl.item(i);
            SelectionCriteria sc = new SelectionCriteria(scElement.getAttribute("name"));
            sc.comparison = Integer.parseInt(scElement.getAttribute("comp"));
            sc.type = Integer.parseInt(scElement.getAttribute("type"));
            sc.value = scElement.getAttribute("value");
            this.criteria.add(sc);
            ++i;
        }
    }

    public void write(Element element) {
        element.setAttribute("var-exists", Boolean.toString(this.targetVariableExists));
        element.setAttribute("var-name", this.targetVariableName == null ? "" : this.targetVariableName);
        if (this.targetVariableType != null) {
            this.targetVariableType.write(element);
        }
        element.setAttribute("var-secured", Boolean.toString(this.targetVariableSecure));
        element.setAttribute("db-name", this.sourceDatabase == null ? "" : this.sourceDatabase);
        element.setAttribute("db-table", this.sourceDatabaseTable == null ? "" : this.sourceDatabaseTable);
        element.setAttribute("db-result-limit", Integer.toString(this.resultLimit));
        Element mappingsElement = element.getOwnerDocument().createElement("mappings");
        element.appendChild(mappingsElement);
        int i = 0;
        while (i < this.dataMapping.size()) {
            DataMapping dm = this.dataMapping.get(i);
            Element dmElement = mappingsElement.getOwnerDocument().createElement("mapping");
            mappingsElement.appendChild(dmElement);
            dmElement.setAttribute("name", dm.fieldName == null ? "" : dm.fieldName);
            dmElement.setAttribute("type", Integer.toString(dm.mappingType));
            dmElement.setAttribute("value", dm.mappingValue == null ? "" : dm.mappingValue);
            ++i;
        }
        Element criteriaElement = element.getOwnerDocument().createElement("criteria");
        element.appendChild(criteriaElement);
        int i2 = 0;
        while (i2 < this.criteria.size()) {
            SelectionCriteria sc = this.criteria.get(i2);
            Element scElement = criteriaElement.getOwnerDocument().createElement("criterium");
            criteriaElement.appendChild(scElement);
            scElement.setAttribute("name", sc.columnName == null ? "" : sc.columnName);
            scElement.setAttribute("comp", Integer.toString(sc.comparison));
            scElement.setAttribute("type", Integer.toString(sc.type));
            scElement.setAttribute("value", sc.value == null ? "" : sc.value);
            ++i2;
        }
    }

    public void addSettingsListener(DatabaseQuerySettingsListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void fireTargetChanged() {
        Iterator<DatabaseQuerySettingsListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().targetVariableChanged();
        }
    }

    public void fireSourceChanged() {
        Iterator<DatabaseQuerySettingsListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().sourceDatabaseChanged();
        }
    }

    public void fireDataMappingChanged() {
        Iterator<DatabaseQuerySettingsListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().dataMappingChanged();
        }
    }

    public void fireSearchCriteriaChanged() {
        Iterator<DatabaseQuerySettingsListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().searchCriteriaChanged();
        }
    }

    public class DataMapping
    implements Cloneable {
        String fieldName;
        int mappingType = 0;
        String mappingValue;

        public DataMapping(String fieldName, int mappingType, String mappingValue) {
            this.fieldName = fieldName;
            this.mappingType = mappingType;
            this.mappingValue = mappingValue;
        }

        public Object clone() {
            DataMapping copy = new DataMapping(this.fieldName, this.mappingType, this.mappingValue);
            return copy;
        }
    }

    public class SelectionCriteria
    implements Cloneable {
        String columnName = null;
        int comparison = -1;
        int type = -1;
        String value = null;

        public SelectionCriteria(String columnName) {
            this.columnName = columnName;
        }

        public Object clone() {
            SelectionCriteria copy = new SelectionCriteria(this.columnName);
            copy.comparison = this.comparison;
            copy.type = this.type;
            copy.value = this.value;
            return copy;
        }
    }
}

