/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.database.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.framework.util.VariableNameValidator;
import org.eclipse.vtp.modules.database.ui.DatabaseQueryInformationProvider;
import org.eclipse.vtp.modules.database.ui.properties.DatabaseQuerySettingsStructure;

public class DatabaseQueryTargetVariablePropertiesPanel
extends DesignElementPropertiesPanel {
    DatabaseQueryInformationProvider queryElement;
    DatabaseQuerySettingsStructure settings;
    Button existingVariableButton;
    Button newVariableButton;
    TreeViewer existingVariableViewer;
    Text newVariableNameField;
    Combo multiplicityCombo;
    Combo typeCombo;
    List<String> typeList;
    List<Variable> incomingVariables;
    Button newVariableSecureButton;

    public DatabaseQueryTargetVariablePropertiesPanel(PrimitiveElement dqe, DatabaseQuerySettingsStructure settings) {
        super("Target Variable", (IDesignElement)dqe);
        this.queryElement = (DatabaseQueryInformationProvider)dqe.getInformationProvider();
        this.settings = settings;
        this.incomingVariables = dqe.getDesign().getVariablesFor((IDesignElement)dqe);
    }

    public void createControls(Composite parent) {
        final Font bold = new Font((Device)parent.getDisplay(), "Arial", 8, 1);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                bold.dispose();
            }
        });
        this.existingVariableButton = new Button(parent, 16);
        this.existingVariableButton.setText("Existing Variable");
        this.existingVariableButton.setSelection(this.settings.targetVariableExists);
        this.existingVariableButton.setFont(bold);
        this.existingVariableButton.setBackground(parent.getBackground());
        Tree existingVariableTree = new Tree(parent, 67588);
        existingVariableTree.setHeaderVisible(true);
        existingVariableTree.setEnabled(this.settings.targetVariableExists);
        TreeColumn nameColumn = new TreeColumn(existingVariableTree, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(100);
        TreeColumn typeColumn = new TreeColumn(existingVariableTree, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(100);
        this.existingVariableViewer = new TreeViewer(existingVariableTree);
        this.existingVariableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.existingVariableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.existingVariableViewer.setInput((Object)this);
        if (this.settings.targetVariableExists) {
            int i = 0;
            while (i < this.incomingVariables.size()) {
                Variable v = this.incomingVariables.get(i);
                if (v.getName().equals(this.settings.targetVariableName)) {
                    this.existingVariableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
                } else if (this.settings.targetVariableName != null && this.settings.targetVariableName.startsWith(v.getName())) {
                    List objectFields = v.getFields();
                    int f = 0;
                    while (f < objectFields.size()) {
                        ObjectField of = (ObjectField)objectFields.get(f);
                        if (of.getPath().equals(this.settings.targetVariableName)) {
                            this.existingVariableViewer.setSelection((ISelection)new StructuredSelection((Object)of));
                        }
                        ++f;
                    }
                }
                ++i;
            }
        }
        this.newVariableButton = new Button(parent, 16);
        this.newVariableButton.setText("New Variable");
        this.newVariableButton.setSelection(!this.settings.targetVariableExists);
        this.newVariableButton.setFont(bold);
        this.newVariableButton.setBackground(parent.getBackground());
        Label newVariableNameLabel = new Label(parent, 0);
        newVariableNameLabel.setText("Name:");
        newVariableNameLabel.setBackground(parent.getBackground());
        this.newVariableNameField = new Text(parent, 2052);
        this.newVariableNameField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String currentName = String.valueOf(DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.getText().substring(0, e.start)) + e.text + DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.getText(e.end, DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.getText().length() - 1);
                if (VariableNameValidator.followsVtpNamingRules((String)currentName).booleanValue() || currentName.equals("")) {
                    DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.setForeground(DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.getDisplay().getSystemColor(2));
                    DatabaseQueryTargetVariablePropertiesPanel.this.getContainer().setCanFinish(true);
                } else {
                    DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.setForeground(DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.getDisplay().getSystemColor(3));
                    DatabaseQueryTargetVariablePropertiesPanel.this.getContainer().setCanFinish(false);
                }
            }
        });
        if (!this.settings.targetVariableExists) {
            this.newVariableNameField.setText(this.settings.targetVariableName);
        }
        this.newVariableNameField.setEnabled(!this.settings.targetVariableExists);
        this.newVariableNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableName = DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.getText();
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }
        });
        Label newVariableTypeLabel = new Label(parent, 0);
        newVariableTypeLabel.setText("Type:");
        newVariableTypeLabel.setBackground(parent.getBackground());
        this.multiplicityCombo = new Combo(parent, 12);
        this.multiplicityCombo.add("One of");
        this.multiplicityCombo.add("Array of");
        this.multiplicityCombo.setEnabled(!this.settings.targetVariableExists);
        if (!this.settings.targetVariableExists) {
            this.multiplicityCombo.select(this.settings.targetVariableType.hasBaseType() ? 1 : 0);
        } else {
            this.multiplicityCombo.select(0);
        }
        this.multiplicityCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FieldType.Primitive prim;
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableType = DatabaseQueryTargetVariablePropertiesPanel.this.multiplicityCombo.getSelectionIndex() == 0 ? ((prim = FieldType.Primitive.find((String)DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex()))) != null ? new FieldType(prim) : new FieldType(DatabaseQueryTargetVariablePropertiesPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex())))) : ((prim = FieldType.Primitive.find((String)DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex()))) != null ? new FieldType(FieldType.Primitive.ARRAY, prim) : new FieldType(FieldType.Primitive.ARRAY, DatabaseQueryTargetVariablePropertiesPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex()))));
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.typeCombo = new Combo(parent, 12);
        this.typeList = new ArrayList<String>();
        this.typeList.add("String");
        this.typeList.add("Number");
        this.typeList.add("Decimal");
        this.typeList.add("Boolean");
        this.typeList.add("DateTime");
        List bol = this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObjects();
        int i = 0;
        while (i < bol.size()) {
            this.typeList.add(((IBusinessObject)bol.get(i)).getName());
            ++i;
        }
        int sel = 0;
        int i2 = 0;
        while (i2 < this.typeList.size()) {
            this.typeCombo.add(this.typeList.get(i2));
            if (!this.settings.targetVariableExists && this.typeList.get(i2).equals(this.settings.targetVariableType.hasBaseType() ? this.settings.targetVariableType.getBaseTypeName() : this.settings.targetVariableType.getName())) {
                sel = i2;
            }
            ++i2;
        }
        this.typeCombo.setEnabled(!this.settings.targetVariableExists);
        this.typeCombo.select(sel);
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FieldType.Primitive prim;
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableType = DatabaseQueryTargetVariablePropertiesPanel.this.multiplicityCombo.getSelectionIndex() == 0 ? ((prim = FieldType.Primitive.find((String)DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex()))) != null ? new FieldType(prim) : new FieldType(DatabaseQueryTargetVariablePropertiesPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex())))) : ((prim = FieldType.Primitive.find((String)DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex()))) != null ? new FieldType(FieldType.Primitive.ARRAY, prim) : new FieldType(FieldType.Primitive.ARRAY, DatabaseQueryTargetVariablePropertiesPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex()))));
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.newVariableSecureButton = new Button(parent, 32);
        this.newVariableSecureButton.setText("This variable should be secured.");
        this.newVariableSecureButton.setSelection(!this.settings.targetVariableExists && this.settings.isTargetVariableSecure());
        this.newVariableSecureButton.setEnabled(!this.settings.targetVariableExists);
        this.newVariableSecureButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.setTargetVariableSecure(DatabaseQueryTargetVariablePropertiesPanel.this.newVariableSecureButton.getSelection());
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData existingVariableButtonData = new FormData();
        existingVariableButtonData.left = new FormAttachment(0, 20);
        existingVariableButtonData.top = new FormAttachment(0, 10);
        existingVariableButtonData.right = new FormAttachment(100, -10);
        this.existingVariableButton.setLayoutData((Object)existingVariableButtonData);
        FormData existingVariableViewerData = new FormData();
        existingVariableViewerData.left = new FormAttachment(0, 20);
        existingVariableViewerData.top = new FormAttachment((Control)this.existingVariableButton, 10);
        existingVariableViewerData.right = new FormAttachment(100, -10);
        existingVariableViewerData.height = 80;
        this.existingVariableViewer.getControl().setLayoutData((Object)existingVariableViewerData);
        FormData newVariableButtonData = new FormData();
        newVariableButtonData.left = new FormAttachment(0, 20);
        newVariableButtonData.top = new FormAttachment(this.existingVariableViewer.getControl(), 20);
        newVariableButtonData.right = new FormAttachment(100, -10);
        this.newVariableButton.setLayoutData((Object)newVariableButtonData);
        FormData newVariableNameLabelData = new FormData();
        newVariableNameLabelData.left = new FormAttachment(0, 20);
        newVariableNameLabelData.top = new FormAttachment((Control)this.newVariableButton, 12);
        newVariableNameLabel.setLayoutData((Object)newVariableNameLabelData);
        FormData newVariableNameFieldData = new FormData();
        newVariableNameFieldData.left = new FormAttachment((Control)newVariableNameLabel, 10);
        newVariableNameFieldData.top = new FormAttachment((Control)this.newVariableButton, 10);
        newVariableNameFieldData.right = new FormAttachment(100, -10);
        this.newVariableNameField.setLayoutData((Object)newVariableNameFieldData);
        FormData newVariableTypeLabelData = new FormData();
        newVariableTypeLabelData.left = new FormAttachment(0, 20);
        newVariableTypeLabelData.top = new FormAttachment((Control)this.newVariableNameField, 10);
        newVariableTypeLabelData.right = new FormAttachment(100, -10);
        newVariableTypeLabel.setLayoutData((Object)newVariableTypeLabelData);
        FormData multiplicityComboData = new FormData();
        multiplicityComboData.left = new FormAttachment(0, 20);
        multiplicityComboData.top = new FormAttachment((Control)newVariableTypeLabel, 10);
        this.multiplicityCombo.setLayoutData((Object)multiplicityComboData);
        FormData typeComboData = new FormData();
        typeComboData.left = new FormAttachment((Control)this.multiplicityCombo, 20);
        typeComboData.top = new FormAttachment((Control)newVariableTypeLabel, 10);
        typeComboData.right = new FormAttachment(100, -10);
        this.typeCombo.setLayoutData((Object)typeComboData);
        FormData secureData = new FormData();
        secureData.left = new FormAttachment(0, 20);
        secureData.top = new FormAttachment((Control)this.typeCombo, 10);
        secureData.right = new FormAttachment(100, -10);
        this.newVariableSecureButton.setLayoutData((Object)secureData);
        this.existingVariableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableName = null;
                    DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableType = null;
                } else if (selection.getFirstElement() instanceof Variable) {
                    Variable v = (Variable)selection.getFirstElement();
                    DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableName = v.getName();
                    DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableType = v.getType();
                } else {
                    ObjectField field = (ObjectField)selection.getFirstElement();
                    DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableName = field.getPath();
                    DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableType = field.getType();
                }
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }
        });
        this.existingVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseQueryTargetVariablePropertiesPanel.this.existingVariableViewer.getControl().setEnabled(DatabaseQueryTargetVariablePropertiesPanel.this.existingVariableButton.getSelection());
                DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.setEnabled(!DatabaseQueryTargetVariablePropertiesPanel.this.existingVariableButton.getSelection());
                DatabaseQueryTargetVariablePropertiesPanel.this.multiplicityCombo.setEnabled(!DatabaseQueryTargetVariablePropertiesPanel.this.existingVariableButton.getSelection());
                DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.setEnabled(!DatabaseQueryTargetVariablePropertiesPanel.this.existingVariableButton.getSelection());
                DatabaseQueryTargetVariablePropertiesPanel.this.newVariableSecureButton.setEnabled(!DatabaseQueryTargetVariablePropertiesPanel.this.existingVariableButton.getSelection());
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableExists = DatabaseQueryTargetVariablePropertiesPanel.this.existingVariableButton.getSelection();
                if (DatabaseQueryTargetVariablePropertiesPanel.this.existingVariableButton.getSelection()) {
                    IStructuredSelection selection = (IStructuredSelection)DatabaseQueryTargetVariablePropertiesPanel.this.existingVariableViewer.getSelection();
                    if (selection.isEmpty()) {
                        DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableName = null;
                        DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableType = null;
                    } else if (selection.getFirstElement() instanceof Variable) {
                        Variable v = (Variable)selection.getFirstElement();
                        DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableName = v.getName();
                        DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableType = v.getType();
                    } else {
                        ObjectField field = (ObjectField)selection.getFirstElement();
                        DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableName = field.getPath();
                        DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableType = field.getType();
                    }
                    DatabaseQueryTargetVariablePropertiesPanel.this.getContainer().setCanFinish(true);
                } else {
                    FieldType.Primitive prim;
                    DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableName = DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.getText();
                    DatabaseQueryTargetVariablePropertiesPanel.this.settings.targetVariableType = DatabaseQueryTargetVariablePropertiesPanel.this.multiplicityCombo.getSelectionIndex() == 0 ? ((prim = FieldType.Primitive.find((String)DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex()))) != null ? new FieldType(prim) : new FieldType(DatabaseQueryTargetVariablePropertiesPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex())))) : ((prim = FieldType.Primitive.find((String)DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex()))) != null ? new FieldType(FieldType.Primitive.ARRAY, prim) : new FieldType(FieldType.Primitive.ARRAY, DatabaseQueryTargetVariablePropertiesPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(DatabaseQueryTargetVariablePropertiesPanel.this.typeList.get(DatabaseQueryTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex()))));
                    DatabaseQueryTargetVariablePropertiesPanel.this.settings.setTargetVariableSecure(DatabaseQueryTargetVariablePropertiesPanel.this.newVariableSecureButton.getSelection());
                    if (VariableNameValidator.followsVtpNamingRules((String)DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.getText()).booleanValue() || DatabaseQueryTargetVariablePropertiesPanel.this.newVariableNameField.getText().equals("")) {
                        DatabaseQueryTargetVariablePropertiesPanel.this.getContainer().setCanFinish(true);
                    } else {
                        DatabaseQueryTargetVariablePropertiesPanel.this.getContainer().setCanFinish(false);
                    }
                }
                DatabaseQueryTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void save() {
        this.queryElement.getElement().setName(this.queryElement.getElement().getName());
        this.queryElement.setSettings(this.settings);
    }

    public void cancel() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    public class VariableContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            return DatabaseQueryTargetVariablePropertiesPanel.this.incomingVariables.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof Variable) {
                return null;
            }
            return ((ObjectField)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return true;
        }

        public Object[] getChildren(Object parentElement) {
            return ((ObjectDefinition)parentElement).getFields().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ObjectDefinition)element).getName();
            }
            FieldType ft = ((ObjectDefinition)element).getType();
            String ret = "";
            ret = String.valueOf(ret) + ft.getName();
            if (ft.hasBaseType()) {
                ret = String.valueOf(ret) + "Array Of ";
                ret = String.valueOf(ret) + ft.getBaseTypeName();
            }
            return ret;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

