/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.ISecurableElement;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MenuChoice;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.modules.interactive.ui.ExtendedInteractiveEventManager;
import org.eclipse.vtp.modules.interactive.ui.properties.MenuChoiceBindingManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OptionSetInformationProvider
extends PrimitiveInformationProvider
implements ISecurableElement {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    boolean secured = false;

    public OptionSetInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.input.nomatch", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.input.noinput", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.disconnect.hangup", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        List<String> events = ExtendedInteractiveEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            this.connectorRecords.add(new ConnectorRecord((DesignElement)element, event, IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        }
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        for (ConnectorRecord cr : this.connectorRecords) {
            if (!cr.getName().equals(recordName)) continue;
            return cr;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        for (ConnectorRecord cr : this.connectorRecords) {
            if (!cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) continue;
            ret.add(cr);
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        this.secured = Boolean.parseBoolean(configuration.getAttribute("secured"));
        this.updateConfiguration(configuration);
        MenuChoiceBindingManager mcBindingManager = (MenuChoiceBindingManager)this.getElement().getConfigurationManager("org.eclipse.vtp.configuration.menuchoice");
        List<MenuChoice> choices = mcBindingManager.getAllChoices();
        System.err.println("# of binding choices: " + choices.size());
        for (MenuChoice mc : choices) {
            this.connectorRecords.add(new ConnectorRecord((DesignElement)this.getElement(), mc.getOptionName(), IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        }
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)mcBindingManager);
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("secured", Boolean.toString(this.secured));
    }

    public MenuChoice addChoice(String brand, MenuChoice choice) {
        this.connectorRecords.add(new ConnectorRecord((DesignElement)this.getElement(), choice.getOptionName(), IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        return choice;
    }

    public void removeChoice(String brand, MenuChoice choice, boolean found) {
        if (!found) {
            for (ConnectorRecord cr : this.connectorRecords) {
                if (!cr.getName().equals(choice.getOptionName())) continue;
                if (cr.getDesignConnector() != null) {
                    IDesignConnector connector = cr.getDesignConnector();
                    connector.removeConnectionPoint((IDesignElementConnectionPoint)cr);
                    if (connector.getConnectionPoints().size() == 0) {
                        this.getElement().getDesign().removeDesignConnector(connector);
                    }
                }
                this.connectorRecords.remove(cr);
                break;
            }
        }
    }

    public void updateChoice(MenuChoice choice, String oldName) {
        for (ConnectorRecord cr : this.connectorRecords) {
            if (!cr.getName().equals(oldName)) continue;
            cr.setName(choice.getOptionName());
            break;
        }
    }

    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        return Collections.emptyList();
    }

    public boolean hasConnectors() {
        return true;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public void updateConfiguration(Element configuration) {
        MenuChoiceBindingManager mcBindingManager = (MenuChoiceBindingManager)this.getElement().getConfigurationManager("org.eclipse.vtp.configuration.menuchoice");
        ArrayList<MenuChoice> menuChoices = new ArrayList<MenuChoice>();
        HashMap brandOrders = new HashMap();
        System.out.println("Converting the old xml");
        List choicesElements = XMLUtilities.getElementsByTagName((Element)configuration, (String)"choices", (boolean)true);
        if (choicesElements.size() == 0) {
            System.err.println("does not have old config");
            this.getElement().rollbackConfigurationChanges((ConfigurationManager)mcBindingManager);
            return;
        }
        List choices = XMLUtilities.getElementsByTagName((Element)((Element)choicesElements.get(0)), (String)"choice", (boolean)true);
        System.err.println("# of choices: " + choices.size());
        if (choices.size() == 0) {
            this.getElement().rollbackConfigurationChanges((ConfigurationManager)mcBindingManager);
            return;
        }
        for (Element choiceElement : choices) {
            MenuChoice mc = new MenuChoice(choiceElement.getAttribute("name"), choiceElement.getAttribute("script"));
            menuChoices.add(mc);
        }
        NodeList brandOrdersList = configuration.getElementsByTagName("brand-order");
        if (brandOrdersList.getLength() == 0) {
            ArrayList<MenuChoice> defaultList = new ArrayList<MenuChoice>();
            defaultList.addAll(menuChoices);
            brandOrders.put("Default", defaultList);
        }
        int i = 0;
        while (i < brandOrdersList.getLength()) {
            ArrayList<MenuChoice> brandList = new ArrayList<MenuChoice>();
            Element brandOrderElement = (Element)brandOrdersList.item(i);
            String brandName = brandOrderElement.getAttribute("brand");
            NodeList entryList = brandOrderElement.getElementsByTagName("entry");
            int e = 0;
            while (e < entryList.getLength()) {
                Element entryElement = (Element)entryList.item(e);
                for (MenuChoice mc : menuChoices) {
                    if (!mc.getOptionName().equals(entryElement.getAttribute("name"))) continue;
                    brandList.add(mc);
                    break;
                }
                ++e;
            }
            brandOrders.put(brandName, brandList);
            ++i;
        }
        if (brandOrders.get("Default") == null) {
            ArrayList<MenuChoice> defaultList = new ArrayList<MenuChoice>();
            defaultList.addAll(menuChoices);
            brandOrders.put("Default", defaultList);
        }
        for (String currentBrandName : brandOrders.keySet()) {
            List mcList = (List)brandOrders.get(currentBrandName);
            int b = 0;
            while (b < mcList.size()) {
                MenuChoice option = (MenuChoice)mcList.get(b);
                mcBindingManager.addChoice(currentBrandName, option);
                ++b;
            }
        }
        this.getElement().commitConfigurationChanges((ConfigurationManager)mcBindingManager);
    }
}

