/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.ISecurableElement;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.VariableHelper;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.modules.interactive.ui.ExtendedInteractiveEventManager;
import org.w3c.dom.Element;

public class RecordInformationProvider
extends PrimitiveInformationProvider
implements ISecurableElement {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    private String varName = "";
    boolean secured = false;

    public RecordInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.input.nomatch", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.input.noinput", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.disconnect.hangup", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        List<String> events = ExtendedInteractiveEventManager.getDefault().getExtendedEvents();
        for (String event : events) {
            this.connectorRecords.add(new ConnectorRecord((DesignElement)element, event, IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        }
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public String getVariableName() {
        return this.varName;
    }

    public void setVariableName(String varName) {
        this.varName = varName;
    }

    public void readConfiguration(Element configuration) {
        this.varName = configuration.getAttribute("var-name");
        this.secured = Boolean.parseBoolean(configuration.getAttribute("secured"));
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("var-name", XMLUtilities.encodeAttribute((String)this.varName));
        configuration.setAttribute("secured", Boolean.toString(this.secured));
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        if (exitPoint.equals("Continue") || exitPoint.equals("error.disconnect.hangup")) {
            ArrayList<Variable> ret = new ArrayList<Variable>();
            if (this.varName != null && !this.varName.equals("")) {
                IBusinessObjectSet bos = this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet();
                FieldType ft = FieldType.STRING;
                Variable v = new Variable(this.varName, ft);
                VariableHelper.buildObjectFields((ObjectDefinition)v, (IBusinessObjectSet)bos);
                ret.add(v);
                if (exitPoint.equals("Continue")) {
                    Variable dtmf = new Variable("RecordDTMF", ft);
                    VariableHelper.buildObjectFields((ObjectDefinition)dtmf, (IBusinessObjectSet)bos);
                    ret.add(dtmf);
                }
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public boolean hasConnectors() {
        return true;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }
}

