/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui.export;

import java.util.List;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.export.IConfigurationExporter;
import org.eclipse.vtp.desktop.export.IFlowElement;
import org.eclipse.vtp.desktop.model.interactive.core.content.ContentLoadingManager;
import org.eclipse.vtp.desktop.model.interactive.core.input.InputLoadingManager;
import org.eclipse.vtp.framework.interactions.core.configurations.InputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.PropertyConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionChoiceConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OptionSetConfigurationExporter
implements IConfigurationExporter {
    private static final String ELEMENT_ID = "org.eclipse.vtp.modules.interactive.optionSet";

    public void exportConfiguration(IFlowElement flowElement, Element actionElement) {
        SelectionRequestConfiguration config = new SelectionRequestConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
        config.setOutputName("Prompt");
        config.setDataName("selection");
        MediaConfiguration media = flowElement.loadMediaBindings(ELEMENT_ID);
        Element customConfig = (Element)flowElement.getConfiguration().getElementsByTagNameNS("http://www.eclipse.org/vtp/namespaces/config", "custom-config").item(0);
        config.setSecured(Boolean.parseBoolean(customConfig.getAttribute("secured")));
        List legacyChoicesElement = XMLUtilities.getElementsByTagName((Element)customConfig, (String)"choices", (boolean)true);
        if (legacyChoicesElement.size() > 0) {
            List choiceElements = XMLUtilities.getElementsByTagName((Element)((Element)legacyChoicesElement.get(0)), (String)"choice", (boolean)true);
            for (Element choiceElement : choiceElements) {
                String name = choiceElement.getAttribute("name");
                Object script = null;
                if (choiceElement.hasAttribute("script")) {
                    script = choiceElement.getAttribute("script");
                }
                String prefix = String.valueOf(name) + "-";
                MediaConfiguration choiceMedia = new MediaConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
                String[] propertyNames = media.getPropertyConfigurationNames();
                int j = 0;
                while (j < propertyNames.length) {
                    if (propertyNames[j].startsWith(prefix)) {
                        PropertyConfiguration property = media.getPropertyConfiguration(propertyNames[j]);
                        media.setPropertyConfiguration(propertyNames[j], null);
                        choiceMedia.setPropertyConfiguration(propertyNames[j].substring(prefix.length()), property);
                    }
                    ++j;
                }
                String[] outputNames = media.getOutputConfigurationNames();
                int j2 = 0;
                while (j2 < outputNames.length) {
                    if (outputNames[j2].startsWith(prefix)) {
                        OutputConfiguration output = media.getOutputConfiguration(outputNames[j2]);
                        media.setOutputConfiguration(outputNames[j2], null);
                        choiceMedia.setOutputConfiguration(outputNames[j2].substring(prefix.length()), output);
                    }
                    ++j2;
                }
                String[] inputNames = media.getInputConfigurationNames();
                int j3 = 0;
                while (j3 < inputNames.length) {
                    if (inputNames[j3].startsWith(prefix)) {
                        InputConfiguration input = media.getInputConfiguration(inputNames[j3]);
                        media.setInputConfiguration(inputNames[j3], null);
                        choiceMedia.setInputConfiguration(inputNames[j3].substring(prefix.length()), input);
                    }
                    ++j3;
                }
                SelectionChoiceConfiguration choice = new SelectionChoiceConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
                choice.setName(name);
                choice.setOutputName("prompt");
                choice.setInputName("grammar");
                if (script != null) {
                    choice.setScriptingLanguage("JavaScript");
                    choice.setScript((String)script);
                }
                choice.setMediaConfiguration(choiceMedia);
                config.addChoice(choice);
            }
            config.setMediaConfiguration(media);
            List brandOrderElements = XMLUtilities.getElementsByTagName((Element)customConfig, (String)"brand-order", (boolean)true);
            TreeMap<Integer, String> entries = new TreeMap<Integer, String>();
            for (Element brandOrder : brandOrderElements) {
                String brand = brandOrder.getAttribute("brand");
                NodeList entryElements = brandOrder.getElementsByTagNameNS(brandOrder.getNamespaceURI(), "entry");
                int j = 0;
                while (j < entryElements.getLength()) {
                    Element entryElement = (Element)entryElements.item(j);
                    entries.put(new Integer(entryElement.getAttribute("spot")), entryElement.getAttribute("name"));
                    ++j;
                }
                config.setBrandedChoices(brand, entries.values().toArray(new String[entries.size()]));
                entries.clear();
            }
        } else {
            List managedConfigs = XMLUtilities.getElementsByTagName((Element)flowElement.getConfiguration(), (String)"managed-config", (boolean)true);
            System.err.println("# of managed configs: " + managedConfigs.size());
            for (Element element : managedConfigs) {
                Element managedConfig;
                List choicesElements;
                System.err.println("type: " + element.getAttribute("type"));
                if (!"org.eclipse.vtp.configuration.menuchoice".equals(element.getAttribute("type")) || (choicesElements = XMLUtilities.getElementsByTagName((Element)(managedConfig = element), (String)"choices", (boolean)true)).size() == 0) continue;
                List choiceElements = XMLUtilities.getElementsByTagName((Element)((Element)choicesElements.get(0)), (String)"choice", (boolean)true);
                for (Element choiceElement : choiceElements) {
                    String name = choiceElement.getAttribute("name");
                    String script = null;
                    if (choiceElement.hasAttribute("script")) {
                        script = choiceElement.getAttribute("script");
                    }
                    String prefix = String.valueOf(name) + "-";
                    MediaConfiguration choiceMedia = new MediaConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
                    String[] propertyNames = media.getPropertyConfigurationNames();
                    int j = 0;
                    while (j < propertyNames.length) {
                        if (propertyNames[j].startsWith(prefix)) {
                            PropertyConfiguration property = media.getPropertyConfiguration(propertyNames[j]);
                            media.setPropertyConfiguration(propertyNames[j], null);
                            choiceMedia.setPropertyConfiguration(propertyNames[j].substring(prefix.length()), property);
                        }
                        ++j;
                    }
                    String[] outputNames = media.getOutputConfigurationNames();
                    int j4 = 0;
                    while (j4 < outputNames.length) {
                        if (outputNames[j4].startsWith(prefix)) {
                            OutputConfiguration output = media.getOutputConfiguration(outputNames[j4]);
                            media.setOutputConfiguration(outputNames[j4], null);
                            choiceMedia.setOutputConfiguration(outputNames[j4].substring(prefix.length()), output);
                        }
                        ++j4;
                    }
                    String[] inputNames = media.getInputConfigurationNames();
                    int j5 = 0;
                    while (j5 < inputNames.length) {
                        if (inputNames[j5].startsWith(prefix)) {
                            InputConfiguration input = media.getInputConfiguration(inputNames[j5]);
                            media.setInputConfiguration(inputNames[j5], null);
                            choiceMedia.setInputConfiguration(inputNames[j5].substring(prefix.length()), input);
                        }
                        ++j5;
                    }
                    SelectionChoiceConfiguration choice = new SelectionChoiceConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
                    choice.setName(name);
                    choice.setOutputName("prompt");
                    choice.setInputName("grammar");
                    if (script != null) {
                        choice.setScriptingLanguage("JavaScript");
                        choice.setScript(script);
                    }
                    choice.setMediaConfiguration(choiceMedia);
                    config.addChoice(choice);
                }
                config.setMediaConfiguration(media);
                List brandOrderElements = XMLUtilities.getElementsByTagName((Element)managedConfig, (String)"brand-order", (boolean)true);
                TreeMap<Integer, String> entries = new TreeMap<Integer, String>();
                for (Element brandOrder : brandOrderElements) {
                    String brand = brandOrder.getAttribute("brand");
                    NodeList entryElements = brandOrder.getElementsByTagNameNS(brandOrder.getNamespaceURI(), "entry");
                    int j = 0;
                    while (j < entryElements.getLength()) {
                        Element entryElement = (Element)entryElements.item(j);
                        entries.put(new Integer(entryElement.getAttribute("spot")), entryElement.getAttribute("name"));
                        ++j;
                    }
                    config.setBrandedChoices(brand, entries.values().toArray(new String[entries.size()]));
                    entries.clear();
                }
            }
        }
        Element configElement = actionElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "interactions:selection-request");
        config.save(configElement);
        actionElement.appendChild(configElement);
    }

    public String getActionId(IFlowElement flowElement) {
        return "org.eclipse.vtp.framework.interactions.core.actions.selection-request";
    }

    public String getDefaultPath(IFlowElement flowElement) {
        return null;
    }

    public String translatePath(IFlowElement flowElement, String uiPath) {
        return uiPath;
    }

    public String getTargetId(IFlowElement flowElement, Element afterTransitionElement) {
        return flowElement.getDefaultTargetId(afterTransitionElement);
    }

    public boolean isEntryPoint(IFlowElement flowElement) {
        return false;
    }
}

