/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationException;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MenuChoice;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MenuChoiceBindingManager
implements ConfigurationManager {
    public static final String TYPE_ID = "org.eclipse.vtp.configuration.menuchoice";
    public static final String XML_VERSION = "1.0.1";
    private BrandManager brandManager = null;
    private IDesign hostDesign = null;
    private List<MenuChoice> menuChoices = new ArrayList<MenuChoice>();
    private Map<String, List<MenuChoice>> brandOrders = new HashMap<String, List<MenuChoice>>();

    public MenuChoiceBindingManager(IDesign design) {
        this.hostDesign = design;
        this.brandManager = design.getDocument().getProject().getBrandManager();
        System.out.println("constructing this: " + this.getClass());
    }

    public String getType() {
        return TYPE_ID;
    }

    public String getXMLVersion() {
        return XML_VERSION;
    }

    public void readConfiguration(Element configuration) throws ConfigurationException {
        try {
            Element[] choices = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((Element)configuration, (String)"choices"));
            int ch = 0;
            while (ch < choices.length) {
                MenuChoice mc = new MenuChoice(choices[ch].getAttribute("name"), choices[ch].getAttribute("script"));
                this.menuChoices.add(mc);
                ++ch;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NodeList brandOrdersList = configuration.getElementsByTagName("brand-order");
        if (brandOrdersList.getLength() == 0) {
            ArrayList<MenuChoice> defaultList = new ArrayList<MenuChoice>();
            defaultList.addAll(this.menuChoices);
            this.brandOrders.put("Default", defaultList);
        }
        int i = 0;
        while (i < brandOrdersList.getLength()) {
            ArrayList<MenuChoice> brandList = new ArrayList<MenuChoice>();
            Element brandOrderElement = (Element)brandOrdersList.item(i);
            String brandName = brandOrderElement.getAttribute("brand");
            NodeList entryList = brandOrderElement.getElementsByTagName("entry");
            int e = 0;
            while (e < entryList.getLength()) {
                Element entryElement = (Element)entryList.item(e);
                for (MenuChoice mc : this.menuChoices) {
                    if (!mc.getOptionName().equals(entryElement.getAttribute("name"))) continue;
                    brandList.add(mc);
                    break;
                }
                ++e;
            }
            this.brandOrders.put(brandName, brandList);
            ++i;
        }
        if (this.brandOrders.get("Default") == null) {
            ArrayList<MenuChoice> defaultList = new ArrayList<MenuChoice>();
            defaultList.addAll(this.menuChoices);
            this.brandOrders.put("Default", defaultList);
        }
    }

    public void writeConfiguration(Element configuration) {
        Element choicesElement = configuration.getOwnerDocument().createElement("choices");
        configuration.appendChild(choicesElement);
        for (MenuChoice menuChoice : this.menuChoices) {
            Element choiceElement = configuration.getOwnerDocument().createElement("choice");
            choiceElement.setAttribute("name", menuChoice.getOptionName());
            if (menuChoice.getScriptText() != null) {
                choiceElement.setAttribute("script", menuChoice.getScriptText());
            }
            choicesElement.appendChild(choiceElement);
        }
        for (Map.Entry entry : this.brandOrders.entrySet()) {
            Element orderElement = configuration.getOwnerDocument().createElement("brand-order");
            orderElement.setAttribute("brand", (String)entry.getKey());
            configuration.appendChild(orderElement);
            List options = (List)entry.getValue();
            int i = 0;
            while (i < options.size()) {
                MenuChoice mc = (MenuChoice)options.get(i);
                Element orderEntryElement = configuration.getOwnerDocument().createElement("entry");
                orderEntryElement.setAttribute("name", mc.getOptionName());
                orderEntryElement.setAttribute("spot", Integer.toString(i));
                orderElement.appendChild(orderEntryElement);
                ++i;
            }
        }
    }

    public Object clone() {
        MenuChoiceBindingManager copy = new MenuChoiceBindingManager(this.hostDesign);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "temporary-document", null);
            Element rootElement = document.getDocumentElement();
            rootElement.setAttribute("xml-version", XML_VERSION);
            this.writeConfiguration(rootElement);
            copy.readConfiguration(rootElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return copy;
    }

    public BrandManager getBrandManager() {
        return this.brandManager;
    }

    public MenuChoice addChoice(String brand, MenuChoice choice) {
        List<MenuChoice> orderList = this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList<MenuChoice>((Collection)this.brandOrders.get("Default"));
            this.brandOrders.put(brand, orderList);
        }
        for (MenuChoice mc : this.menuChoices) {
            if (!mc.getOptionName().equals(choice.getOptionName())) continue;
            orderList.add(mc);
            return mc;
        }
        this.menuChoices.add(choice);
        orderList.add(choice);
        return choice;
    }

    public boolean removeChoice(String brand, MenuChoice choice) {
        List<MenuChoice> orderList = this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList<MenuChoice>((Collection)this.brandOrders.get("Default"));
            this.brandOrders.put(brand, orderList);
        }
        orderList.remove(choice);
        boolean found = false;
        for (Map.Entry<String, List<MenuChoice>> entry : this.brandOrders.entrySet()) {
            List<MenuChoice> mcList = entry.getValue();
            if (!mcList.contains(choice)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.menuChoices.remove(choice);
        }
        return found;
    }

    public void moveChoiceUp(String brand, MenuChoice choice) {
        int index;
        List<MenuChoice> orderList = this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList<MenuChoice>((Collection)this.brandOrders.get("Default"));
            this.brandOrders.put(brand, orderList);
        }
        if ((index = orderList.indexOf(choice)) > 0) {
            orderList.remove(index);
            orderList.add(index - 1, choice);
        }
    }

    public void moveChoiceDown(String brand, MenuChoice choice) {
        int index;
        List<MenuChoice> orderList = this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList<MenuChoice>((Collection)this.brandOrders.get("Default"));
            this.brandOrders.put(brand, orderList);
        }
        if ((index = orderList.indexOf(choice)) < orderList.size() - 1) {
            orderList.remove(index);
            orderList.add(index + 1, choice);
        }
    }

    public List<MenuChoice> getAllChoices() {
        return Collections.unmodifiableList(this.menuChoices);
    }

    public List<MenuChoice> getChoicesByBrand(IBrand brand) {
        List<MenuChoice> list = this.brandOrders.get(brand.getName());
        if (list == null) {
            if (!"Default".equals(brand.getName())) {
                return this.getChoicesByBrand(brand.getParent());
            }
            list = new ArrayList<MenuChoice>();
            this.brandOrders.put("Default", list);
        }
        return Collections.unmodifiableList(list);
    }
}

