/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.interactive.ui.properties;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenContainer;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenManager;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;

public class PrimitiveMediaPropertiesPanel
extends DesignElementPropertiesPanel
implements MediaConfigurationScreenContainer {
    StackLayout stackLayout = null;
    Map<String, MediaConfigurationScreen> screensByType;
    Composite comp = null;

    public PrimitiveMediaPropertiesPanel(String name, IDesignElement element) {
        super(name, element);
        PrimitiveElement pe = (PrimitiveElement)element;
        this.screensByType = MediaConfigurationScreenManager.getInstance().getIndexedMediaConfigurationScreens(pe.getSubTypeId(), (MediaConfigurationScreenContainer)this);
    }

    public void createControls(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.comp.setBackground(parent.getBackground());
        this.stackLayout = new StackLayout();
        this.comp.setLayout((Layout)this.stackLayout);
        for (Map.Entry<String, MediaConfigurationScreen> entry : this.screensByType.entrySet()) {
            MediaConfigurationScreen mcs = entry.getValue();
            mcs.createControls(this.comp);
            this.stackLayout.topControl = mcs.getControl();
        }
        this.setControl((Control)this.comp);
    }

    public void save() {
        for (Map.Entry<String, MediaConfigurationScreen> entry : this.screensByType.entrySet()) {
            MediaConfigurationScreen mcs = entry.getValue();
            mcs.save();
        }
    }

    public void cancel() {
        for (Map.Entry<String, MediaConfigurationScreen> entry : this.screensByType.entrySet()) {
            MediaConfigurationScreen mcs = entry.getValue();
            mcs.cancel();
        }
    }

    public void setConfigurationContext(Map<String, Object> values) {
        IBrand brand = (IBrand)values.get("org.eclipse.vtp.desktop.model.core.brandcontext");
        String language = (String)values.get("org.eclipse.vtp.desktop.model.interactive.core.languagecontext");
        Object object = values.get("org.eclipse.vtp.desktop.model.interactive.core.interactiontypecontext");
        if (brand == null || language == null || object == null) {
            IWorkflowProject project = this.getElement().getDesign().getDocument().getProject();
            System.out.println("project: " + project);
            final IProject uproject = project.getUnderlyingProject();
            final Shell shell = this.getContainer().getParentShell();
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox mb = new MessageBox(shell, 289);
                    mb.setText("Configuration Problems");
                    mb.setMessage("The interaction and language configuration for this project is incomplete.  You will not be able edit the applications effectively until this is resolved.  Would you like to configure this now?");
                    if (mb.open() == 32) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PropertyDialog pd = PropertyDialog.createDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.vtp.desktop.projects.core.appproperties", (Object)uproject);
                                pd.open();
                            }
                        });
                    }
                    PrimitiveMediaPropertiesPanel.this.getContainer().cancelDialog();
                }
            });
            return;
        }
        String interactionType = ((InteractionType)object).getId();
        MediaConfigurationScreen mcs = this.screensByType.get(interactionType);
        if (mcs != null) {
            mcs.setBrand(brand);
            mcs.setLanguage(language);
            this.stackLayout.topControl = mcs.getControl();
            this.comp.layout(true, true);
        }
    }

    public void cancelMediaConfiguration() {
        IWorkflowProject project = this.getElement().getDesign().getDocument().getProject();
        final IProject uproject = project.getUnderlyingProject();
        final Shell shell = this.getContainer().getParentShell();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox mb = new MessageBox(shell, 289);
                mb.setText("Configuration Problems");
                mb.setMessage("The selected language does not have an associated Voice project.  You will not be able to configure interactive modules until this is resolved.  Would you like to configure this now?");
                if (mb.open() == 32) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PropertyDialog pd = PropertyDialog.createDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.vtp.desktop.projects.core.appproperties", (Object)uproject);
                            pd.open();
                        }
                    });
                    PrimitiveMediaPropertiesPanel.this.getContainer().cancelDialog();
                }
            }
        });
    }

    public IDesignElement getDesignElement() {
        return this.getElement();
    }
}

