/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectField;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.IWorkflowEntry;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.BusinessObject;
import org.eclipse.vtp.desktop.model.core.internal.VariableHelper;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.eclipse.vtp.modules.standard.ui.VariableDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeginInformationProvider
extends PrimitiveInformationProvider
implements IWorkflowEntry {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    private List<VariableDeclaration> variableDeclarations;
    private String defaultBrandId;
    private String defaultLanguage;

    public BeginInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.disconnect.hangup", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        this.variableDeclarations = new ArrayList<VariableDeclaration>();
    }

    public List<VariableDeclaration> getDeclarations() {
        ArrayList<VariableDeclaration> copy = new ArrayList<VariableDeclaration>();
        copy.addAll(this.variableDeclarations);
        return copy;
    }

    public void setDeclarations(List<VariableDeclaration> declarations) {
        this.variableDeclarations = declarations;
    }

    public String getDefaultBrand() {
        return this.defaultBrandId;
    }

    public void setDefaultBrand(String defaultBrandId) {
        this.defaultBrandId = defaultBrandId;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return false;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        this.defaultBrandId = configuration.getAttribute("default-brand");
        this.defaultLanguage = configuration.getAttribute("default-language");
        NodeList decGroupList = configuration.getElementsByTagName("declarations");
        if (decGroupList.getLength() != 1) {
            return;
        }
        Element decGroupElement = (Element)decGroupList.item(0);
        NodeList varList = decGroupElement.getElementsByTagName("variable");
        int v = 0;
        while (v < varList.getLength()) {
            Element varElement = (Element)varList.item(v);
            String vname = varElement.getAttribute("name");
            FieldType type = null;
            if (varElement.getAttributeNode("type") != null) {
                FieldType.Primitive prim;
                int vmulti;
                String vtype = varElement.getAttribute("type");
                System.err.println("Legacy Type: " + vtype);
                int n = vmulti = varElement.getAttribute("multiplicity").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("multiplicity"));
                type = vmulti == 1 ? ((prim = FieldType.Primitive.find((String)vtype)) != null ? new FieldType(FieldType.Primitive.ARRAY, prim) : new FieldType(FieldType.Primitive.ARRAY, this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(vtype))) : ((prim = FieldType.Primitive.find((String)vtype)) != null ? new FieldType(prim) : new FieldType(this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(vtype)));
            } else {
                List typeElements = XMLUtilities.getElementsByTagName((Element)varElement, (String)"data-type", (boolean)true);
                if (typeElements.size() > 0) {
                    type = FieldType.load((IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet(), (Element)((Element)typeElements.get(0)));
                }
            }
            int vvaluetype = varElement.getAttribute("value-type").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("value-type"));
            String vvalue = varElement.getAttribute("value");
            String secureAtt = varElement.getAttribute("secured");
            boolean secure = false;
            if (secureAtt != null && !secureAtt.equals("")) {
                secure = Boolean.parseBoolean(secureAtt);
            }
            VariableDeclaration vd = new VariableDeclaration(vname, type, vvaluetype, vvalue, secure);
            this.variableDeclarations.add(vd);
            ++v;
        }
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("default-brand", this.defaultBrandId);
        configuration.setAttribute("default-language", this.defaultLanguage);
        Element declarationsElement = configuration.getOwnerDocument().createElement("declarations");
        configuration.appendChild(declarationsElement);
        int i = 0;
        while (i < this.variableDeclarations.size()) {
            VariableDeclaration vd = this.variableDeclarations.get(i);
            Element declarationElement = declarationsElement.getOwnerDocument().createElement("variable");
            declarationsElement.appendChild(declarationElement);
            declarationElement.setAttribute("name", vd.name == null ? "" : vd.name);
            vd.type.write(declarationElement);
            declarationElement.setAttribute("value-type", Integer.toString(vd.valueType));
            declarationElement.setAttribute("value", vd.value == null ? "" : vd.value);
            declarationElement.setAttribute("secured", vd.isSecure() ? "true" : "false");
            ++i;
        }
    }

    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable platform = VariableHelper.constructVariable((String)"Platform", (IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet(), (FieldType)new FieldType(this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject("Platform")));
        variables.add(platform);
        HashMap<String, Variable> map = new HashMap<String, Variable>();
        int i = 0;
        while (i < variables.size()) {
            map.put(((Variable)variables.get(i)).getName(), (Variable)variables.get(i));
            ++i;
        }
        i = 0;
        while (i < this.variableDeclarations.size()) {
            Variable v;
            VariableDeclaration vd = this.variableDeclarations.get(i);
            if (map.get(vd.name) == null && (v = VariableHelper.constructVariable((String)vd.name, (IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet(), (FieldType)vd.getType())) != null) {
                v.setSecure(vd.isSecure());
                variables.add(v);
            }
            ++i;
        }
        return variables;
    }

    public void declareBusinessObjects() {
        boolean foundPlatform = false;
        IBusinessObjectSet businessObjectSet = this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet();
        List currentObjects = businessObjectSet.getBusinessObjects();
        block8: for (IBusinessObject businessObject : currentObjects) {
            if (!businessObject.getName().equals("Platform")) continue;
            for (IBusinessObjectField field : businessObject.getFields()) {
                if (!field.getName().equals("PLATFORM_ANI")) continue;
                foundPlatform = true;
                break block8;
            }
            try {
                businessObjectSet.deleteBusinessObject(businessObject);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            break;
        }
        if (!foundPlatform) {
            try {
                BusinessObject platform = (BusinessObject)businessObjectSet.createBusinessObject("Platform");
                try {
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    Element rootElement = doc.createElement("business-object");
                    doc.appendChild(rootElement);
                    rootElement.setAttribute("id", platform.getId());
                    rootElement.setAttribute("name", platform.getName());
                    Element fields = rootElement.getOwnerDocument().createElement("fields");
                    rootElement.appendChild(fields);
                    Element aniElement = fields.getOwnerDocument().createElement("field");
                    fields.appendChild(aniElement);
                    aniElement.setAttribute("name", "ANI");
                    aniElement.setAttribute("initialValue", "");
                    aniElement.setAttribute("secured", "false");
                    FieldType.STRING.write(aniElement);
                    Element ani2Element = fields.getOwnerDocument().createElement("field");
                    fields.appendChild(ani2Element);
                    ani2Element.setAttribute("name", "PLATFORM_ANI");
                    ani2Element.setAttribute("initialValue", "");
                    ani2Element.setAttribute("secured", "false");
                    FieldType.STRING.write(ani2Element);
                    Element dnisElement = fields.getOwnerDocument().createElement("field");
                    fields.appendChild(dnisElement);
                    dnisElement.setAttribute("name", "DNIS");
                    dnisElement.setAttribute("initialValue", "");
                    dnisElement.setAttribute("secured", "false");
                    FieldType.STRING.write(dnisElement);
                    Element dnis2Element = fields.getOwnerDocument().createElement("field");
                    fields.appendChild(dnis2Element);
                    dnis2Element.setAttribute("name", "PLATFORM_DNIS");
                    dnis2Element.setAttribute("initialValue", "");
                    dnis2Element.setAttribute("secured", "false");
                    FieldType.STRING.write(dnis2Element);
                    Element brandElement = fields.getOwnerDocument().createElement("field");
                    fields.appendChild(brandElement);
                    brandElement.setAttribute("name", "Brand");
                    brandElement.setAttribute("initialValue", "");
                    brandElement.setAttribute("secured", "false");
                    FieldType.STRING.write(brandElement);
                    DOMSource source = new DOMSource(doc);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Transformer trans = TransformerFactory.newInstance().newTransformer();
                    trans.setOutputProperty("encoding", "UTF-8");
                    trans.transform(source, new XMLWriter((OutputStream)baos).toXMLResult());
                    platform.write((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (FactoryConfigurationError e) {
                    e.printStackTrace();
                }
                catch (TransformerFactoryConfigurationError e) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean canDelete() {
        return true;
    }

    public boolean hasPathToStart(Map<String, IDesignElement> path) {
        return true;
    }

    public boolean hasConnectors() {
        return true;
    }

    public String getId() {
        return this.getElement().getId();
    }

    public List<Variable> getInputVariables() {
        return this.getOutgoingVariables(null, true);
    }

    public String getName() {
        return this.getElement().getName();
    }
}

