/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.properties.Branch;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BranchInformationProvider
extends PrimitiveInformationProvider {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    List<Branch> branches = new ArrayList<Branch>();

    public BranchInformationProvider(PrimitiveElement element) {
        super(element);
        this.buildInitialConnectorRecords();
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        for (ConnectorRecord cr : this.connectorRecords) {
            if (!cr.getName().equals(recordName)) continue;
            return cr;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        for (ConnectorRecord cr : this.connectorRecords) {
            if (!cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) continue;
            ret.add(cr);
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        NodeList nl = configuration.getElementsByTagName("branch");
        int b = 0;
        while (b < nl.getLength()) {
            Element branchElement = (Element)nl.item(b);
            String name = branchElement.getAttribute("name");
            String expression = branchElement.getAttribute("expression");
            boolean secured = Boolean.parseBoolean(branchElement.getAttribute("secure"));
            int number = Integer.parseInt(branchElement.getAttribute("number"));
            this.branches.add(new Branch(name, expression, secured, number));
            ++b;
        }
        this.orderBranchesByNumber();
        this.buildInitialConnectorRecords();
    }

    public void writeConfiguration(Element configuration) {
        this.numberBranchesByOrder();
        for (Branch branch : this.branches) {
            Element branchElement = configuration.getOwnerDocument().createElement("branch");
            branchElement.setAttribute("name", branch.getName());
            branchElement.setAttribute("expression", branch.getExpression());
            branchElement.setAttribute("secure", Boolean.toString(branch.isSecure()));
            branchElement.setAttribute("number", Integer.toString(branch.getNumber()));
            configuration.appendChild(branchElement);
        }
    }

    public boolean hasConnectors() {
        return true;
    }

    public List<Branch> getBranches() {
        ArrayList<Branch> branchesCopy = new ArrayList<Branch>();
        for (Branch br : this.branches) {
            branchesCopy.add(br.copy());
        }
        return branchesCopy;
    }

    public void setBranches(List<Branch> branches) {
        this.branches = this.updateConnectorRecords(branches);
    }

    private void buildInitialConnectorRecords() {
        this.connectorRecords.clear();
        this.connectorRecords.add(new ConnectorRecord((DesignElement)this.getElement(), "error.script", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)this.getElement(), "Default", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        for (Branch br : this.branches) {
            ConnectorRecord cr = new ConnectorRecord((DesignElement)this.getElement(), br.getName(), IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT);
            this.connectorRecords.add(cr);
            br.setConnector(cr);
        }
    }

    private void numberBranchesByOrder() {
        int b = 0;
        while (b < this.branches.size()) {
            this.branches.get(b).setNumber(b);
            ++b;
        }
    }

    private void orderBranchesByNumber() {
        TreeMap<Integer, Branch> branchMap = new TreeMap<Integer, Branch>();
        for (Branch br : this.branches) {
            branchMap.put(br.getNumber(), br);
        }
        Iterator i = branchMap.keySet().iterator();
        while (i.hasNext()) {
            int b = (Integer)i.next();
            this.branches.set(b, (Branch)branchMap.get(b));
        }
    }

    private List<Branch> updateConnectorRecords(List<Branch> updatedBranches) {
        HashMap<String, Branch> updatedBranchMap = new HashMap<String, Branch>();
        HashMap<String, Branch> branchMap = new HashMap<String, Branch>();
        for (Branch br : this.branches) {
            branchMap.put(br.getGuid(), br);
        }
        for (Branch ubr : updatedBranches) {
            updatedBranchMap.put(ubr.getGuid(), ubr);
        }
        for (Branch br : this.branches) {
            if (updatedBranchMap.containsKey(br.getGuid())) continue;
            this.connectorRecords.remove(br.getConnector());
        }
        for (Branch ubr : updatedBranches) {
            if (!branchMap.containsKey(ubr.getGuid())) {
                ConnectorRecord cr = new ConnectorRecord((DesignElement)this.getElement(), ubr.getName(), IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT);
                this.connectorRecords.add(cr);
                ubr.setConnector(cr);
                continue;
            }
            if (((Branch)branchMap.get(ubr.getGuid())).getName().equals(ubr.getName())) continue;
            ubr.getConnector().setName(ubr.getName());
        }
        return updatedBranches;
    }
}

