/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.IExitBroadcastReceiver;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.VariableHelper;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.core.internal.design.ExitBroadcastReceiver;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveBroadcastReceiverProvider;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BroadcastReceiverInformationProvider
extends PrimitiveInformationProvider
implements PrimitiveBroadcastReceiverProvider {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    private List<IExitBroadcastReceiver> receivers = new ArrayList<IExitBroadcastReceiver>();

    public BroadcastReceiverInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
    }

    public void setExitBroadcastReceivers(List<IExitBroadcastReceiver> receivers) {
        this.receivers = receivers;
        this.getElement().markDirty();
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return false;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        NodeList recGroupList = configuration.getElementsByTagName("receivers");
        if (recGroupList.getLength() != 1) {
            return;
        }
        Element recGroupElement = (Element)recGroupList.item(0);
        NodeList recList = recGroupElement.getElementsByTagName("receiver");
        int v = 0;
        while (v < recList.getLength()) {
            Element recElement = (Element)recList.item(v);
            String pattern = recElement.getAttribute("pattern");
            ExitBroadcastReceiver ebr = new ExitBroadcastReceiver(pattern);
            this.receivers.add((IExitBroadcastReceiver)ebr);
            ++v;
        }
    }

    public void writeConfiguration(Element configuration) {
        Element receiversElement = configuration.getOwnerDocument().createElement("receivers");
        configuration.appendChild(receiversElement);
        int i = 0;
        while (i < this.receivers.size()) {
            IExitBroadcastReceiver receiver = this.receivers.get(i);
            Element receiverElement = receiversElement.getOwnerDocument().createElement("receiver");
            receiversElement.appendChild(receiverElement);
            receiverElement.setAttribute("pattern", receiver.getExitPattern() == null ? "" : receiver.getExitPattern());
            ++i;
        }
    }

    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable platform = VariableHelper.constructVariable((String)"receivedExit", (IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet(), (FieldType)FieldType.STRING);
        variables.add(platform);
        return variables;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean hasPathToStart(Map<String, IDesignElement> path) {
        return true;
    }

    public boolean hasConnectors() {
        return true;
    }

    public String getId() {
        return this.getElement().getId();
    }

    public String getName() {
        return this.getElement().getName();
    }

    public List<IExitBroadcastReceiver> getExitBroadcastReceivers() {
        return this.receivers;
    }
}

