/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ComparisonInformationProvider
extends PrimitiveInformationProvider {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    private int lType = 0;
    private String lValue = "";
    private int compType = 0;
    private int rType = 0;
    private String rValue = "";
    private boolean lsecured = false;
    private boolean rsecured = false;

    public ComparisonInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "True", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "False", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "error.script", IDesignElementConnectionPoint.ConnectionPointType.ERROR_POINT));
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        NodeList nl = configuration.getElementsByTagName("comparison");
        Element comparisonElement = null;
        comparisonElement = nl.getLength() == 0 ? configuration.getOwnerDocument().createElement("comparison") : (Element)nl.item(0);
        String compTypeStr = comparisonElement.getAttribute("type");
        if ("equal".equalsIgnoreCase(compTypeStr)) {
            this.compType = 0;
        }
        if ("less-than".equalsIgnoreCase(compTypeStr)) {
            this.compType = 1;
        }
        if ("less-than-or-equal".equalsIgnoreCase(compTypeStr)) {
            this.compType = 2;
        }
        if ("greater-than".equalsIgnoreCase(compTypeStr)) {
            this.compType = 3;
        }
        if ("greater-than-or-equal".equalsIgnoreCase(compTypeStr)) {
            this.compType = 4;
        }
        if ("not-equal".equalsIgnoreCase(compTypeStr)) {
            this.compType = 5;
        }
        if ("expression".equalsIgnoreCase(comparisonElement.getAttribute("left-type"))) {
            this.lType = 1;
            this.lsecured = Boolean.parseBoolean(comparisonElement.getAttribute("left-secured"));
        } else {
            this.lType = 0;
        }
        this.lValue = comparisonElement.getAttribute("left-value");
        if ("expression".equalsIgnoreCase(comparisonElement.getAttribute("right-type"))) {
            this.rType = 1;
            this.rsecured = Boolean.parseBoolean(comparisonElement.getAttribute("right-secured"));
        } else {
            this.rType = 0;
        }
        this.rValue = comparisonElement.getAttribute("right-value");
    }

    public void writeConfiguration(Element configuration) {
        Element comparisonElement = configuration.getOwnerDocument().createElement("comparison");
        String compTypeStr = null;
        switch (this.compType) {
            case 0: {
                compTypeStr = "equal";
                break;
            }
            case 1: {
                compTypeStr = "less-than";
                break;
            }
            case 2: {
                compTypeStr = "less-than-or-equal";
                break;
            }
            case 3: {
                compTypeStr = "greater-than";
                break;
            }
            case 4: {
                compTypeStr = "greater-than-or-equal";
                break;
            }
            case 5: {
                compTypeStr = "not-equal";
            }
        }
        comparisonElement.setAttribute("type", compTypeStr);
        comparisonElement.setAttribute("left-type", this.lType == 0 ? "variable" : "expression");
        comparisonElement.setAttribute("left-secured", Boolean.toString(this.lsecured));
        comparisonElement.setAttribute("left-value", this.lValue);
        comparisonElement.setAttribute("right-type", this.rType == 0 ? "variable" : "expression");
        comparisonElement.setAttribute("right-secured", Boolean.toString(this.rsecured));
        comparisonElement.setAttribute("right-value", this.rValue);
        configuration.appendChild(comparisonElement);
    }

    public int getCompType() {
        return this.compType;
    }

    public void setCompType(int compType) {
        this.compType = compType;
    }

    public int getLType() {
        return this.lType;
    }

    public void setLType(int type) {
        this.lType = type;
    }

    public String getLValue() {
        return this.lValue;
    }

    public void setLValue(String value) {
        this.lValue = value;
    }

    public int getRType() {
        return this.rType;
    }

    public void setRType(int type) {
        this.rType = type;
    }

    public String getRValue() {
        return this.rValue;
    }

    public void setRValue(String value) {
        this.rValue = value;
    }

    public boolean isLeftSecured() {
        return this.lsecured;
    }

    public void setLeftSecured(boolean secured) {
        this.lsecured = secured;
    }

    public boolean isRightSecured() {
        return this.rsecured;
    }

    public void setRightSecured(boolean secured) {
        this.rsecured = secured;
    }

    public boolean hasConnectors() {
        return true;
    }
}

