/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignEntryPoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignExitPoint;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.w3c.dom.Element;

public class PortalEntryInformationProvider
extends PrimitiveInformationProvider
implements PropertyChangeListener,
IDesignExitPoint {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    String exitId = "";
    String exitName = "";
    IDesignElement exitElement = null;

    public PortalEntryInformationProvider(PrimitiveElement element) {
        super(element);
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        this.exitId = configuration.getAttribute("exit-id");
        this.exitName = configuration.getAttribute("exit-name");
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("exit-id", this.exitId);
        configuration.setAttribute("exit-name", this.exitName);
    }

    public String getExitId() {
        return this.exitId;
    }

    public void setExitId(String text) {
        this.exitId = text;
        this.resolve();
    }

    public void resolve() {
        if (this.exitElement != null) {
            this.exitElement.removePropertyListener((PropertyChangeListener)this);
        }
        this.exitElement = null;
        List elements = this.getElement().getDesign().getDesignElements();
        for (IDesignElement element : elements) {
            if (!element.getId().equals(this.exitId)) continue;
            this.exitElement = element;
        }
        if (this.exitElement == null) {
            for (IDesignElement element : elements) {
                if (element.getAdapter(IDesignEntryPoint.class) == null || !element.getName().equals(this.exitName)) continue;
                this.exitElement = element;
                this.exitId = element.getId();
            }
        }
        if (this.exitElement != null) {
            this.exitElement.addPropertyListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model.element.name")) {
            this.getElement().setName((String)evt.getNewValue());
            this.exitName = (String)evt.getNewValue();
        }
        if (evt.getPropertyName().equals("model.element.id")) {
            this.exitId = this.exitElement.getId();
        }
    }

    public boolean hasConnectors() {
        return false;
    }

    public String getId() {
        return this.getElement().getId();
    }

    public String getTargetId() {
        return this.exitId;
    }

    public String getTargetName() {
        return this.exitName;
    }

    public List<Variable> getExportedDesignVariables() {
        return this.getElement().getDesign().getVariablesFor((IDesignElement)this.getElement(), true);
    }
}

