/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignFolder;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IDesignRootFolder;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignEntryPoint;
import org.eclipse.vtp.desktop.model.core.design.IDesignExitPoint;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.w3c.dom.Element;

public class PortalExitInformationProvider
extends PrimitiveInformationProvider
implements PropertyChangeListener,
IDesignEntryPoint {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    PrimitiveElement exitElement = null;

    public PortalExitInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.exitElement = this.getElement();
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return false;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
    }

    public void writeConfiguration(Element configuration) {
    }

    public void resolve() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model.element.name")) {
            this.getElement().setName((String)evt.getNewValue());
        }
    }

    public boolean hasConnectors() {
        return true;
    }

    public String getId() {
        return this.getElement().getId();
    }

    public String getName() {
        return this.getElement().getName();
    }

    public List<IDesignExitPoint> getConnectingPoints() {
        LinkedList<IDesignExitPoint> exitPoints = new LinkedList<IDesignExitPoint>();
        List designExitPoints = this.getElement().getDesign().getDocument().getDesignExitPoints();
        for (IDesignExitPoint exitPoint : designExitPoints) {
            if (!exitPoint.getTargetId().equals(this.getElement().getId())) continue;
            exitPoints.add(exitPoint);
        }
        IDesignItemContainer container = this.getElement().getDesign().getDocument().getParentDesignContainer();
        while (!(container instanceof IDesignRootFolder)) {
            container = (IDesignItemContainer)container.getParent();
        }
        this.traverseDesigns(container, exitPoints);
        return exitPoints;
    }

    private void traverseDesigns(IDesignItemContainer container, List<IDesignExitPoint> exitPoints) {
        List documents = container.getDesignDocuments();
        for (IDesignDocument document : documents) {
            if (document.equals(this.getElement().getDesign().getDocument())) continue;
            List designExitPoints = document.getDesignExitPoints();
            for (IDesignExitPoint exitPoint : designExitPoints) {
                if (!exitPoint.getTargetId().equals(this.getElement().getId())) continue;
                exitPoints.add(exitPoint);
            }
        }
        List folders = container.getDesignFolders();
        for (IDesignFolder folder : folders) {
            this.traverseDesigns((IDesignItemContainer)folder, exitPoints);
        }
    }
}

