/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.IWorkflowExit;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReturnInformationProvider
extends PrimitiveInformationProvider
implements IWorkflowExit {
    public static final String PROP_EXIT_TYPE = "PROP_EXIT_TYPE";
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    String exitType = "NORMAL";
    List<String> exportedVars = new ArrayList<String>();

    public ReturnInformationProvider(PrimitiveElement element) {
        super(element);
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        this.exitType = configuration.getAttribute("exit-type").toUpperCase();
        if (!this.exitType.equals("NORMAL") && !this.exitType.equals("ERROR")) {
            this.exitType = "NORMAL";
        }
        NodeList exportList = configuration.getElementsByTagName("export");
        int i = 0;
        while (i < exportList.getLength()) {
            this.exportedVars.add(((Element)exportList.item(i)).getAttribute("name"));
            ++i;
        }
    }

    public void writeConfiguration(Element configuration) {
        configuration.setAttribute("exit-type", this.exitType);
        int i = 0;
        while (i < this.exportedVars.size()) {
            String name = this.exportedVars.get(i);
            Element el = configuration.getOwnerDocument().createElement("export");
            configuration.appendChild(el);
            el.setAttribute("name", name);
            ++i;
        }
    }

    public List<String> getExports() {
        return this.exportedVars;
    }

    public void setExports(List<String> exports) {
        this.exportedVars = exports;
    }

    public String getExitType() {
        return this.exitType;
    }

    public void setExitType(String text) {
        String oldType = this.exitType;
        this.exitType = text;
        this.getElement().firePropertyChange(PROP_EXIT_TYPE, (Object)oldType, (Object)text);
    }

    public boolean hasConnectors() {
        return false;
    }

    public String getId() {
        return this.getElement().getId();
    }

    public String getName() {
        return this.getElement().getName();
    }

    public String getType() {
        return this.exitType;
    }

    public List<Variable> getExportedVariables() {
        LinkedList<Variable> ret = new LinkedList<Variable>();
        List variables = this.getElement().getDesign().getVariablesFor((IDesignElement)this.getElement());
        for (Variable v : variables) {
            if (!this.exportedVars.contains(v.getName())) continue;
            ret.add(v);
        }
        return ret;
    }
}

