/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.VariableHelper;
import org.eclipse.vtp.desktop.model.core.internal.design.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.modules.standard.ui.VariableDeclaration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VariableAssignmentInformationProvider
extends PrimitiveInformationProvider {
    List<ConnectorRecord> connectorRecords = new ArrayList<ConnectorRecord>();
    String scriptText = "";
    private List<VariableDeclaration> variableDeclarations;

    public VariableAssignmentInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((DesignElement)element, "Continue", IDesignElementConnectionPoint.ConnectionPointType.EXIT_POINT));
        this.variableDeclarations = new ArrayList<VariableDeclaration>();
    }

    public List<VariableDeclaration> getDeclarations() {
        ArrayList<VariableDeclaration> copy = new ArrayList<VariableDeclaration>();
        copy.addAll(this.variableDeclarations);
        return copy;
    }

    public void setDeclarations(List<VariableDeclaration> declarations) {
        this.variableDeclarations = declarations;
    }

    public boolean acceptsConnector(IDesignElement origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List<ConnectorRecord> getConnectorRecords() {
        return this.connectorRecords;
    }

    public List<ConnectorRecord> getConnectorRecords(IDesignElementConnectionPoint.ConnectionPointType ... types) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = this.connectorRecords.get(i);
            if (cr.getType().isSet(IDesignElementConnectionPoint.ConnectionPointType.getFlagSet((IDesignElementConnectionPoint.ConnectionPointType[])types))) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        NodeList decGroupList = configuration.getElementsByTagName("declarations");
        if (decGroupList.getLength() != 1) {
            return;
        }
        Element decGroupElement = (Element)decGroupList.item(0);
        NodeList varList = decGroupElement.getElementsByTagName("variable");
        int v = 0;
        while (v < varList.getLength()) {
            Element varElement = (Element)varList.item(v);
            String vname = varElement.getAttribute("name");
            FieldType type = null;
            if (varElement.getAttributeNode("type") != null) {
                FieldType.Primitive prim;
                int vmulti;
                String vtype = varElement.getAttribute("type");
                int n = vmulti = varElement.getAttribute("multiplicity").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("multiplicity"));
                type = vmulti == 1 ? ((prim = FieldType.Primitive.find((String)vtype)) != null ? new FieldType(FieldType.Primitive.ARRAY, prim) : new FieldType(FieldType.Primitive.ARRAY, this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(vtype))) : ((prim = FieldType.Primitive.find((String)vtype)) != null ? new FieldType(prim) : new FieldType(this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet().getBusinessObject(vtype)));
            } else {
                List typeElements = XMLUtilities.getElementsByTagName((Element)varElement, (String)"data-type", (boolean)true);
                if (typeElements.size() > 0) {
                    type = FieldType.load((IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet(), (Element)((Element)typeElements.get(0)));
                }
            }
            int vvaluetype = varElement.getAttribute("value-type").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("value-type"));
            String vvalue = varElement.getAttribute("value");
            String secureAtt = varElement.getAttribute("secured");
            boolean secure = false;
            if (secureAtt != null && !secureAtt.equals("")) {
                secure = Boolean.parseBoolean(secureAtt);
            }
            VariableDeclaration vd = new VariableDeclaration(vname, type, vvaluetype, vvalue, secure);
            this.variableDeclarations.add(vd);
            ++v;
        }
    }

    public void writeConfiguration(Element configuration) {
        Element declarationsElement = configuration.getOwnerDocument().createElement("declarations");
        configuration.appendChild(declarationsElement);
        int i = 0;
        while (i < this.variableDeclarations.size()) {
            VariableDeclaration vd = this.variableDeclarations.get(i);
            Element declarationElement = declarationsElement.getOwnerDocument().createElement("variable");
            declarationsElement.appendChild(declarationElement);
            declarationElement.setAttribute("name", vd.name == null ? "" : vd.name);
            vd.type.write(declarationElement);
            declarationElement.setAttribute("value-type", Integer.toString(vd.valueType));
            declarationElement.setAttribute("value", vd.value == null ? "" : vd.value);
            declarationElement.setAttribute("secured", vd.isSecure() ? "true" : "false");
            ++i;
        }
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String text) {
        this.scriptText = text;
    }

    public List<Variable> getOutgoingVariables(String exitPoint, boolean localOnly) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        int i = 0;
        while (i < this.variableDeclarations.size()) {
            VariableDeclaration vd = this.variableDeclarations.get(i);
            Variable v = VariableHelper.constructVariable((String)vd.name, (IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet(), (FieldType)vd.getType());
            if (v != null) {
                v.setSecure(vd.isSecure());
                variables.add(v);
            }
            ++i;
        }
        return variables;
    }

    public boolean hasConnectors() {
        return true;
    }
}

