/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.export;

import java.util.TreeMap;
import org.eclipse.vtp.desktop.export.IConfigurationExporter;
import org.eclipse.vtp.desktop.export.IFlowElement;
import org.eclipse.vtp.framework.common.configurations.BranchConfiguration;
import org.eclipse.vtp.modules.standard.ui.properties.Branch;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BranchConfigurationExporter
implements IConfigurationExporter {
    public void exportConfiguration(IFlowElement flowElement, Element actionElement) {
        TreeMap<Integer, Branch> branchMap = this.extractBranchesToTreeMap(flowElement);
        for (int b : branchMap.keySet()) {
            Branch branch = branchMap.get(b);
            BranchConfiguration config = new BranchConfiguration();
            config.setType(0);
            config.setPath(branch.getName());
            config.setLeftExpressionValue(branch.getExpression(), "JavaScript");
            config.setLeftSecured(branch.isSecure());
            config.setRightExpressionValue("true", "JavaScript");
            config.setRightSecured(branch.isSecure());
            Element configElement = actionElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", "common:branch");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    public String getActionId(IFlowElement flowElement) {
        return "org.eclipse.vtp.framework.common.actions.branch";
    }

    public String getDefaultPath(IFlowElement flowElement) {
        return "Default";
    }

    public String translatePath(IFlowElement flowElement, String uiPath) {
        return uiPath;
    }

    public String getTargetId(IFlowElement flowElement, Element afterTransitionElement) {
        return flowElement.getDefaultTargetId(afterTransitionElement);
    }

    public boolean isEntryPoint(IFlowElement flowElement) {
        return false;
    }

    private TreeMap<Integer, Branch> extractBranchesToTreeMap(IFlowElement flowElement) {
        TreeMap<Integer, Branch> branchMap = new TreeMap<Integer, Branch>();
        String uri = "http://www.eclipse.org/vtp/namespaces/config";
        NodeList branchNodeList = ((Element)flowElement.getConfiguration().getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "branch");
        int b = 0;
        while (b < branchNodeList.getLength()) {
            Element branchElement = (Element)branchNodeList.item(b);
            String name = branchElement.getAttribute("name");
            String expression = branchElement.getAttribute("expression");
            boolean secured = Boolean.parseBoolean(branchElement.getAttribute("secure"));
            int number = Integer.parseInt(branchElement.getAttribute("number"));
            branchMap.put(number, new Branch(name, expression, secured, number));
            ++b;
        }
        return branchMap;
    }
}

