/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.export;

import org.eclipse.vtp.desktop.export.IConfigurationExporter;
import org.eclipse.vtp.desktop.export.IFlowElement;
import org.eclipse.vtp.framework.common.configurations.BranchConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DecisionConfigurationExporter
implements IConfigurationExporter {
    public void exportConfiguration(IFlowElement flowElement, Element actionElement) {
        String uri = "http://www.eclipse.org/vtp/namespaces/config";
        NodeList comparisonList = ((Element)flowElement.getConfiguration().getElementsByTagNameNS(uri, "custom-config").item(0)).getElementsByTagNameNS(uri, "comparison");
        if (comparisonList.getLength() > 0) {
            Element comparison = (Element)comparisonList.item(0);
            BranchConfiguration config = new BranchConfiguration();
            String typeStr = comparison.getAttribute("type");
            if ("equal".equals(typeStr)) {
                config.setType(0);
            } else if ("less-than".equals(typeStr)) {
                config.setType(1);
            } else if ("less-than-or-equal".equals(typeStr)) {
                config.setType(2);
            } else if ("greater-than".equals(typeStr)) {
                config.setType(3);
            } else if ("greater-than-or-equal".equals(typeStr)) {
                config.setType(4);
            } else if ("not-equal".equals(typeStr)) {
                config.setType(5);
            }
            config.setPath("True");
            if ("expression".equalsIgnoreCase(comparison.getAttribute("left-type"))) {
                config.setLeftExpressionValue(comparison.getAttribute("left-value"), "JavaScript");
                config.setLeftSecured(Boolean.parseBoolean(comparison.getAttribute("left-secured")));
            } else {
                config.setLeftVariableValue(comparison.getAttribute("left-value"));
            }
            if ("expression".equalsIgnoreCase(comparison.getAttribute("right-type"))) {
                config.setRightExpressionValue(comparison.getAttribute("right-value"), "JavaScript");
                config.setRightSecured(Boolean.parseBoolean(comparison.getAttribute("right-secured")));
            } else {
                config.setRightVariableValue(comparison.getAttribute("right-value"));
            }
            Element configElement = actionElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", "common:branch");
            config.save(configElement);
            actionElement.appendChild(configElement);
        }
    }

    public String getActionId(IFlowElement flowElement) {
        return "org.eclipse.vtp.framework.common.actions.branch";
    }

    public String getDefaultPath(IFlowElement flowElement) {
        return "False";
    }

    public String translatePath(IFlowElement flowElement, String uiPath) {
        return uiPath;
    }

    public String getTargetId(IFlowElement flowElement, Element afterTransitionElement) {
        return flowElement.getDefaultTargetId(afterTransitionElement);
    }

    public boolean isEntryPoint(IFlowElement flowElement) {
        return false;
    }
}

