/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.core.internal.VariableHelper;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.VariableAssignmentInformationProvider;
import org.eclipse.vtp.modules.standard.ui.VariableDeclaration;
import org.eclipse.vtp.modules.standard.ui.properties.NewVariableDialog;

public class AssignmentVariablesPropertyPanel
extends DesignElementPropertiesPanel {
    List<VariableDeclaration> declarations;
    List<Variable> variables;
    TableViewer variableViewer;
    Button addButton;
    Button removeButton;
    TextCellEditor valueEditor;
    FormToolkit toolkit = null;
    Text nameField = null;
    CheckboxCellEditor secureEditor;
    Button filterButton = null;

    public AssignmentVariablesPropertyPanel(String name, IDesignElement element) {
        super(name, element);
        this.declarations = ((VariableAssignmentInformationProvider)((PrimitiveElement)element).getInformationProvider()).getDeclarations();
        this.populateVariables();
    }

    public void populateVariables() {
        this.variables = new ArrayList<Variable>();
        List incomingVariables = this.getElement().getDesign().getVariablesFor(this.getElement());
        HashMap<String, Variable> lookup = new HashMap<String, Variable>();
        for (Variable v : incomingVariables) {
            lookup.put(v.getName(), v);
        }
        for (VariableDeclaration vd : this.declarations) {
            Variable v = VariableHelper.constructVariable((String)vd.getName(), (IBusinessObjectSet)this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet(), (FieldType)vd.getType());
            if (v == null) continue;
            v.setSecure(vd.isSecure());
            lookup.put(v.getName(), v);
        }
        for (Variable v : lookup.values()) {
            this.variables.add(v);
        }
    }

    public void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.toolkit = new FormToolkit(parent.getDisplay());
        Section generalSection = this.toolkit.createSection(parent, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        generalSection.setLayoutData((Object)gridData);
        generalSection.setText("General");
        Composite generalComp = new Composite((Composite)generalSection, 0);
        generalComp.setBackground(parent.getBackground());
        generalComp.setLayout((Layout)new GridLayout(2, false));
        generalSection.setClient((Control)generalComp);
        Label nameLabel = new Label(generalComp, 0);
        nameLabel.setText("Name: ");
        nameLabel.setBackground(generalComp.getBackground());
        nameLabel.setLayoutData((Object)new GridData(4));
        this.nameField = new Text(generalComp, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(772));
        Section contentSection = this.toolkit.createSection(parent, 256);
        gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gridData);
        contentSection.setText("Variable Assignments");
        this.filterButton = new Button(parent, 32);
        this.filterButton.setText("Show only new or modified variables");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.filterButton.setLayoutData((Object)gd);
        this.filterButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AssignmentVariablesPropertyPanel.this.variableViewer.refresh();
            }
        });
        Table variableTable = new Table(parent, 67588);
        variableTable.setHeaderVisible(true);
        TableColumn newColumn = new TableColumn(variableTable, 0);
        newColumn.setText("*");
        newColumn.setWidth(15);
        TableColumn secureColumn = new TableColumn(variableTable, 0);
        secureColumn.setImage(Activator.getDefault().getImageRegistry().get("ICON_LOCK"));
        secureColumn.setAlignment(0x1000000);
        secureColumn.setWidth(23);
        TableColumn nameColumn = new TableColumn(variableTable, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(150);
        TableColumn typeColumn = new TableColumn(variableTable, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(150);
        TableColumn valueColumn = new TableColumn(variableTable, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(200);
        gd = new GridData(1808);
        gd.verticalSpan = 2;
        gd.widthHint = 520;
        gd.heightHint = 200;
        variableTable.setLayoutData((Object)gd);
        this.valueEditor = new TextCellEditor((Composite)variableTable);
        this.secureEditor = new CheckboxCellEditor((Composite)variableTable);
        this.variableViewer = new TableViewer(variableTable);
        this.variableViewer.setColumnProperties(new String[]{"New", "Secure", "Name", "Type", "Value"});
        CellEditor[] cellEditorArray = new CellEditor[5];
        cellEditorArray[1] = this.secureEditor;
        cellEditorArray[4] = this.valueEditor;
        this.variableViewer.setCellEditors(cellEditorArray);
        this.variableViewer.setCellModifier((ICellModifier)new ValueCellModifier());
        this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.variableViewer.setInput((Object)this);
        this.variableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Variable v1 = (Variable)e1;
                Variable v2 = (Variable)e2;
                return v1.getName().compareTo(v2.getName());
            }
        });
        this.variableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AssignmentVariablesPropertyPanel.this.variableViewer.getSelection().isEmpty()) {
                    AssignmentVariablesPropertyPanel.this.removeButton.setEnabled(false);
                    return;
                }
                HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
                int i = 0;
                while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                    VariableDeclaration vd = AssignmentVariablesPropertyPanel.this.declarations.get(i);
                    vdm.put(vd.getName(), vd);
                    ++i;
                }
                Variable v = (Variable)((IStructuredSelection)AssignmentVariablesPropertyPanel.this.variableViewer.getSelection()).getFirstElement();
                AssignmentVariablesPropertyPanel.this.removeButton.setEnabled(vdm.get(v.getName()) != null);
            }
        });
        this.variableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    AssignmentVariablesPropertyPanel.this.removeVariable();
                }
            }
        });
        this.addButton = new Button(parent, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData(2));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ArrayList<String> reservedNames = new ArrayList<String>();
                    for (VariableDeclaration vd : AssignmentVariablesPropertyPanel.this.declarations) {
                        reservedNames.add(vd.getName());
                    }
                    NewVariableDialog nvd = new NewVariableDialog(AssignmentVariablesPropertyPanel.this.addButton.getShell(), reservedNames, AssignmentVariablesPropertyPanel.this.getElement().getDesign().getDocument().getProject().getBusinessObjectSet());
                    if (nvd.open() == 32) {
                        AssignmentVariablesPropertyPanel.this.declarations.add(new VariableDeclaration(nvd.name, nvd.type, 0, null, nvd.secure));
                        AssignmentVariablesPropertyPanel.this.populateVariables();
                    }
                    AssignmentVariablesPropertyPanel.this.variableViewer.refresh();
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText("Clear");
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(2));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AssignmentVariablesPropertyPanel.this.removeVariable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void removeVariable() {
        Variable v = (Variable)((IStructuredSelection)this.variableViewer.getSelection()).getFirstElement();
        VariableDeclaration vd = null;
        int i = 0;
        while (i < this.declarations.size()) {
            vd = this.declarations.get(i);
            if (vd.getName().equals(v.getName())) break;
            vd = null;
            ++i;
        }
        if (vd != null) {
            this.declarations.remove(vd);
            this.populateVariables();
        }
        this.variableViewer.refresh();
    }

    public void save() {
        this.getElement().setName(this.nameField.getText());
        ((VariableAssignmentInformationProvider)((PrimitiveElement)this.getElement()).getInformationProvider()).setDeclarations(this.declarations);
    }

    public void cancel() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    public class ValueCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            Variable v = (Variable)element;
            if (property.equals("Value")) {
                if (v.getType().hasValue()) {
                    return true;
                }
            } else if (property.equals("Secure")) {
                HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
                int i = 0;
                while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                    VariableDeclaration vd = AssignmentVariablesPropertyPanel.this.declarations.get(i);
                    vdm.put(vd.getName(), vd);
                    ++i;
                }
                return vdm.get(v.getName()) != null;
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
            int i = 0;
            while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                VariableDeclaration vd = AssignmentVariablesPropertyPanel.this.declarations.get(i);
                vdm.put(vd.getName(), vd);
                ++i;
            }
            Variable vd = (Variable)element;
            if (property.equals("Value")) {
                return vdm.get(vd.getName()) == null ? "" : (((VariableDeclaration)vdm.get(vd.getName())).getValue() == null ? "" : ((VariableDeclaration)vdm.get(vd.getName())).getValue());
            }
            if (property.equals("Secure")) {
                return new Boolean(vd.isSecure());
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            Object vd;
            HashMap<String, Object> vdm = new HashMap<String, Object>();
            int i = 0;
            while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                vd = AssignmentVariablesPropertyPanel.this.declarations.get(i);
                vdm.put(((VariableDeclaration)vd).getName(), vd);
                ++i;
            }
            TableItem ti = (TableItem)element;
            vd = (Variable)ti.getData();
            VariableDeclaration varDec = (VariableDeclaration)vdm.get(vd.getName());
            if (varDec == null) {
                varDec = new VariableDeclaration(vd.getName(), vd.getType(), 0, null);
                AssignmentVariablesPropertyPanel.this.declarations.add(varDec);
            }
            if (property.equals("Value")) {
                varDec.setValueType(0);
                varDec.setValue((String)value);
                AssignmentVariablesPropertyPanel.this.variableViewer.refresh(true);
            } else if (property.equals("Secure")) {
                vd.setSecure(((Boolean)value).booleanValue());
                AssignmentVariablesPropertyPanel.this.variableViewer.refresh(true);
            }
        }
    }

    public class VariableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (AssignmentVariablesPropertyPanel.this.filterButton.getSelection()) {
                HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
                int i = 0;
                while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                    VariableDeclaration variableDeclaration = AssignmentVariablesPropertyPanel.this.declarations.get(i);
                    vdm.put(variableDeclaration.getName(), variableDeclaration);
                    ++i;
                }
                ArrayList<Variable> filteredList = new ArrayList<Variable>();
                for (Variable variable : AssignmentVariablesPropertyPanel.this.variables) {
                    if (vdm.get(variable.getName()) == null) continue;
                    filteredList.add(variable);
                }
                return filteredList.toArray();
            }
            return AssignmentVariablesPropertyPanel.this.variables.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            Variable v = (Variable)element;
            if (columnIndex == 1 && v.isSecure()) {
                return Activator.getDefault().getImageRegistry().get("ICON_LOCK");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
            int i = 0;
            while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                VariableDeclaration vd = AssignmentVariablesPropertyPanel.this.declarations.get(i);
                vdm.put(vd.getName(), vd);
                ++i;
            }
            Variable vd = (Variable)element;
            if (columnIndex == 0) {
                if (vdm.get(vd.getName()) != null) {
                    return "*";
                }
                return "";
            }
            if (columnIndex == 1) {
                return "";
            }
            if (columnIndex == 2) {
                return vd.getName();
            }
            if (columnIndex == 3) {
                String ret = vd.getType().getName();
                if (vd.getType().hasBaseType()) {
                    ret = String.valueOf(ret) + " Of ";
                    ret = String.valueOf(ret) + vd.getType().getBaseTypeName();
                }
                return ret;
            }
            if (columnIndex == 4 && vd.getType().hasValue() && vdm.get(vd.getName()) != null) {
                return ((VariableDeclaration)vdm.get(vd.getName())).getValue();
            }
            return "N/A";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

