/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IExitBroadcastReceiver;
import org.eclipse.vtp.desktop.model.core.internal.design.ExitBroadcastReceiver;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.BroadcastReceiverInformationProvider;
import org.eclipse.vtp.modules.standard.ui.properties.ReceiverNameDialog;

public class BroadcastReceiverPropertiesPanel
extends DesignElementPropertiesPanel {
    BroadcastReceiverInformationProvider info;
    List<IExitBroadcastReceiver> receivers;
    TableViewer table;

    public BroadcastReceiverPropertiesPanel(String name, IDesignElement element) {
        super(name, element);
        this.info = (BroadcastReceiverInformationProvider)((PrimitiveElement)element).getInformationProvider();
        this.receivers = new ArrayList<IExitBroadcastReceiver>(this.info.getExitBroadcastReceivers());
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(comp.getDisplay().getSystemColor(1));
        comp.setBackgroundMode(1);
        comp.setLayout((Layout)new GridLayout(2, false));
        Composite tableComp = new Composite(comp, 0);
        tableComp.setBackgroundMode(1);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        GridData gd = new GridData(768);
        gd.heightHint = 250;
        gd.widthHint = 300;
        tableComp.setLayoutData((Object)gd);
        Table t = new Table(tableComp, 2052);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        TableColumn patternColumn = new TableColumn(t, 16384);
        patternColumn.setText("Events to Receive");
        tableLayout.setColumnData((Widget)patternColumn, (ColumnLayoutData)new ColumnWeightData(100, 100, false));
        this.table = new TableViewer(t);
        this.table.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return BroadcastReceiverPropertiesPanel.this.receivers.toArray();
            }
        });
        this.table.setLabelProvider((IBaseLabelProvider)new ReceiverLabelProvider());
        this.table.setInput((Object)this);
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setBackgroundMode(1);
        buttonComp.setLayout((Layout)new GridLayout(1, true));
        buttonComp.setLayoutData((Object)new GridData());
        Button addButton = new Button(buttonComp, 8);
        addButton.setText("Add Receiver");
        addButton.setLayoutData((Object)new GridData(768));
        final Button editButton = new Button(buttonComp, 8);
        editButton.setText("Edit Receiver");
        editButton.setEnabled(false);
        editButton.setLayoutData((Object)new GridData(768));
        final Button removeButton = new Button(buttonComp, 8);
        removeButton.setText("Remove Receiver");
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(768));
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                editButton.setEnabled(!event.getSelection().isEmpty());
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReceiverNameDialog rnd = new ReceiverNameDialog(BroadcastReceiverPropertiesPanel.this.getContainer().getShell());
                if (rnd.open() == 0) {
                    BroadcastReceiverPropertiesPanel.this.receivers.add((IExitBroadcastReceiver)new ExitBroadcastReceiver(rnd.getName()));
                    BroadcastReceiverPropertiesPanel.this.table.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IExitBroadcastReceiver receiver = (IExitBroadcastReceiver)((IStructuredSelection)BroadcastReceiverPropertiesPanel.this.table.getSelection()).getFirstElement();
                ReceiverNameDialog rnd = new ReceiverNameDialog(BroadcastReceiverPropertiesPanel.this.getContainer().getShell());
                rnd.setName(receiver.getExitPattern());
                if (rnd.open() == 0) {
                    BroadcastReceiverPropertiesPanel.this.receivers.remove(receiver);
                    BroadcastReceiverPropertiesPanel.this.receivers.add((IExitBroadcastReceiver)new ExitBroadcastReceiver(rnd.getName()));
                    BroadcastReceiverPropertiesPanel.this.table.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IExitBroadcastReceiver receiver = (IExitBroadcastReceiver)((IStructuredSelection)BroadcastReceiverPropertiesPanel.this.table.getSelection()).getFirstElement();
                BroadcastReceiverPropertiesPanel.this.receivers.remove(receiver);
                BroadcastReceiverPropertiesPanel.this.table.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void save() {
        this.info.setExitBroadcastReceivers(this.receivers);
    }

    public void cancel() {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    public class ReceiverLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((IExitBroadcastReceiver)element).getExitPattern();
        }
    }
}

