/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.IWorkflowEntry;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationManager;
import org.eclipse.vtp.desktop.model.elements.core.internal.ApplicationFragmentElement;

public class FragmentEntrySelectionPropertiesPanel
extends DesignElementPropertiesPanel {
    Combo exitCombo = null;
    List<IWorkflowEntry> entryPoints = new ArrayList<IWorkflowEntry>();
    private FragmentConfigurationManager manager = null;
    IWorkflowEntry currentEntry = null;

    public FragmentEntrySelectionPropertiesPanel(String name, IDesignElement element) {
        super(name, element);
        this.manager = (FragmentConfigurationManager)element.getConfigurationManager("org.eclipse.vtp.configuration.include");
    }

    public void resolve() {
        ApplicationFragmentElement applicationFragmentElement = (ApplicationFragmentElement)this.getElement();
        if (applicationFragmentElement.isModelPresent()) {
            IWorkflowProject referencedModel = applicationFragmentElement.getReferencedModel();
            this.entryPoints = referencedModel.getWorkflowEntries();
            IWorkflowEntry defaultEntry = null;
            for (IWorkflowEntry entry : this.entryPoints) {
                if (entry.getName().equals("")) {
                    defaultEntry = entry;
                }
                if (defaultEntry != null) continue;
                defaultEntry = entry;
            }
            if (this.manager.getEntryId() != null) {
                for (IWorkflowEntry entry : this.entryPoints) {
                    if (!entry.getId().equals(this.manager.getEntryId())) continue;
                    this.currentEntry = entry;
                    break;
                }
            }
            if (this.currentEntry == null) {
                this.currentEntry = defaultEntry;
                if (defaultEntry != null) {
                    this.manager.setEntryId(defaultEntry.getId());
                }
            }
        }
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout();
        comp.setLayout((Layout)gridLayout);
        Label exitLabel = new Label(comp, 0);
        exitLabel.setText("Please select a Workflow Entry.");
        exitLabel.setBackground(comp.getBackground());
        exitLabel.setLayoutData((Object)new GridData());
        this.exitCombo = new Combo(comp, 12);
        for (IWorkflowEntry entryPoint : this.entryPoints) {
            this.exitCombo.add(entryPoint.getName());
            if (!entryPoint.equals(this.currentEntry)) continue;
            this.exitCombo.select(this.exitCombo.getItemCount() - 1);
        }
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        this.exitCombo.setLayoutData((Object)gridData);
        this.exitCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IWorkflowEntry entryPoint = FragmentEntrySelectionPropertiesPanel.this.entryPoints.get(FragmentEntrySelectionPropertiesPanel.this.exitCombo.getSelectionIndex());
                FragmentEntrySelectionPropertiesPanel.this.manager.setEntryId(entryPoint.getId());
            }
        });
    }

    public void save() {
        IWorkflowEntry entryPoint = this.entryPoints.get(this.exitCombo.getSelectionIndex());
        this.getElement().setName(String.valueOf(((ApplicationFragmentElement)this.getElement()).getReferencedModel().getProject().getName()) + " (" + entryPoint.getName() + ")");
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }
}

