/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.IWorkflowEntry;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationListener;
import org.eclipse.vtp.desktop.model.elements.core.configuration.FragmentConfigurationManager;
import org.eclipse.vtp.desktop.model.elements.core.configuration.InputBinding;
import org.eclipse.vtp.desktop.model.elements.core.configuration.InputBrandBinding;
import org.eclipse.vtp.desktop.model.elements.core.configuration.InputItem;
import org.eclipse.vtp.desktop.model.elements.core.internal.ApplicationFragmentElement;

public class FragmentVariableMappingPanel
extends DesignElementPropertiesPanel
implements FragmentConfigurationListener {
    private TableViewer expectedVariableViewer = null;
    private Button inheritButton = null;
    private Button noChangeButton = null;
    private Button staticButton = null;
    private Text staticText = null;
    private Button expressionButton = null;
    private Text expressionText = null;
    private Button appVariableButton = null;
    private TableViewer appVariableViewer = null;
    private List<Variable> inputVariables = Collections.emptyList();
    private FragmentConfigurationManager manager = null;
    private IBrand currentBrand = null;
    List<Variable> applicationVariables = new ArrayList<Variable>();
    private boolean updating = false;
    private Composite mappingComposite = null;

    public FragmentVariableMappingPanel(String name, IDesignElement element) {
        super(name, element);
        this.manager = (FragmentConfigurationManager)element.getConfigurationManager("org.eclipse.vtp.configuration.include");
        this.updateInputValues();
        this.manager.addListener((FragmentConfigurationListener)this);
        List vars = element.getDesign().getVariablesFor(element);
        block0: for (Variable v : vars) {
            int i = 0;
            while (i < this.applicationVariables.size()) {
                if (this.applicationVariables.get(i).getName().compareToIgnoreCase(v.getName()) > 0) {
                    this.applicationVariables.add(i, v);
                    continue block0;
                }
                ++i;
            }
            this.applicationVariables.add(v);
        }
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(2, true));
        Table expectedVariableTable = new Table(comp, 68100);
        expectedVariableTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(expectedVariableTable, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(150);
        TableColumn typeColumn = new TableColumn(expectedVariableTable, 0);
        typeColumn.setText("Variable Type");
        typeColumn.setWidth(150);
        this.expectedVariableViewer = new TableViewer(expectedVariableTable);
        this.expectedVariableViewer.setContentProvider((IContentProvider)new ExpectedVariableContentProvider());
        this.expectedVariableViewer.setLabelProvider((IBaseLabelProvider)new ExpectedVariableLabelProvider());
        this.expectedVariableViewer.setInput((Object)this);
        GridData gd = new GridData(1808);
        expectedVariableTable.setLayoutData((Object)gd);
        this.expectedVariableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FragmentVariableMappingPanel.this.currentBrand == null) {
                    return;
                }
                try {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        FragmentVariableMappingPanel.this.updating = true;
                        InputBinding vd = (InputBinding)selection.getFirstElement();
                        InputBrandBinding brandBinding = vd.getBrandBinding(FragmentVariableMappingPanel.this.currentBrand);
                        InputItem inputItem = brandBinding.getValue();
                        FragmentVariableMappingPanel.this.inheritButton.setSelection(false);
                        FragmentVariableMappingPanel.this.noChangeButton.setSelection(false);
                        FragmentVariableMappingPanel.this.staticButton.setSelection(false);
                        FragmentVariableMappingPanel.this.expressionButton.setSelection(false);
                        FragmentVariableMappingPanel.this.appVariableButton.setSelection(false);
                        if (brandBinding.hasParent() && brandBinding.isInherited()) {
                            FragmentVariableMappingPanel.this.inheritButton.setSelection(true);
                            FragmentVariableMappingPanel.this.staticText.setText("");
                            FragmentVariableMappingPanel.this.staticText.setEnabled(false);
                            FragmentVariableMappingPanel.this.expressionText.setText("");
                            FragmentVariableMappingPanel.this.expressionText.setEnabled(false);
                            FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                            FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(false);
                        } else {
                            String type = inputItem.getType();
                            if (type.equals("NONE")) {
                                FragmentVariableMappingPanel.this.noChangeButton.setSelection(true);
                                FragmentVariableMappingPanel.this.staticText.setText("");
                                FragmentVariableMappingPanel.this.staticText.setEnabled(false);
                                FragmentVariableMappingPanel.this.expressionText.setText("");
                                FragmentVariableMappingPanel.this.expressionText.setEnabled(false);
                                FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                                FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(false);
                            } else if (type.equals("STATIC")) {
                                FragmentVariableMappingPanel.this.staticButton.setSelection(true);
                                FragmentVariableMappingPanel.this.staticText.setText(inputItem.getValue());
                                FragmentVariableMappingPanel.this.staticText.setEnabled(true);
                                FragmentVariableMappingPanel.this.expressionText.setText("");
                                FragmentVariableMappingPanel.this.expressionText.setEnabled(false);
                                FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                                FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(false);
                            } else if (type.equals("EXPRESSION")) {
                                FragmentVariableMappingPanel.this.expressionButton.setSelection(true);
                                FragmentVariableMappingPanel.this.staticText.setText("");
                                FragmentVariableMappingPanel.this.staticText.setEnabled(false);
                                FragmentVariableMappingPanel.this.expressionText.setText(inputItem.getValue());
                                FragmentVariableMappingPanel.this.expressionText.setEnabled(true);
                                FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                                FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(false);
                            } else if (type.equals("VARIABLE")) {
                                FragmentVariableMappingPanel.this.staticText.setText("");
                                FragmentVariableMappingPanel.this.staticText.setEnabled(false);
                                FragmentVariableMappingPanel.this.expressionText.setText("");
                                FragmentVariableMappingPanel.this.expressionText.setEnabled(false);
                                FragmentVariableMappingPanel.this.appVariableButton.setSelection(true);
                                for (Variable v : FragmentVariableMappingPanel.this.applicationVariables) {
                                    if (!v.getName().equals(inputItem.getValue())) continue;
                                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
                                }
                                FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(true);
                            } else {
                                throw new RuntimeException("Unknown mapping type found.");
                            }
                        }
                        FragmentVariableMappingPanel.this.updating = false;
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        });
        this.mappingComposite = new Composite(comp, 0);
        gd = new GridData(1808);
        this.mappingComposite.setLayoutData((Object)gd);
        this.mappingComposite.setBackground(comp.getBackground());
        this.mappingComposite.setLayout((Layout)new GridLayout(1, false));
        this.inheritButton = new Button(this.mappingComposite, 16);
        this.inheritButton.setBackground(this.mappingComposite.getBackground());
        this.inheritButton.setText("Inherit from parent Brand");
        gd = new GridData(768);
        gd.exclude = true;
        this.inheritButton.setLayoutData((Object)gd);
        this.inheritButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection;
                if (FragmentVariableMappingPanel.this.updating) {
                    return;
                }
                FragmentVariableMappingPanel.this.updating = true;
                if (FragmentVariableMappingPanel.this.inheritButton.getSelection() && !(selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection()).isEmpty()) {
                    FragmentVariableMappingPanel.this.staticText.setText("");
                    FragmentVariableMappingPanel.this.staticText.setEnabled(false);
                    FragmentVariableMappingPanel.this.expressionText.setText("");
                    FragmentVariableMappingPanel.this.expressionText.setEnabled(false);
                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                    FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(false);
                    InputBinding vd = (InputBinding)selection.getFirstElement();
                    InputBrandBinding brandBinding = vd.getBrandBinding(FragmentVariableMappingPanel.this.currentBrand);
                    brandBinding.setValue(null);
                }
                FragmentVariableMappingPanel.this.updating = false;
            }
        });
        this.noChangeButton = new Button(this.mappingComposite, 16);
        this.noChangeButton.setBackground(this.mappingComposite.getBackground());
        this.noChangeButton.setText("Do not change this variable");
        gd = new GridData(768);
        this.noChangeButton.setLayoutData((Object)gd);
        this.noChangeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection;
                if (FragmentVariableMappingPanel.this.updating) {
                    return;
                }
                FragmentVariableMappingPanel.this.updating = true;
                if (FragmentVariableMappingPanel.this.noChangeButton.getSelection() && !(selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection()).isEmpty()) {
                    FragmentVariableMappingPanel.this.staticText.setText("");
                    FragmentVariableMappingPanel.this.staticText.setEnabled(false);
                    FragmentVariableMappingPanel.this.expressionText.setText("");
                    FragmentVariableMappingPanel.this.expressionText.setEnabled(false);
                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                    FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(false);
                    InputBinding vd = (InputBinding)selection.getFirstElement();
                    InputBrandBinding brandBinding = vd.getBrandBinding(FragmentVariableMappingPanel.this.currentBrand);
                    InputItem inputItem = brandBinding.getValue();
                    if (brandBinding.isInherited()) {
                        inputItem = new InputItem();
                    }
                    inputItem.setType("NONE");
                    inputItem.setValue("");
                    brandBinding.setValue(inputItem);
                }
                FragmentVariableMappingPanel.this.updating = false;
            }
        });
        this.staticButton = new Button(this.mappingComposite, 16);
        this.staticButton.setBackground(this.mappingComposite.getBackground());
        this.staticButton.setText("Use this value");
        gd = new GridData(768);
        this.staticButton.setLayoutData((Object)gd);
        this.staticButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection;
                if (FragmentVariableMappingPanel.this.updating) {
                    return;
                }
                FragmentVariableMappingPanel.this.updating = true;
                if (FragmentVariableMappingPanel.this.staticButton.getSelection() && !(selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection()).isEmpty()) {
                    FragmentVariableMappingPanel.this.staticText.setText("");
                    FragmentVariableMappingPanel.this.staticText.setEnabled(true);
                    FragmentVariableMappingPanel.this.expressionText.setText("");
                    FragmentVariableMappingPanel.this.expressionText.setEnabled(false);
                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                    FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(false);
                    InputBinding vd = (InputBinding)selection.getFirstElement();
                    InputBrandBinding brandBinding = vd.getBrandBinding(FragmentVariableMappingPanel.this.currentBrand);
                    InputItem inputItem = brandBinding.getValue();
                    if (brandBinding.isInherited()) {
                        inputItem = new InputItem();
                    }
                    inputItem.setType("STATIC");
                    inputItem.setValue("");
                    brandBinding.setValue(inputItem);
                }
                FragmentVariableMappingPanel.this.updating = false;
            }
        });
        this.staticText = new Text(this.mappingComposite, 2052);
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        this.staticText.setLayoutData((Object)gd);
        this.staticText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FragmentVariableMappingPanel.this.updating) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection();
                if (!selection.isEmpty()) {
                    InputBinding vd = (InputBinding)selection.getFirstElement();
                    InputBrandBinding brandBinding = vd.getBrandBinding(FragmentVariableMappingPanel.this.currentBrand);
                    InputItem inputItem = brandBinding.getValue();
                    if (brandBinding.isInherited()) {
                        inputItem = new InputItem();
                    }
                    inputItem.setValue(FragmentVariableMappingPanel.this.staticText.getText());
                    brandBinding.setValue(inputItem);
                }
            }
        });
        this.expressionButton = new Button(this.mappingComposite, 16);
        this.expressionButton.setBackground(this.mappingComposite.getBackground());
        this.expressionButton.setText("Use this Javascript expression");
        gd = new GridData(768);
        this.expressionButton.setLayoutData((Object)gd);
        this.expressionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection;
                if (FragmentVariableMappingPanel.this.updating) {
                    return;
                }
                FragmentVariableMappingPanel.this.updating = true;
                if (FragmentVariableMappingPanel.this.expressionButton.getSelection() && !(selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection()).isEmpty()) {
                    FragmentVariableMappingPanel.this.staticText.setText("");
                    FragmentVariableMappingPanel.this.staticText.setEnabled(false);
                    FragmentVariableMappingPanel.this.expressionText.setText("");
                    FragmentVariableMappingPanel.this.expressionText.setEnabled(true);
                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                    FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(false);
                    InputBinding vd = (InputBinding)selection.getFirstElement();
                    InputBrandBinding brandBinding = vd.getBrandBinding(FragmentVariableMappingPanel.this.currentBrand);
                    InputItem inputItem = brandBinding.getValue();
                    if (brandBinding.isInherited()) {
                        inputItem = new InputItem();
                    }
                    inputItem.setType("EXPRESSION");
                    inputItem.setValue("");
                    brandBinding.setValue(inputItem);
                }
                FragmentVariableMappingPanel.this.updating = false;
            }
        });
        this.expressionText = new Text(this.mappingComposite, 2052);
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        this.expressionText.setLayoutData((Object)gd);
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FragmentVariableMappingPanel.this.updating) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection();
                if (!selection.isEmpty()) {
                    InputBinding vd = (InputBinding)selection.getFirstElement();
                    InputBrandBinding brandBinding = vd.getBrandBinding(FragmentVariableMappingPanel.this.currentBrand);
                    InputItem inputItem = brandBinding.getValue();
                    if (brandBinding.isInherited()) {
                        inputItem = new InputItem();
                    }
                    inputItem.setValue(FragmentVariableMappingPanel.this.expressionText.getText());
                    brandBinding.setValue(inputItem);
                }
            }
        });
        this.appVariableButton = new Button(this.mappingComposite, 16);
        this.appVariableButton.setBackground(this.mappingComposite.getBackground());
        this.appVariableButton.setText("Use this application variable");
        gd = new GridData(768);
        this.appVariableButton.setLayoutData((Object)gd);
        this.appVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection;
                if (FragmentVariableMappingPanel.this.updating) {
                    return;
                }
                FragmentVariableMappingPanel.this.updating = true;
                if (FragmentVariableMappingPanel.this.appVariableButton.getSelection() && !(selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection()).isEmpty()) {
                    FragmentVariableMappingPanel.this.staticText.setText("");
                    FragmentVariableMappingPanel.this.staticText.setEnabled(false);
                    FragmentVariableMappingPanel.this.expressionText.setText("");
                    FragmentVariableMappingPanel.this.expressionText.setEnabled(false);
                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                    FragmentVariableMappingPanel.this.appVariableViewer.getControl().setEnabled(true);
                    InputBinding vd = (InputBinding)selection.getFirstElement();
                    InputBrandBinding brandBinding = vd.getBrandBinding(FragmentVariableMappingPanel.this.currentBrand);
                    InputItem inputItem = brandBinding.getValue();
                    if (brandBinding.isInherited()) {
                        inputItem = new InputItem();
                    }
                    inputItem.setType("VARIABLE");
                    inputItem.setValue("");
                    brandBinding.setValue(inputItem);
                }
                FragmentVariableMappingPanel.this.updating = false;
            }
        });
        Table appVariableTable = new Table(this.mappingComposite, 68100);
        appVariableTable.setHeaderVisible(true);
        TableColumn appVariableNameColumn = new TableColumn(appVariableTable, 0);
        appVariableNameColumn.setText("Variable Name");
        appVariableNameColumn.setWidth(150);
        TableColumn appVariableTypeColumn = new TableColumn(appVariableTable, 0);
        appVariableTypeColumn.setText("Variable Type");
        appVariableTypeColumn.setWidth(150);
        this.appVariableViewer = new TableViewer(appVariableTable);
        this.appVariableViewer.setContentProvider((IContentProvider)new ApplicationVariableContentProvider());
        this.appVariableViewer.setLabelProvider((IBaseLabelProvider)new ApplicationVariableLabelProvider());
        this.appVariableViewer.setInput((Object)this);
        gd = new GridData(1808);
        gd.horizontalIndent = 15;
        this.appVariableViewer.getControl().setLayoutData((Object)gd);
        this.appVariableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FragmentVariableMappingPanel.this.updating) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection();
                if (!selection.isEmpty()) {
                    StructuredSelection appSel;
                    InputBinding vd = (InputBinding)selection.getFirstElement();
                    InputBrandBinding brandBinding = vd.getBrandBinding(FragmentVariableMappingPanel.this.currentBrand);
                    InputItem inputItem = brandBinding.getValue();
                    if (brandBinding.isInherited()) {
                        inputItem = new InputItem();
                    }
                    if ((appSel = (StructuredSelection)event.getSelection()).isEmpty()) {
                        inputItem.setValue("");
                    } else {
                        inputItem.setValue(((Variable)appSel.getFirstElement()).getName());
                    }
                    brandBinding.setValue(inputItem);
                }
            }
        });
        this.setControl((Control)comp);
    }

    public void save() {
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.manager);
    }

    public void setConfigurationContext(Map<String, Object> values) {
        Object obj = values.get("org.eclipse.vtp.desktop.model.core.brandcontext");
        if (obj != null) {
            this.currentBrand = (IBrand)obj;
            ((GridData)this.inheritButton.getLayoutData()).exclude = this.currentBrand.getParent() == null;
            this.inheritButton.setVisible(this.currentBrand.getParent() != null);
            this.mappingComposite.layout(true, true);
            this.expectedVariableViewer.setSelection((ISelection)(this.manager.getInputBindings().size() < 1 ? StructuredSelection.EMPTY : new StructuredSelection(this.manager.getInputBindings().get(0))));
        }
    }

    public void updateInputValues() {
        IWorkflowEntry entry;
        String entryId;
        this.inputVariables = Collections.emptyList();
        ApplicationFragmentElement applicationFragmentElement = (ApplicationFragmentElement)this.getElement();
        if (applicationFragmentElement.isModelPresent() && (entryId = this.manager.getEntryId()) != null && !entryId.equals("") && (entry = applicationFragmentElement.getReferencedModel().getWorkflowEntry(entryId)) != null) {
            this.inputVariables = entry.getInputVariables();
            System.err.println("inputVariables: " + this.inputVariables);
        }
        LinkedList oldBindings = new LinkedList(this.manager.getInputBindings());
        for (Variable v : this.inputVariables) {
            if (v.getType().isObject() || v.getType().hasBaseType() && v.getType().isObjectBaseType()) continue;
            this.manager.addInputBinding(v.getName());
        }
        block1: for (InputBinding binding : oldBindings) {
            for (Variable v : this.inputVariables) {
                if (v.getName().equals(binding.getInput())) continue block1;
            }
            this.manager.removeInputBinding(binding.getInput());
        }
        System.err.println(this.manager.getInputBindings());
    }

    public void entryChanged(FragmentConfigurationManager manager) {
        this.updateInputValues();
        if (this.expectedVariableViewer != null) {
            this.expectedVariableViewer.refresh();
            if (this.expectedVariableViewer.getSelection().isEmpty()) {
                this.expectedVariableViewer.setSelection((ISelection)(manager.getInputBindings().size() < 1 ? StructuredSelection.EMPTY : new StructuredSelection(manager.getInputBindings().get(0))));
            }
        }
    }

    private class ApplicationVariableContentProvider
    implements IStructuredContentProvider {
        private ApplicationVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return FragmentVariableMappingPanel.this.applicationVariables.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ApplicationVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ApplicationVariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Variable v = (Variable)element;
            if (columnIndex == 0) {
                return v.getName();
            }
            if (columnIndex == 1) {
                StringBuffer buf = new StringBuffer();
                buf.append(v.getType().getName());
                if (v.getType().hasBaseType()) {
                    buf.append(" of ");
                    buf.append(v.getType().getBaseTypeName());
                }
                return buf.toString();
            }
            return "Unknown Column";
        }
    }

    private class ExpectedVariableContentProvider
    implements IStructuredContentProvider {
        private ExpectedVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return FragmentVariableMappingPanel.this.manager.getInputBindings().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ExpectedVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ExpectedVariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            InputBinding vd = (InputBinding)element;
            if (columnIndex == 0) {
                return vd.getInput();
            }
            if (columnIndex == 1) {
                for (Variable v : FragmentVariableMappingPanel.this.inputVariables) {
                    if (!v.getName().equals(vd.getInput())) continue;
                    StringBuffer buf = new StringBuffer();
                    buf.append(v.getType().getName());
                    if (v.getType().hasBaseType()) {
                        buf.append(" of ");
                        buf.append(v.getType().getBaseTypeName());
                    }
                    return buf.toString();
                }
                return "";
            }
            return "Unknown Column";
        }
    }
}

