/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.dialogs.FramedDialog;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.framework.util.VariableNameValidator;

public class NewVariableDialog
extends FramedDialog {
    Color darkBlue;
    Color lightBlue;
    Text nameField;
    Combo typeCombo;
    Combo baseTypeCombo;
    Button secureButton;
    String name;
    FieldType type;
    Button okButton;
    List<String> reservedNames;
    IBusinessObjectSet businessObjectSet;
    boolean secure = false;
    Label nameLabel;

    public NewVariableDialog(Shell shell, List<String> reservedNames, IBusinessObjectSet businessObjectSet) {
        super(shell);
        this.setSideBarSize(40);
        this.setTitle("New Variable");
        this.reservedNames = reservedNames;
        this.businessObjectSet = businessObjectSet;
    }

    protected void createButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite buttons = new Composite(parent, 0);
        buttons.setBackground(parent.getBackground());
        GridData buttonsData = new GridData(1808);
        buttonsData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)buttonsData);
        RowLayout rl = new RowLayout();
        rl.pack = false;
        rl.spacing = 5;
        buttons.setLayout((Layout)rl);
        this.okButton = new Button(buttons, 8);
        this.okButton.setText("Ok");
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewVariableDialog.this.okPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button cancelButton = new Button(buttons, 8);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewVariableDialog.this.cancelPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (Display.getCurrent().getDismissalAlignment() == 131072) {
            cancelButton.moveAbove((Control)this.okButton);
        }
        this.getShell().setDefaultButton(this.okButton);
    }

    public void okPressed() {
        FieldType.Primitive basePrim;
        this.name = this.nameField.getText();
        FieldType.Primitive prim = FieldType.Primitive.find((String)this.typeCombo.getItem(this.typeCombo.getSelectionIndex()));
        this.type = prim != null ? (prim.hasBaseType() ? ((basePrim = FieldType.Primitive.find((String)this.baseTypeCombo.getItem(this.baseTypeCombo.getSelectionIndex()))) != null ? new FieldType(prim, basePrim) : new FieldType(prim, this.businessObjectSet.getBusinessObject(this.baseTypeCombo.getItem(this.baseTypeCombo.getSelectionIndex())))) : new FieldType(prim)) : new FieldType(this.businessObjectSet.getBusinessObject(this.typeCombo.getItem(this.typeCombo.getSelectionIndex())));
        this.secure = this.secureButton.getSelection();
        this.setReturnCode(32);
        this.close();
    }

    public void cancelPressed() {
        this.setReturnCode(256);
        this.close();
    }

    protected void createDialogContents(Composite parent) {
        this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
        this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NewVariableDialog.this.darkBlue.dispose();
                NewVariableDialog.this.lightBlue.dispose();
            }
        });
        this.setFrameColor(this.darkBlue);
        this.setSideBarColor(this.lightBlue);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText("Name");
        this.nameLabel.setForeground(this.nameLabel.getDisplay().getSystemColor(3));
        this.nameLabel.setBackground(parent.getBackground());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameLabel.setLayoutData((Object)gd);
        this.nameField = new Text(parent, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        this.nameField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String currentName = String.valueOf(NewVariableDialog.this.nameField.getText().substring(0, e.start)) + e.text + NewVariableDialog.this.nameField.getText(e.end, NewVariableDialog.this.nameField.getText().length() - 1);
                if (VariableNameValidator.followsVtpNamingRules((String)currentName).booleanValue()) {
                    NewVariableDialog.this.nameLabel.setForeground(NewVariableDialog.this.nameLabel.getDisplay().getSystemColor(2));
                    NewVariableDialog.this.nameField.setForeground(NewVariableDialog.this.nameField.getDisplay().getSystemColor(2));
                    NewVariableDialog.this.okButton.setEnabled(true);
                    int b = 0;
                    while (b < NewVariableDialog.this.reservedNames.size()) {
                        if (currentName.equals(NewVariableDialog.this.reservedNames.get(b))) {
                            NewVariableDialog.this.nameLabel.setForeground(NewVariableDialog.this.nameLabel.getDisplay().getSystemColor(3));
                            NewVariableDialog.this.nameField.setForeground(NewVariableDialog.this.nameField.getDisplay().getSystemColor(3));
                            NewVariableDialog.this.okButton.setEnabled(false);
                        }
                        ++b;
                    }
                } else {
                    NewVariableDialog.this.nameLabel.setForeground(NewVariableDialog.this.nameLabel.getDisplay().getSystemColor(3));
                    NewVariableDialog.this.nameField.setForeground(NewVariableDialog.this.nameField.getDisplay().getSystemColor(3));
                    NewVariableDialog.this.okButton.setEnabled(false);
                }
            }
        });
        Label typeLabel = new Label(parent, 0);
        typeLabel.setText("Type");
        typeLabel.setBackground(parent.getBackground());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        typeLabel.setLayoutData((Object)gd);
        this.typeCombo = new Combo(parent, 2060);
        this.typeCombo.add("String");
        this.typeCombo.add("Number");
        this.typeCombo.add("Decimal");
        this.typeCombo.add("Boolean");
        this.typeCombo.add("DateTime");
        this.typeCombo.add("Array");
        this.typeCombo.add("Map");
        this.typeCombo.select(0);
        this.typeCombo.setLayoutData((Object)new GridData(768));
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FieldType.Primitive prim = FieldType.Primitive.find((String)NewVariableDialog.this.typeCombo.getItem(NewVariableDialog.this.typeCombo.getSelectionIndex()));
                NewVariableDialog.this.baseTypeCombo.setEnabled(prim != null && prim.hasBaseType());
                NewVariableDialog.this.baseTypeCombo.select(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.baseTypeCombo = new Combo(parent, 2060);
        this.baseTypeCombo.add("ANYTYPE");
        this.baseTypeCombo.add("String");
        this.baseTypeCombo.add("Number");
        this.baseTypeCombo.add("Decimal");
        this.baseTypeCombo.add("Boolean");
        this.baseTypeCombo.add("DateTime");
        this.baseTypeCombo.setEnabled(false);
        this.baseTypeCombo.select(0);
        this.baseTypeCombo.setLayoutData((Object)new GridData());
        List businessObjects = this.businessObjectSet.getBusinessObjects();
        int i = 0;
        while (i < businessObjects.size()) {
            IBusinessObject ibo = (IBusinessObject)businessObjects.get(i);
            this.typeCombo.add(ibo.getName());
            this.baseTypeCombo.add(ibo.getName());
            ++i;
        }
        this.secureButton = new Button(parent, 32);
        this.secureButton.setText("Make this variable secure");
        this.secureButton.setSelection(false);
        this.secureButton.setBackground(parent.getBackground());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.secureButton.setLayoutData((Object)gd);
        this.nameField.setFocus();
    }
}

