/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignFolder;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IDesignRootFolder;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignEntryPoint;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.PortalEntryInformationProvider;

public class PortalEntryPropertiesPanel
extends DesignElementPropertiesPanel {
    Combo exitCombo = null;
    List<IDesignEntryPoint> entryPoints = new ArrayList<IDesignEntryPoint>();
    PortalEntryInformationProvider info;

    public PortalEntryPropertiesPanel(String name, IDesignElement element) {
        super(name, element);
        this.info = (PortalEntryInformationProvider)((PrimitiveElement)element).getInformationProvider();
        this.entryPoints.addAll(element.getDesign().getDocument().getDesignEntryPoints());
        IDesignItemContainer container = element.getDesign().getDocument().getParentDesignContainer();
        while (!(container instanceof IDesignRootFolder)) {
            container = (IDesignItemContainer)container.getParent();
        }
        this.traverseDesigns(container);
    }

    private void traverseDesigns(IDesignItemContainer container) {
        List documents = container.getDesignDocuments();
        for (IDesignDocument document : documents) {
            if (document.equals(this.getElement().getDesign().getDocument())) continue;
            this.entryPoints.addAll(document.getDesignEntryPoints());
        }
        List folders = container.getDesignFolders();
        for (IDesignFolder folder : folders) {
            this.traverseDesigns((IDesignItemContainer)folder);
        }
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout();
        comp.setLayout((Layout)gridLayout);
        Label exitLabel = new Label(comp, 0);
        exitLabel.setText("Please select the Portal exit for this entry element.");
        exitLabel.setBackground(comp.getBackground());
        exitLabel.setLayoutData((Object)new GridData());
        this.exitCombo = new Combo(comp, 12);
        for (IDesignEntryPoint entryPoint : this.entryPoints) {
            this.exitCombo.add(entryPoint.getName());
        }
        if (this.info.getExitId() != null) {
            int i = 0;
            while (i < this.entryPoints.size()) {
                IDesignEntryPoint entryPoint = this.entryPoints.get(i);
                if (entryPoint.getId().equals(this.info.getExitId())) {
                    this.exitCombo.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.exitCombo.select(0);
        }
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        this.exitCombo.setLayoutData((Object)gridData);
    }

    public void save() {
        IDesignEntryPoint entryPoint = this.entryPoints.get(this.exitCombo.getSelectionIndex());
        this.info.setExitId(entryPoint.getId());
        this.getElement().setName(entryPoint.getName());
    }

    public void cancel() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }
}

