/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignFolder;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IDesignRootFolder;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignEntryPoint;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.PortalExitInformationProvider;

public class PortalExitGeneralPropertiesPanel
extends DesignElementPropertiesPanel {
    Label nameLabel;
    Text nameField;
    Label errorField;
    Label referencesLabel;
    PortalExitInformationProvider info;
    List<IDesignEntryPoint> entryPoints = new ArrayList<IDesignEntryPoint>();

    public PortalExitGeneralPropertiesPanel(String name, IDesignElement ppe) {
        super(name, ppe);
        this.info = (PortalExitInformationProvider)((PrimitiveElement)ppe).getInformationProvider();
        this.entryPoints.addAll(ppe.getDesign().getDocument().getDesignEntryPoints());
        IDesignItemContainer container = ppe.getDesign().getDocument().getParentDesignContainer();
        while (!(container instanceof IDesignRootFolder)) {
            container = (IDesignItemContainer)container.getParent();
        }
        this.traverseDesigns(container);
    }

    private void traverseDesigns(IDesignItemContainer container) {
        List documents = container.getDesignDocuments();
        for (IDesignDocument document : documents) {
            if (document.equals(this.getElement().getDesign().getDocument())) continue;
            this.entryPoints.addAll(document.getDesignEntryPoints());
        }
        List folders = container.getDesignFolders();
        for (IDesignFolder folder : folders) {
            this.traverseDesigns((IDesignItemContainer)folder);
        }
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(2, false));
        this.nameLabel = new Label(comp, 0);
        this.nameLabel.setText("Name: ");
        this.nameLabel.setBackground(comp.getBackground());
        this.nameLabel.setLayoutData((Object)new GridData(4));
        this.nameField = new Text(comp, 2052);
        this.nameField.setLayoutData((Object)new GridData(772));
        this.errorField = new Label(comp, 4);
        this.errorField.setBackground(comp.getBackground());
        this.errorField.setForeground(comp.getDisplay().getSystemColor(3));
        this.referencesLabel = new Label(comp, 0);
        this.referencesLabel.setText("Entries associated with this Exit: " + this.info.getConnectingPoints().size());
        this.referencesLabel.setBackground(comp.getBackground());
        this.referencesLabel.setLayoutData((Object)new GridData(4));
        GridData gd = new GridData(832);
        gd.horizontalSpan = 2;
        this.errorField.setLayoutData((Object)gd);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (IDesignEntryPoint entryPoint : PortalExitGeneralPropertiesPanel.this.entryPoints) {
                    if (entryPoint.getId().equals(PortalExitGeneralPropertiesPanel.this.getElement().getId()) || !entryPoint.getName().equals(PortalExitGeneralPropertiesPanel.this.nameField.getText())) continue;
                    PortalExitGeneralPropertiesPanel.this.errorField.setText("There is already a Portal with that name.");
                    PortalExitGeneralPropertiesPanel.this.getContainer().setCanFinish(false);
                    return;
                }
                PortalExitGeneralPropertiesPanel.this.errorField.setText("");
                PortalExitGeneralPropertiesPanel.this.getContainer().setCanFinish(true);
            }
        });
        this.nameField.setText(this.getElement().getName());
        for (IDesignEntryPoint entryPoint : this.entryPoints) {
            if (entryPoint.getId().equals(this.getElement().getId()) || !entryPoint.getName().equals(this.nameField.getText())) continue;
            this.errorField.setText("There is already a Portal with that name.");
            this.getContainer().setCanFinish(false);
            return;
        }
        this.errorField.setText("");
        this.getContainer().setCanFinish(true);
        this.setControl((Control)comp);
    }

    public void save() {
        this.getElement().setName(this.nameField.getText());
    }

    public void cancel() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }
}

