/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.standard.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.vtp.desktop.editors.core.configuration.DesignElementPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.modules.standard.ui.ReturnInformationProvider;

public class ReturnVariablesPropertyPanel
extends DesignElementPropertiesPanel {
    List<String> exportedVars;
    CheckboxTableViewer variableViewer;
    List<Variable> variables = new ArrayList<Variable>();
    private ReturnInformationProvider info = null;

    public ReturnVariablesPropertyPanel(String name, IDesignElement element) {
        super(name, element);
        this.info = (ReturnInformationProvider)((PrimitiveElement)element).getInformationProvider();
        this.exportedVars = new ArrayList<String>(this.info.getExports());
        List vars = element.getDesign().getVariablesFor(element);
        block0: for (Variable v : vars) {
            int i = 0;
            while (i < this.variables.size()) {
                if (this.variables.get(i).getName().compareToIgnoreCase(v.getName()) > 0) {
                    this.variables.add(i, v);
                    continue block0;
                }
                ++i;
            }
            this.variables.add(v);
        }
    }

    public void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Table variableTable = new Table(parent, 67620);
        variableTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(variableTable, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(150);
        TableColumn typeColumn = new TableColumn(variableTable, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(150);
        GridData gd = new GridData(1040);
        gd.verticalSpan = 2;
        gd.widthHint = 505;
        gd.heightHint = 200;
        variableTable.setLayoutData((Object)gd);
        this.variableViewer = new CheckboxTableViewer(variableTable);
        this.variableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ReturnVariablesPropertyPanel.this.exportedVars.remove(((Variable)event.getElement()).getName());
                if (event.getChecked()) {
                    ReturnVariablesPropertyPanel.this.exportedVars.add(((Variable)event.getElement()).getName());
                }
            }
        });
        this.variableViewer.setColumnProperties(new String[]{"Name", "Type", "Value"});
        this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.variableViewer.setInput((Object)this);
        for (Variable vd : this.variables) {
            this.variableViewer.setChecked((Object)vd, this.exportedVars.contains(vd.getName()));
        }
    }

    public void save() {
        this.info.setExports(this.exportedVars);
    }

    public void cancel() {
    }

    public void setConfigurationContext(Map<String, Object> values) {
    }

    public List<String> getApplicableContexts() {
        return Collections.emptyList();
    }

    public class VariableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            ArrayList<Variable> ret = new ArrayList<Variable>();
            int i = 0;
            while (i < ReturnVariablesPropertyPanel.this.variables.size()) {
                if (!ReturnVariablesPropertyPanel.this.variables.get(i).getType().isObject()) {
                    ret.add(ReturnVariablesPropertyPanel.this.variables.get(i));
                }
                ++i;
            }
            return ret.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Variable vd = (Variable)element;
            if (columnIndex == 0) {
                return vd.getName();
            }
            if (columnIndex == 1) {
                StringBuffer buf = new StringBuffer();
                buf.append(vd.getType().getName());
                if (vd.getType().hasBaseType()) {
                    buf.append(" of ");
                    buf.append(vd.getType().getBaseTypeName());
                }
                return buf.toString();
            }
            return "N/A";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

