/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.automata;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.modules.webservice.ui.automata.Graph;
import org.eclipse.vtp.modules.webservice.ui.automata.Node;
import org.eclipse.vtp.modules.webservice.ui.automata.Transition;

public class GraphContext {
    private Graph graph = null;
    private Node currentNode = null;
    private boolean error = false;
    private boolean finalSuggestionsMade = false;
    private Map<Transition, Integer> transitionCounters = new HashMap<Transition, Integer>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public GraphContext(Graph graph) {
        this.graph = graph;
        this.currentNode = graph.getInitialNode();
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public int getTransitionCount(Transition transition) {
        Integer count = this.transitionCounters.get(transition);
        return count == null ? 0 : count;
    }

    public void performTransition(Transition transition) {
        Integer i = this.transitionCounters.get(transition);
        if (i == null) {
            i = new Integer(0);
        }
        i = i + 1;
        this.transitionCounters.put(transition, i);
        this.currentNode = transition.getDestination();
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public boolean hasError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean hasMadeFinalSuggestions() {
        return this.finalSuggestionsMade;
    }

    public void madeFinalSuggestions(boolean bool) {
        this.finalSuggestionsMade = bool;
    }

    public GraphContext clone() {
        GraphContext copy = new GraphContext(this.graph);
        copy.transitionCounters.putAll(this.transitionCounters);
        copy.currentNode = this.currentNode;
        copy.properties.putAll(this.properties);
        return copy;
    }
}

