/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.modules.webservice.ui.configuration.document;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.modules.webservice.ui.configuration.WebserviceBindingManager;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ConditionalDocumentItem;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.DocumentItemContainer;
import org.eclipse.vtp.modules.webservice.ui.configuration.document.ElseDocumentItem;
import org.w3c.dom.Element;

public class ConditionalContainerSet
extends DocumentItemContainer {
    private ConditionalDocumentItem ifItem = null;
    private List<ConditionalDocumentItem> elseIfItems = new ArrayList<ConditionalDocumentItem>();
    private ElseDocumentItem elseItem = null;

    public ConditionalContainerSet(WebserviceBindingManager manager) {
        super(manager);
    }

    public ConditionalDocumentItem getIf() {
        return this.ifItem;
    }

    public void setIf(ConditionalDocumentItem ifItem) {
        if (this.ifItem != null) {
            this.ifItem.setParent(null);
        }
        this.ifItem = ifItem;
        ifItem.setParent(this);
    }

    public List<ConditionalDocumentItem> getElseIfs() {
        return this.elseIfItems;
    }

    public void addItem(ConditionalDocumentItem item) {
        this.elseIfItems.add(item);
        item.setParent(this);
    }

    public void insertItem(ConditionalDocumentItem item, int index) {
        this.elseIfItems.add(index, item);
        item.setParent(this);
    }

    public void removeItem(ConditionalDocumentItem item) {
        this.elseIfItems.remove(item);
        item.setParent(null);
    }

    public ElseDocumentItem getElse() {
        return this.elseItem;
    }

    public void setElse(ElseDocumentItem elseItem) {
        if (this.elseItem != null) {
            this.elseItem.setParent(null);
        }
        this.elseItem = elseItem;
        if (elseItem != null) {
            elseItem.setParent(this);
        }
    }

    @Override
    public Element createConfigurationElement(Element parentElement) {
        Element conditionalContainerElement = parentElement.getOwnerDocument().createElementNS(null, "conditional-container");
        parentElement.appendChild(conditionalContainerElement);
        return conditionalContainerElement;
    }

    @Override
    public void readConfiguration(Element conditionalContainerElement) {
        List conditionalElementList = XMLUtilities.getElementsByTagName((Element)conditionalContainerElement, (String)"conditional-item", (boolean)true);
        for (Element conditionalElement : conditionalElementList) {
            ConditionalDocumentItem conditionalItem = new ConditionalDocumentItem(this.getManager());
            conditionalItem.readConfiguration(conditionalElement);
            if (this.ifItem == null) {
                this.ifItem = conditionalItem;
            } else {
                this.elseIfItems.add(conditionalItem);
            }
            conditionalItem.setParent(this);
        }
        List elseElementList = XMLUtilities.getElementsByTagName((Element)conditionalContainerElement, (String)"else-item", (boolean)true);
        if (elseElementList.size() > 0) {
            ElseDocumentItem elseItem = new ElseDocumentItem(this.getManager());
            elseItem.readConfiguration((Element)elseElementList.get(0));
            this.elseItem = elseItem;
            elseItem.setParent(this);
        }
    }

    @Override
    public void writeConfiguration(Element conditionalContainerElement) {
        if (this.ifItem != null) {
            Element conditionalElement = conditionalContainerElement.getOwnerDocument().createElementNS(null, "conditional-item");
            conditionalContainerElement.appendChild(conditionalElement);
            this.ifItem.writeConfiguration(conditionalElement);
            for (ConditionalDocumentItem conditionalItem : this.elseIfItems) {
                conditionalElement = conditionalContainerElement.getOwnerDocument().createElementNS(null, "conditional-item");
                conditionalContainerElement.appendChild(conditionalElement);
                conditionalItem.writeConfiguration(conditionalElement);
            }
            if (this.elseItem != null) {
                conditionalElement = conditionalContainerElement.getOwnerDocument().createElementNS(null, "else-item");
                conditionalContainerElement.appendChild(conditionalElement);
                this.elseItem.writeConfiguration(conditionalElement);
            }
        }
    }

    @Override
    public void dumpContents(PrintStream out) {
        out.println("[Conditional Container]");
        out.println("Conditionals:");
        if (this.ifItem != null) {
            this.ifItem.dumpContents(out);
            for (ConditionalDocumentItem elseIfItem : this.elseIfItems) {
                elseIfItem.dumpContents(out);
            }
            if (this.elseItem != null) {
                this.elseItem.dumpContents(out);
            }
        }
    }
}

